/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog.remote.service;

import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.catalog.remote.XBRXName;
import org.exbin.xbup.client.catalog.remote.manager.XBRXNameManager;
import org.exbin.xbup.client.catalog.remote.service.XBRDefaultService;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCExtension;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.manager.XBCXNameManager;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class XBRXNameService
extends XBRDefaultService<XBCXName>
implements XBCXNameService {
    public XBRXNameService(XBRCatalog catalog) {
        super(catalog);
        this.itemManager = new XBRXNameManager(catalog);
        catalog.addCatalogManager(XBCXNameManager.class, (XBCXNameManager)this.itemManager);
    }

    public String getDefaultText(XBCItem item) {
        return ((XBRXNameManager)this.itemManager).getDefaultText(item);
    }

    public XBRXName getDefaultItemName(XBCItem item) {
        return ((XBRXNameManager)this.itemManager).getDefaultItemName(item);
    }

    public XBRXName getItemName(XBCItem item, XBCXLanguage language) {
        return ((XBRXNameManager)this.itemManager).getItemName(item, language);
    }

    public List<XBCXName> getItemNames(XBCItem item) {
        return ((XBRXNameManager)this.itemManager).getItemNames(item);
    }

    public String getExtensionName() {
        return ((XBCExtension)this.itemManager).getExtensionName();
    }

    public void initializeExtension() {
        ((XBCExtension)this.itemManager).initializeExtension();
    }

    public void setDefaultText(XBCItem item, String text) {
        XBRXName name = this.getDefaultItemName(item);
        if (text == null || text.isEmpty()) {
            if (name != null) {
                this.removeItem((XBCBase)name);
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public String getItemNamePath(XBCItem item) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDefaultText(item));
        Optional parentItem = item.getParentItem();
        while (parentItem.isPresent() && ((XBCItem)parentItem.get()).getParentItem().isPresent()) {
            builder.insert(0, this.getDefaultText((XBCItem)parentItem.get()) + ".");
            parentItem = ((XBCItem)parentItem.get()).getParentItem();
        }
        return builder.toString();
    }
}

