/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog.remote.service;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.catalog.remote.XBRBlockRev;
import org.exbin.xbup.client.catalog.remote.XBRFormatRev;
import org.exbin.xbup.client.catalog.remote.XBRGroupRev;
import org.exbin.xbup.client.catalog.remote.XBRRev;
import org.exbin.xbup.client.catalog.remote.manager.XBRRevManager;
import org.exbin.xbup.client.catalog.remote.service.XBRDefaultService;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.manager.XBCRevManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXDescManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXHDocManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXNameManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXStriManager;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;

@ParametersAreNonnullByDefault
public class XBRRevService
extends XBRDefaultService<XBCRev>
implements XBCRevService {
    public XBRRevService(XBRCatalog catalog) {
        super(catalog);
        this.itemManager = new XBRRevManager(catalog);
        catalog.addCatalogManager(XBCRevManager.class, (XBCRevManager)this.itemManager);
    }

    public XBRRev findRevByXB(XBCSpec spec, long xbIndex) {
        return ((XBRRevManager)this.itemManager).findRevByXB(spec, xbIndex);
    }

    public XBRRev getRev(XBCSpec spec, long index) {
        return ((XBRRevManager)this.itemManager).getRev(spec, index);
    }

    public List<XBCRev> getRevs(XBCSpec spec) {
        return ((XBRRevManager)this.itemManager).getRevs(spec);
    }

    public long getRevsCount(XBCSpec spec) {
        return ((XBRRevManager)this.itemManager).getRevsCount(spec);
    }

    public void removeItemDepth(XBCRev rev) {
        XBCXHDocManager hdocManager;
        XBCXHDoc itemHDoc;
        XBCXNameManager nameManager = this.catalog.getCatalogManager(XBCXNameManager.class);
        List itemNames = nameManager.getItemNames((XBCItem)rev);
        for (XBCXName itemName : itemNames) {
            nameManager.removeItem((XBCBase)itemName);
        }
        XBCXDescManager descManager = this.catalog.getCatalogManager(XBCXDescManager.class);
        List itemDescs = descManager.getItemDescs((XBCItem)rev);
        for (XBCXDesc itemDesc : itemDescs) {
            descManager.removeItem((XBCBase)itemDesc);
        }
        XBCXStriManager striManager = this.catalog.getCatalogManager(XBCXStriManager.class);
        XBCXStri itemStri = striManager.getItemStringId((XBCItem)rev);
        if (itemStri != null) {
            striManager.removeItem((XBCBase)itemStri);
        }
        if ((itemHDoc = (hdocManager = this.catalog.getCatalogManager(XBCXHDocManager.class)).getDocumentation((XBCItem)rev)) != null) {
            hdocManager.removeItem((XBCBase)itemHDoc);
        }
        this.removeItem((XBCBase)rev);
    }

    public XBCRev createRev(XBCSpec spec) {
        if (spec instanceof XBCBlockSpec) {
            return new XBRBlockRev(this.catalog.getCatalogServiceClient(), 0L);
        }
        if (spec instanceof XBCGroupSpec) {
            return new XBRGroupRev(this.catalog.getCatalogServiceClient(), 0L);
        }
        if (spec instanceof XBCFormatSpec) {
            return new XBRFormatRev(this.catalog.getCatalogServiceClient(), 0L);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getRevsLimitSum(XBCSpec spec, long revision) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long findMaxRevXB(XBCSpec spec) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

