/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog.remote.manager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.catalog.remote.XBRXFile;
import org.exbin.xbup.client.catalog.remote.manager.XBRDefaultManager;
import org.exbin.xbup.client.stub.XBPXFileStub;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.manager.XBCXFileManager;

@ParametersAreNonnullByDefault
public class XBRXFileManager
extends XBRDefaultManager<XBCXFile>
implements XBCXFileManager {
    private final XBPXFileStub fileStub;

    public XBRXFileManager(XBRCatalog catalog) {
        super(catalog);
        this.fileStub = new XBPXFileStub(this.client);
        this.setManagerStub(this.fileStub);
    }

    public Long[] getFileXBPath(XBCXFile file) {
        ArrayList<Long> list = new ArrayList<Long>();
        XBCNode parent = file.getNode();
        while (parent != null) {
            if (parent.getParent().isPresent()) {
                list.add(0, parent.getXBIndex());
            }
            parent = parent.getParent().orElse(null);
        }
        list.add(file.getId());
        return list.toArray(new Long[list.size()]);
    }

    public ImageIcon getFileAsImageIcon(XBCXFile iconFile) {
        return this.fileStub.getFileAsImageIcon(iconFile);
    }

    public InputStream getFile(XBCXFile iconFile) {
        return this.fileStub.getFile(iconFile);
    }

    public XBRXFile findFile(XBCNode node, String fileName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void initializeExtension() {
    }

    public String getExtensionName() {
        return "File Repository Extension";
    }

    public List<XBCXFile> findFilesForNode(XBCNode node) {
        return this.fileStub.findFilesForNode(node);
    }
}

