/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.update.api;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class VersionNumbers {
    private VersionNumbersFormat format;
    private int major;
    private int minor;
    private int release;
    private int patch;

    public void versionFromString(String version) {
        int minorPos = version.indexOf(".");
        this.major = Integer.parseInt(version.substring(0, minorPos));
        int releasePos = version.indexOf(".", minorPos + 1);
        this.minor = Integer.parseInt(version.substring(minorPos + 1, releasePos));
        int patchPos = version.indexOf(".", releasePos + 1);
        if (patchPos > 0) {
            this.format = VersionNumbersFormat.MAJOR_MINOR_RELEASE_PATCH;
            this.release = Integer.parseInt(version.substring(releasePos + 1, patchPos));
            this.patch = Integer.parseInt(version.substring(patchPos + 1));
        } else {
            this.format = VersionNumbersFormat.MAJOR_MINOR_PATCH;
            this.patch = Integer.parseInt(version.substring(releasePos + 1));
        }
    }

    @Nullable
    public String versionAsString() {
        if (this.format == null) {
            return null;
        }
        switch (this.format) {
            case MAJOR_MINOR_PATCH: {
                return this.major + "." + this.minor + "." + this.patch;
            }
            case MAJOR_MINOR_RELEASE_PATCH: {
                return this.major + "." + this.minor + "." + this.release + "." + this.patch;
            }
        }
        throw new IllegalStateException("Unexpected format " + this.format.name());
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getRelease() {
        return this.release;
    }

    public void setRelease(int release) {
        this.release = release;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public boolean isGreaterThan(VersionNumbers updateVersion) {
        if (this.major > updateVersion.major) {
            return true;
        }
        if (this.major == updateVersion.major && this.minor > updateVersion.minor) {
            return true;
        }
        if (this.minor == updateVersion.minor) {
            block0 : switch (this.format) {
                case MAJOR_MINOR_PATCH: {
                    switch (updateVersion.format) {
                        case MAJOR_MINOR_PATCH: {
                            if (this.patch <= updateVersion.patch) break block0;
                            return true;
                        }
                        case MAJOR_MINOR_RELEASE_PATCH: {
                            if (updateVersion.release != 0 || this.patch <= updateVersion.patch) break block0;
                            return true;
                        }
                        default: {
                            throw new IllegalStateException("Unpexpected format type " + updateVersion.format.name());
                        }
                    }
                }
                case MAJOR_MINOR_RELEASE_PATCH: {
                    switch (updateVersion.format) {
                        case MAJOR_MINOR_PATCH: {
                            if (this.release > 0) {
                                return true;
                            }
                            if (this.release != 0 || this.patch <= updateVersion.patch) break block0;
                            return true;
                        }
                        case MAJOR_MINOR_RELEASE_PATCH: {
                            if (this.release > updateVersion.release) {
                                return true;
                            }
                            if (this.release != updateVersion.release || this.patch <= updateVersion.patch) break block0;
                            return true;
                        }
                        default: {
                            throw new IllegalStateException("Unpexpected format type " + updateVersion.format.name());
                        }
                    }
                }
                default: {
                    throw new IllegalStateException("Unpexpected format type " + this.format.name());
                }
            }
        }
        return false;
    }

    public static enum VersionNumbersFormat {
        MAJOR_MINOR_PATCH,
        MAJOR_MINOR_RELEASE_PATCH;

    }
}

