/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.InsertDataOperation;
import org.exbin.bined.operation.swing.command.CodeAreaCommandType;
import org.exbin.bined.operation.swing.command.OpCodeAreaCommand;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class InsertDataCommand
extends OpCodeAreaCommand {
    private final long position;
    private final long dataLength;

    public InsertDataCommand(CodeAreaCore codeArea, long position, BinaryData data) {
        super(codeArea);
        this.position = position;
        this.dataLength = data.getDataSize();
        super.setOperation(new InsertDataOperation(codeArea, position, 0, data));
    }

    @Override
    @Nonnull
    public CodeAreaCommandType getType() {
        return CodeAreaCommandType.DATA_INSERTED;
    }

    @Override
    public void redo() throws BinaryDataOperationException {
        super.redo();
        ((CaretCapable)this.codeArea).setCaretPosition(this.position + this.dataLength);
    }

    @Override
    public void undo() throws BinaryDataOperationException {
        super.undo();
        ((CaretCapable)this.codeArea).setCaretPosition(this.position);
    }
}

