/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.file.preferences;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;

@ParametersAreNonnullByDefault
public class RecentFilesPreferences {
    public static final String PREFERENCES_RECENTFILE_PATH_PREFIX = "recentFile.path.";
    public static final String PREFEFRENCES_RECENTFILE_MODULE_PREFIX = "recentFile.module.";
    public static final String PREFERENCES_RECENFILE_MODE_PREFIX = "recentFile.mode.";
    private final Preferences preferences;

    public RecentFilesPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public Optional<String> getFilePath(int index) {
        return this.preferences.get(PREFERENCES_RECENTFILE_PATH_PREFIX + String.valueOf(index));
    }

    @Nonnull
    public Optional<String> getModuleName(int index) {
        return this.preferences.get(PREFEFRENCES_RECENTFILE_MODULE_PREFIX + String.valueOf(index));
    }

    @Nonnull
    public Optional<String> getFileMode(int index) {
        return this.preferences.get(PREFERENCES_RECENFILE_MODE_PREFIX + String.valueOf(index));
    }

    public void setFilePath(String value, int index) {
        this.preferences.put(PREFERENCES_RECENTFILE_PATH_PREFIX + String.valueOf(index), value);
    }

    public void setModuleName(String value, int index) {
        this.preferences.put(PREFEFRENCES_RECENTFILE_MODULE_PREFIX + String.valueOf(index), value);
    }

    public void setFileMode(String value, int index) {
        this.preferences.put(PREFERENCES_RECENFILE_MODE_PREFIX + String.valueOf(index), value);
    }

    public void remove(int index) {
        this.preferences.remove(PREFERENCES_RECENTFILE_PATH_PREFIX + String.valueOf(index));
    }
}

