/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.file.action;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileSystemView;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.file.preferences.RecentFilesPreferences;
import org.exbin.framework.frame.api.FrameModuleApi;

@ParametersAreNonnullByDefault
public class RecentFilesActions {
    private ResourceBundle resourceBundle;
    private XBApplication application;
    private FilesControl filesControl;
    private Preferences preferences;
    private JMenu fileOpenRecentMenu = null;
    private List<RecentItem> recentFiles = null;

    public void setup(XBApplication application, ResourceBundle resourceBundle, FilesControl filesControl) {
        this.application = application;
        this.filesControl = filesControl;
        this.resourceBundle = resourceBundle;
        FrameModuleApi frameModule = (FrameModuleApi)application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        frameModule.addExitListener(frameHandler -> {
            this.saveState();
            return true;
        });
    }

    @Nonnull
    public JMenu getOpenRecentMenu() {
        if (this.fileOpenRecentMenu == null) {
            this.fileOpenRecentMenu = new JMenu(this.resourceBundle.getString("openRecentMenu.text"));
            this.recentFiles = new ArrayList<RecentItem>();
            if (this.preferences != null) {
                this.loadState();
            }
        }
        return this.fileOpenRecentMenu;
    }

    private void loadState() {
        RecentFilesPreferences recentFilesParameters = new RecentFilesPreferences(this.preferences);
        this.recentFiles.clear();
        for (int recent = 1; recent < 14; ++recent) {
            String filePath = recentFilesParameters.getFilePath(recent).orElse(null);
            String moduleName = recentFilesParameters.getModuleName(recent).orElse(null);
            String fileMode = recentFilesParameters.getFileMode(recent).orElse(null);
            if (filePath == null) break;
            this.recentFiles.add(new RecentItem(filePath, moduleName, fileMode));
        }
        this.rebuildRecentFilesMenu();
    }

    private void saveState() {
        RecentFilesPreferences recentFilesParameters = new RecentFilesPreferences(this.preferences);
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            recentFilesParameters.setFilePath(this.recentFiles.get(i).getFileName(), i + 1);
            recentFilesParameters.setModuleName(this.recentFiles.get(i).getModuleName(), i + 1);
            recentFilesParameters.setFileMode(this.recentFiles.get(i).getFileMode(), i + 1);
        }
        recentFilesParameters.remove(this.recentFiles.size() + 1);
        this.preferences.flush();
    }

    private void rebuildRecentFilesMenu() {
        this.fileOpenRecentMenu.removeAll();
        for (int recentFileIndex = 0; recentFileIndex < this.recentFiles.size(); ++recentFileIndex) {
            String filename = this.recentFiles.get(recentFileIndex).getFileName();
            File file = new File(filename);
            JMenuItem menuItem = new JMenuItem(file.getName());
            menuItem.setToolTipText(filename);
            try {
                URI fileUri = new URI(filename);
                try {
                    menuItem.setIcon(FileSystemView.getFileSystemView().getSystemIcon(new File(fileUri)));
                }
                catch (Exception ex) {
                    menuItem.setIcon(null);
                }
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(RecentFilesActions.class.getName()).log(Level.SEVERE, null, ex);
            }
            menuItem.addActionListener(e -> {
                if (e.getSource() instanceof JMenuItem) {
                    JMenuItem sourceMenuItem = (JMenuItem)e.getSource();
                    for (int itemIndex = 0; itemIndex < this.fileOpenRecentMenu.getItemCount(); ++itemIndex) {
                        if (!sourceMenuItem.equals(this.fileOpenRecentMenu.getItem(itemIndex))) continue;
                        RecentItem recentItem = this.recentFiles.get(itemIndex);
                        FileType fileType = null;
                        List<FileType> registeredFileTypes = this.filesControl.getRegisteredFileTypes();
                        for (FileType regFileType : registeredFileTypes) {
                            if (!regFileType.getFileTypeId().equals(recentItem.getFileMode())) continue;
                            fileType = regFileType;
                            break;
                        }
                        try {
                            URI fileUri = new URI(recentItem.getFileName());
                            this.filesControl.loadFromFile(fileUri, fileType);
                            if (itemIndex <= 0) continue;
                            this.recentFiles.remove(itemIndex);
                            this.recentFiles.add(0, recentItem);
                            this.rebuildRecentFilesMenu();
                            continue;
                        }
                        catch (URISyntaxException ex) {
                            Logger.getLogger(RecentFilesActions.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            });
            this.fileOpenRecentMenu.add(menuItem);
        }
        this.fileOpenRecentMenu.setEnabled(!this.recentFiles.isEmpty());
    }

    @Nullable
    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public void updateRecentFilesList(URI fileUri, FileType fileType) {
        if (this.recentFiles != null) {
            for (int i = 0; i < this.recentFiles.size(); ++i) {
                RecentItem recentItem = this.recentFiles.get(i);
                if (!recentItem.getFileName().equals(fileUri.toString())) continue;
                this.recentFiles.remove(i);
            }
            this.recentFiles.add(0, new RecentItem(fileUri.toString(), "", fileType.getFileTypeId()));
            if (this.recentFiles.size() > 15) {
                this.recentFiles.remove(15);
            }
            this.rebuildRecentFilesMenu();
        }
    }

    @ParametersAreNonnullByDefault
    public static interface FilesControl {
        public void loadFromFile(URI var1, @Nullable FileType var2);

        @Nonnull
        public List<FileType> getRegisteredFileTypes();
    }

    public class RecentItem {
        private String fileName;
        private String moduleName;
        private String fileMode;

        public RecentItem(@Nullable String fileName, @Nullable String moduleName, String fileMode) {
            this.fileName = fileName;
            this.moduleName = moduleName;
            this.fileMode = fileMode;
        }

        @Nullable
        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(@Nullable String path) {
            this.fileName = path;
        }

        @Nullable
        public String getFileMode() {
            return this.fileMode;
        }

        public void setFileMode(@Nullable String fileMode) {
            this.fileMode = fileMode;
        }

        @Nullable
        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(@Nullable String moduleName) {
            this.moduleName = moduleName;
        }
    }
}

