/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.file.action;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.file.api.FileActionsApi;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileLoading;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.file.api.FileTypes;
import org.exbin.framework.file.api.UsedDirectoryApi;
import org.exbin.framework.frame.api.FrameModuleApi;

@ParametersAreNonnullByDefault
public class FileActions
implements FileActionsApi {
    public static final String ALL_FILES_FILTER = "AllFilesFilter";
    private ResourceBundle resourceBundle;
    private XBApplication application;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
    }

    public void setupFileFilters(JFileChooser fileChooser, FileTypes fileTypes) {
        fileChooser.setAcceptAllFileFilterUsed(false);
        for (FileType fileType : fileTypes.getFileTypes()) {
            fileChooser.addChoosableFileFilter((FileFilter)fileType);
        }
        if (fileTypes.allowAllFiles()) {
            fileChooser.addChoosableFileFilter(new AllFilesFilter());
        }
    }

    public void openFile(@Nullable FileLoading fileHandler, FileTypes fileTypes, @Nullable UsedDirectoryApi usedDirectory) {
        if (fileHandler != null) {
            FileActionsApi.OpenFileResult openFileResult = this.showOpenFileDialog(fileTypes, usedDirectory);
            if (openFileResult.dialogResult == 0) {
                File selectedFile = Objects.requireNonNull(openFileResult.selectedFile);
                URI fileUri = selectedFile.toURI();
                fileHandler.loadFromFile(fileUri, openFileResult.fileType);
                if (usedDirectory != null) {
                    usedDirectory.setLastUsedDirectory(selectedFile.getParentFile());
                    usedDirectory.updateRecentFilesList(fileUri, openFileResult.fileType);
                }
            }
        }
    }

    @Nonnull
    public FileActionsApi.OpenFileResult showOpenFileDialog(FileTypes fileTypes, @Nullable UsedDirectoryApi usedDirectory) {
        return this.showOpenFileDialog(fileTypes, null, usedDirectory);
    }

    @Nonnull
    public FileActionsApi.OpenFileResult showOpenFileDialog(FileTypes fileTypes, @Nullable File selectedFile, @Nullable UsedDirectoryApi usedDirectory) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        JFileChooser openFileChooser = new JFileChooser();
        this.setupFileFilters(openFileChooser, fileTypes);
        if (usedDirectory != null) {
            openFileChooser.setCurrentDirectory(usedDirectory.getLastUsedDirectory().orElse(null));
        }
        if (selectedFile != null) {
            openFileChooser.setSelectedFile(selectedFile);
        }
        int dialogResult = openFileChooser.showOpenDialog(frameModule.getFrame());
        FileActionsApi.OpenFileResult result = new FileActionsApi.OpenFileResult();
        result.dialogResult = dialogResult;
        result.selectedFile = openFileChooser.getSelectedFile();
        FileFilter fileFilter = openFileChooser.getFileFilter();
        result.fileType = fileFilter instanceof FileType ? (FileType)fileFilter : null;
        return result;
    }

    @Nonnull
    public FileActionsApi.OpenFileResult showSaveFileDialog(FileTypes fileTypes, @Nullable UsedDirectoryApi usedDirectory) {
        return this.showSaveFileDialog(fileTypes, null, usedDirectory);
    }

    @Nonnull
    public FileActionsApi.OpenFileResult showSaveFileDialog(FileTypes fileTypes, @Nullable File selectedFile, @Nullable UsedDirectoryApi usedDirectory) {
        return this.showSaveFileDialog(fileTypes, selectedFile, usedDirectory, null);
    }

    @Nonnull
    private FileActionsApi.OpenFileResult showSaveFileDialog(FileTypes fileTypes, @Nullable File selectedFile, @Nullable UsedDirectoryApi usedDirectory, @Nullable String dialogName) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        JFileChooser saveFileChooser = new JFileChooser();
        saveFileChooser.setDialogType(1);
        this.setupFileFilters(saveFileChooser, fileTypes);
        if (usedDirectory != null) {
            saveFileChooser.setCurrentDirectory(usedDirectory.getLastUsedDirectory().orElse(null));
        }
        if (selectedFile != null) {
            saveFileChooser.setSelectedFile(selectedFile);
        }
        if (dialogName != null) {
            saveFileChooser.setDialogTitle(dialogName);
        }
        int dialogResult = saveFileChooser.showSaveDialog(frameModule.getFrame());
        FileActionsApi.OpenFileResult result = new FileActionsApi.OpenFileResult();
        result.dialogResult = dialogResult;
        result.selectedFile = saveFileChooser.getSelectedFile();
        FileFilter fileFilter = saveFileChooser.getFileFilter();
        result.fileType = fileFilter instanceof FileType ? (FileType)fileFilter : null;
        return result;
    }

    public void saveFile(@Nullable FileHandler fileHandler, FileTypes fileTypes, @Nullable UsedDirectoryApi usedDirectory) {
        if (fileHandler != null) {
            Optional fileUri = fileHandler.getFileUri();
            if (fileUri.isPresent()) {
                fileHandler.saveToFile((URI)fileUri.get(), (FileType)fileHandler.getFileType().orElse(null));
            } else {
                this.saveAsFile(fileHandler, fileTypes, usedDirectory);
            }
        }
    }

    public void saveAsFile(@Nullable FileHandler fileHandler, FileTypes fileTypes, @Nullable UsedDirectoryApi usedDirectory) {
        if (fileHandler != null) {
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            Optional currentFileUri = fileHandler.getFileUri();
            FileActionsApi.OpenFileResult saveFileResult = this.showSaveFileDialog(fileTypes, currentFileUri.isPresent() ? new File((URI)currentFileUri.get()) : null, usedDirectory, this.resourceBundle.getString("SaveAsDialog.title"));
            if (saveFileResult.dialogResult == 0) {
                File selectedFile = Objects.requireNonNull(saveFileResult.selectedFile);
                if (selectedFile.exists() && !this.showAskToOverwrite()) {
                    return;
                }
                try {
                    URI fileUri = selectedFile.toURI();
                    fileHandler.saveToFile(fileUri, saveFileResult.fileType);
                    if (usedDirectory != null) {
                        usedDirectory.setLastUsedDirectory(selectedFile.getParentFile());
                        usedDirectory.updateRecentFilesList(fileUri, saveFileResult.fileType);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(FileActions.class.getName()).log(Level.SEVERE, null, ex);
                    String errorMessage = ex.getLocalizedMessage();
                    JOptionPane.showMessageDialog(frameModule.getFrame(), this.resourceBundle.getString("Question.unable_to_save") + ": " + ex.getClass().getCanonicalName() + (errorMessage == null || errorMessage.isEmpty() ? "" : errorMessage), this.resourceBundle.getString("Question.unable_to_save"), 0);
                }
            }
        }
    }

    public boolean showAskForSaveDialog(@Nullable FileHandler fileHandler, FileTypes fileTypes, @Nullable UsedDirectoryApi usedDirectory) {
        if (fileHandler == null) {
            return true;
        }
        while (fileHandler.isModified()) {
            Object[] options = new Object[]{this.resourceBundle.getString("Question.modified_save"), this.resourceBundle.getString("Question.modified_discard"), this.resourceBundle.getString("Question.modified_cancel")};
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            int result = JOptionPane.showOptionDialog(frameModule.getFrame(), this.resourceBundle.getString("Question.modified"), this.resourceBundle.getString("Question.modified_title"), 1, 3, null, options, options[0]);
            if (result == 1) {
                return true;
            }
            if (result == 2 || result == -1) {
                return false;
            }
            this.saveFile(fileHandler, fileTypes, usedDirectory);
        }
        return true;
    }

    public boolean showAskToOverwrite() {
        Object[] options = new Object[]{this.resourceBundle.getString("Question.overwrite_save"), this.resourceBundle.getString("Question.modified_cancel")};
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        int result = JOptionPane.showOptionDialog(frameModule.getFrame(), this.resourceBundle.getString("Question.overwrite"), this.resourceBundle.getString("Question.overwrite_title"), 0, 3, null, options, options[0]);
        if (result == 0) {
            return true;
        }
        if (result == 1 || result == -1) {
            return false;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public class AllFilesFilter
    extends FileFilter
    implements FileType {
        @Override
        public boolean accept(File file) {
            return true;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return FileActions.this.resourceBundle.getString("AllFilesFilter.description");
        }

        @Nonnull
        public String getFileTypeId() {
            return FileActions.ALL_FILES_FILTER;
        }
    }
}

