/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.tool.xbseditor;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.security.AccessControlException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.exbin.framework.XBBaseApplication;
import org.exbin.framework.about.api.AboutModuleApi;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplicationModuleRepository;
import org.exbin.framework.editor.api.EditorModuleApi;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.EditorWaveModule;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.frame.api.ApplicationFrameHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.operation.undo.api.OperationUndoModuleApi;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBTLinearUndo;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.operation.undo.XBUndoUpdateListener;

@ParametersAreNonnullByDefault
public class XBSEditor {
    private static boolean verboseMode = false;
    private static boolean devMode = false;
    private static ResourceBundle bundle;

    private XBSEditor() {
    }

    public static void main(String[] args) {
        block6: {
            try {
                bundle = LanguageUtils.getResourceBundleByClass(XBSEditor.class);
                Options opt = new Options();
                opt.addOption("h", "help", false, bundle.getString("cl_option_help"));
                opt.addOption("v", false, bundle.getString("cl_option_verbose"));
                opt.addOption("dev", false, bundle.getString("cl_option_dev"));
                BasicParser parser = new BasicParser();
                CommandLine cl = parser.parse(opt, args);
                if (cl.hasOption('h')) {
                    HelpFormatter f = new HelpFormatter();
                    f.printHelp(bundle.getString("cl_syntax"), opt);
                    break block6;
                }
                verboseMode = cl.hasOption("v");
                devMode = cl.hasOption("dev");
                Logger logger = Logger.getLogger("");
                try {
                    logger.setLevel(Level.ALL);
                    logger.addHandler((Handler)new XBHead.XBLogHandler(verboseMode));
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                XBBaseApplication app = new XBBaseApplication();
                app.setAppDirectory(XBSEditor.class);
                Preferences preferences = app.createPreferences(XBSEditor.class);
                app.setAppBundle(bundle, LanguageUtils.getResourceBaseNameBundleByClass(XBSEditor.class));
                XBApplicationModuleRepository moduleRepository = app.getModuleRepository();
                moduleRepository.addClassPathModules();
                moduleRepository.addModulesFromManifest(XBSEditor.class);
                moduleRepository.loadModulesFromPath(new File("plugins").toURI());
                moduleRepository.initModules();
                app.init();
                FrameModuleApi frameModule = (FrameModuleApi)moduleRepository.getModuleByInterface(FrameModuleApi.class);
                EditorModuleApi editorModule = (EditorModuleApi)moduleRepository.getModuleByInterface(EditorModuleApi.class);
                ActionModuleApi actionModule = (ActionModuleApi)moduleRepository.getModuleByInterface(ActionModuleApi.class);
                AboutModuleApi aboutModule = (AboutModuleApi)moduleRepository.getModuleByInterface(AboutModuleApi.class);
                OperationUndoModuleApi undoModule = (OperationUndoModuleApi)moduleRepository.getModuleByInterface(OperationUndoModuleApi.class);
                FileModuleApi fileModule = (FileModuleApi)moduleRepository.getModuleByInterface(FileModuleApi.class);
                OptionsModuleApi optionsModule = (OptionsModuleApi)moduleRepository.getModuleByInterface(OptionsModuleApi.class);
                final EditorWaveModule waveEditorModule = (EditorWaveModule)moduleRepository.getModuleByInterface(EditorWaveModule.class);
                frameModule.createMainMenu();
                aboutModule.registerDefaultMenuItem();
                frameModule.registerExitAction();
                frameModule.registerBarsVisibilityActions();
                fileModule.registerMenuFileHandlingActions();
                fileModule.registerToolBarFileHandlingActions();
                fileModule.registerRecenFilesMenuActions();
                fileModule.registerCloseListener();
                undoModule.registerMainMenu();
                undoModule.registerMainToolBar();
                undoModule.registerUndoManagerInMainMenu();
                XBTLinearUndo linearUndo = new XBTLinearUndo(null);
                linearUndo.addUndoUpdateListener(new XBUndoUpdateListener(){

                    public void undoCommandPositionChanged() {
                        ((AudioPanel)waveEditorModule.getEditorProvider()).repaint();
                    }

                    public void undoCommandAdded(Command command) {
                        ((AudioPanel)waveEditorModule.getEditorProvider()).repaint();
                    }
                });
                undoModule.setUndoHandler((XBUndoHandler)linearUndo);
                actionModule.registerMenuClipboardActions();
                actionModule.registerToolBarClipboardActions();
                optionsModule.registerMenuAction();
                waveEditorModule.registerFileTypes();
                waveEditorModule.registerToolsMenuActions();
                waveEditorModule.registerToolsOptionsMenuActions();
                waveEditorModule.registerPropertiesMenu();
                waveEditorModule.registerAudioMenu();
                waveEditorModule.registerAudioOperationMenu();
                waveEditorModule.registerDrawingModeMenu();
                waveEditorModule.registerZoomModeMenu();
                waveEditorModule.bindZoomScrollWheel();
                ApplicationFrameHandler frameHandler = frameModule.getFrameHandler();
                EditorProvider editorProvider = waveEditorModule.getEditorProvider();
                editorModule.registerEditor("audio", editorProvider);
                waveEditorModule.registerStatusBar();
                waveEditorModule.registerOptionsPanels();
                frameHandler.setMainPanel((Component)editorModule.getEditorComponent());
                frameHandler.setDefaultSize(new Dimension(600, 400));
                optionsModule.initialLoadFromPreferences();
                frameHandler.showFrame();
                List fileArgs = cl.getArgList();
                if (!fileArgs.isEmpty()) {
                    fileModule.loadFromFile((String)fileArgs.get(0));
                }
            }
            catch (RuntimeException | ParseException ex) {
                Logger.getLogger(XBSEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

