/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.data.stub;

import java.util.ArrayList;
import java.util.List;
import org.exbin.framework.data.TableDataRow;
import org.exbin.framework.data.TableDataSource;
import org.exbin.framework.data.stub.DataStub;

public class RemoteTableDataSource
implements TableDataSource {
    public static final int ROWS_PER_REQUEST = 7;
    private final String tableSourceId;
    private final DataStub dataStub;
    private List<TableDataSource.ColumnDefinition> columDefinition = null;
    private final List<RowsPageCache> pageCache = new ArrayList<RowsPageCache>();

    public RemoteTableDataSource(DataStub dataStub, String tableSourceId) {
        this.dataStub = dataStub;
        this.tableSourceId = tableSourceId;
    }

    @Override
    public List<TableDataSource.ColumnDefinition> getColumns() {
        if (this.columDefinition == null) {
            this.columDefinition = this.dataStub.getColumDefinition(this.tableSourceId);
        }
        return this.columDefinition;
    }

    @Override
    public int getRowCount() {
        return this.dataStub.getTableRowCount(this.tableSourceId);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int pageIndex = rowIndex / 7;
        int pageOffset = rowIndex % 7;
        List<TableDataRow> tableRows = this.dataStub.getTableRows(this.tableSourceId, rowIndex, 1);
        TableDataRow tableRow = tableRows.get(0);
        return tableRow.getRowData()[columnIndex];
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private RowsPageCache getPageCache(int pageIndex) {
        if (pageIndex < this.pageCache.size()) {
            return this.pageCache.get(pageIndex);
        }
        return null;
    }

    private RowsPageCache getOrLoadPage(int pageIndex) {
        RowsPageCache page = this.getPageCache(pageIndex);
        if (page == null) {
            List<TableDataRow> tableRows = this.dataStub.getTableRows(this.tableSourceId, pageIndex * 7, 7);
            page = new RowsPageCache();
            page.pageData = tableRows;
            if (this.pageCache.size() < pageIndex) {
                int cacheSize;
                for (int i = cacheSize = this.pageCache.size(); i < pageIndex; ++i) {
                    this.pageCache.add(null);
                }
                this.pageCache.add(page);
            }
        }
        return page;
    }

    private class RowsPageCache {
        List<TableDataRow> pageData;

        private RowsPageCache() {
        }
    }
}

