/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.data.gui.cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicBorders;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ComponentPropertyTableCellPanel
extends JPanel {
    private JComponent cellComponent;
    private JButton editorButton;

    public ComponentPropertyTableCellPanel() {
        this(ComponentPropertyTableCellPanel.createEmptyCellComponent());
    }

    public ComponentPropertyTableCellPanel(JComponent cellComponent) {
        this.cellComponent = cellComponent;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.add((Component)this.cellComponent, "Center");
    }

    private void initComponents() {
        this.editorButton = new JButton(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void updateUI() {
                super.updateUI();
                Border border = this.getBorder();
                if (border instanceof CompoundBorder) {
                    Border outsideBorder;
                    Border insideBorder = ((CompoundBorder)border).getInsideBorder();
                    if (insideBorder instanceof BasicBorders.MarginBorder) {
                        // empty if block
                    }
                    if (!((outsideBorder = ((CompoundBorder)border).getOutsideBorder()) instanceof Object)) return;
                }
                try {
                    Class.forName("com.bulenkov.darcula.ui.DarculaButtonPainter");
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        };
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.editorButton.setText("...");
        this.editorButton.setMargin(new Insets(0, 0, 0, 0));
        this.editorButton.setName("editorButton");
        this.add((Component)this.editorButton, "East");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ComponentPropertyTableCellPanel());
    }

    @Nonnull
    public static JLabel createEmptyCellComponent() {
        JLabel label = new JLabel(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIManager.getDefaults().getFont("TextField.font"));
            }
        };
        return label;
    }

    public void setEditorAction(ActionListener actionListener) {
        this.editorButton.addActionListener(actionListener);
    }

    @Nonnull
    public JComponent getCellComponent() {
        return this.cellComponent;
    }
}

