/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.PerspectiveSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPerspective;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockStationLayout;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockStationFactory
implements DockFactory<SplitDockStation, SplitDockPerspective, SplitDockStationLayout> {
    public static final String ID = "SplitDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    protected SplitDockStationLayout createLayout(SplitDockStation station, SplitDockStationLayout.Entry root, int fullscreen, boolean hasFullscreenAction) {
        return this.createLayout(root, fullscreen, hasFullscreenAction);
    }

    protected SplitDockStationLayout createLayout(SplitDockPerspective station, SplitDockStationLayout.Entry root, int fullscreen, boolean hasFullscreenAction) {
        return this.createLayout(root, fullscreen, hasFullscreenAction);
    }

    protected SplitDockStationLayout createLayout(SplitDockStationLayout.Entry root, int fullscreen, boolean hasFullscreenAction) {
        return new SplitDockStationLayout(root, fullscreen, hasFullscreenAction);
    }

    @Override
    public SplitDockStationLayout getLayout(final SplitDockStation station, final Map<Dockable, Integer> children) {
        SplitDockStationLayout.Entry root = station.visit(new SplitTreeFactory<SplitDockStationLayout.Entry>(){
            private PlaceholderStrategy strategy;
            {
                this.strategy = station.getPlaceholderStrategy();
            }

            @Override
            public SplitDockStationLayout.Entry leaf(Dockable dockable, long id, Path[] placeholders, PlaceholderMap placeholderMap) {
                Integer childId = (Integer)children.get(dockable);
                placeholders = DockUtilities.mergePlaceholders(placeholders, dockable, this.strategy);
                if (childId != null) {
                    return new SplitDockStationLayout.Leaf(childId, placeholders, placeholderMap, id);
                }
                if (placeholders != null && placeholders.length > 0) {
                    return new SplitDockStationLayout.Leaf(-1, placeholders, placeholderMap, id);
                }
                return null;
            }

            @Override
            public SplitDockStationLayout.Entry placeholder(long id, Path[] placeholders, PlaceholderMap placeholderMap) {
                if (placeholders != null && placeholders.length > 0) {
                    return new SplitDockStationLayout.Leaf(-1, placeholders, placeholderMap, id);
                }
                return null;
            }

            @Override
            public SplitDockStationLayout.Entry root(SplitDockStationLayout.Entry root, long id) {
                return root;
            }

            @Override
            public SplitDockStationLayout.Entry horizontal(SplitDockStationLayout.Entry left, SplitDockStationLayout.Entry right, double divider, long id, Path[] placeholders, PlaceholderMap placeholderMap, boolean visible) {
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                return new SplitDockStationLayout.Node(SplitDockStation.Orientation.HORIZONTAL, divider, left, right, placeholders, placeholderMap, id);
            }

            @Override
            public SplitDockStationLayout.Entry vertical(SplitDockStationLayout.Entry top, SplitDockStationLayout.Entry bottom, double divider, long id, Path[] placeholders, PlaceholderMap placeholderMap, boolean visible) {
                if (top == null) {
                    return bottom;
                }
                if (bottom == null) {
                    return top;
                }
                return new SplitDockStationLayout.Node(SplitDockStation.Orientation.VERTICAL, divider, top, bottom, placeholders, placeholderMap, id);
            }
        });
        Dockable fullscreenDockable = station.getFullScreen();
        Integer fullscreen = null;
        if (fullscreenDockable != null) {
            fullscreen = children.get(fullscreenDockable);
        }
        if (fullscreen == null) {
            return this.createLayout(station, root, -1, station.hasFullScreenAction());
        }
        return this.createLayout(station, root, (int)fullscreen, station.hasFullScreenAction());
    }

    @Override
    public SplitDockStationLayout getPerspectiveLayout(SplitDockPerspective element, Map<PerspectiveDockable, Integer> children) {
        if (children == null) {
            return this.createLayout(null, -1, element.hasFullscreenAction());
        }
        SplitDockStationLayout.Entry root = this.convert(element.getRoot(), children);
        PerspectiveDockable fullscreenDockable = element.getFullscreen();
        Integer fullscreen = null;
        if (fullscreenDockable != null) {
            fullscreen = children.get(fullscreenDockable);
        }
        if (fullscreen == null) {
            return this.createLayout(element, root, -1, element.hasFullscreenAction());
        }
        return this.createLayout(element, root, (int)fullscreen, element.hasFullscreenAction());
    }

    private SplitDockStationLayout.Entry convert(SplitDockPerspective.Entry entry, Map<PerspectiveDockable, Integer> children) {
        if (entry == null) {
            return null;
        }
        if (entry.asNode() != null) {
            SplitDockPerspective.Node node = entry.asNode();
            SplitDockStationLayout.Entry childA = this.convert(node.getChildA(), children);
            SplitDockStationLayout.Entry childB = this.convert(node.getChildB(), children);
            if (childA == null) {
                return childB;
            }
            if (childB == null) {
                return childA;
            }
            return new SplitDockStationLayout.Node(node.getOrientation(), node.getDivider(), childA, childB, this.toArray(node.getPlaceholders()), node.getPlaceholderMap(), node.getNodeId());
        }
        if (entry.asLeaf() != null) {
            SplitDockPerspective.Leaf leaf = entry.asLeaf();
            Integer id = children.get(leaf.getDockable());
            return new SplitDockStationLayout.Leaf(id == null ? -1 : id, this.toArray(leaf.getPlaceholders()), leaf.getPlaceholderMap(), leaf.getNodeId());
        }
        return this.convert(((SplitDockPerspective.Root)entry).getChild(), children);
    }

    private Path[] toArray(Set<Path> placeholders) {
        if (placeholders == null) {
            return null;
        }
        return placeholders.toArray(new Path[placeholders.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayout(SplitDockStation station, SplitDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        DockableSplitDockTree tree = new DockableSplitDockTree();
        SplitDockTree.Key root = null;
        if (layout.getRoot() != null) {
            root = this.handleEntry(layout.getRoot(), tree, children);
        }
        if (root != null) {
            tree.root(root);
        }
        station.dropTree(tree, false);
        PlaceholderStrategy oldStrategy = station.getPlaceholderStrategy().getStrategy();
        if (placeholders != oldStrategy && placeholders != null) {
            try {
                station.setPlaceholderStrategy(placeholders);
            }
            finally {
                station.setPlaceholderStrategy(oldStrategy);
            }
        }
        Dockable fullscreen = children.get(layout.getFullscreen());
        station.setFullScreen(fullscreen);
    }

    @Override
    public SplitDockPerspective layoutPerspective(SplitDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        SplitDockPerspective result = new SplitDockPerspective();
        this.layoutPerspective(result, layout, children);
        return result;
    }

    @Override
    public void layoutPerspective(SplitDockPerspective perspective, SplitDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        if (children != null) {
            PerspectiveSplitDockTree tree = new PerspectiveSplitDockTree();
            SplitDockTree.Key root = null;
            if (layout.getRoot() != null) {
                root = this.handleEntry(layout.getRoot(), tree, children);
            }
            if (root != null) {
                tree.root(root);
            }
            perspective.read(tree, children.get(layout.getFullscreen()));
        }
        perspective.setHasFullscreenAction(layout.hasFullscreenAction());
    }

    private <D> SplitDockTree.Key handleEntry(SplitDockStationLayout.Entry entry, SplitDockTree<D> tree, Map<Integer, D> children) {
        if (entry.asLeaf() != null) {
            return this.handleLeaf(entry.asLeaf(), tree, children);
        }
        return this.handleNode(entry.asNode(), tree, children);
    }

    private <D> SplitDockTree.Key handleLeaf(SplitDockStationLayout.Leaf leaf, SplitDockTree<D> tree, Map<Integer, D> children) {
        D dockable = children.get(leaf.getId());
        Path[] placeholders = leaf.getPlaceholders();
        PlaceholderMap placeholderMap = leaf.getPlaceholderMap();
        if (dockable != null) {
            return tree.put(tree.array(dockable), (Object)null, placeholders, placeholderMap, leaf.getNodeId());
        }
        if (placeholders != null && placeholders.length > 0) {
            return tree.put((D[])tree.array(false), (Object)null, placeholders, placeholderMap, leaf.getNodeId());
        }
        return null;
    }

    private <D> SplitDockTree.Key handleNode(SplitDockStationLayout.Node node, SplitDockTree<D> tree, Map<Integer, D> children) {
        SplitDockTree.Key a = this.handleEntry(node.getChildA(), tree, children);
        SplitDockTree.Key b = this.handleEntry(node.getChildB(), tree, children);
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        switch (node.getOrientation()) {
            case HORIZONTAL: {
                return tree.horizontal(a, b, node.getDivider(), node.getPlaceholders(), node.getPlaceholderMap(), node.getNodeId());
            }
            case VERTICAL: {
                return tree.vertical(a, b, node.getDivider(), node.getPlaceholders(), node.getPlaceholderMap(), node.getNodeId());
            }
        }
        return null;
    }

    @Override
    public void estimateLocations(SplitDockStationLayout layout, LocationEstimationMap children) {
        this.estimateLocations(layout.getRoot(), children);
    }

    @Override
    private void estimateLocations(SplitDockStationLayout.Entry entry, LocationEstimationMap children) {
        SplitDockStationLayout.Node node;
        DockLayoutInfo info;
        if (entry == null) {
            return;
        }
        SplitDockStationLayout.Leaf leaf = entry.asLeaf();
        if (leaf != null && (info = children.getChild(leaf.getId())) != null) {
            SplitDockPathProperty property = leaf.createPathProperty();
            Path placeholder = info.getPlaceholder();
            if (placeholder != null) {
                info.setLocation(new SplitDockPlaceholderProperty(placeholder, property));
            } else {
                info.setLocation(property);
            }
            int n = children.getSubChildCount(leaf.getId());
            for (int i = 0; i < n; ++i) {
                DockLayoutInfo subInfo = children.getSubChild(leaf.getId(), i);
                placeholder = subInfo.getPlaceholder();
                if (placeholder == null) continue;
                subInfo.setLocation(new SplitDockPlaceholderProperty(placeholder, property));
            }
        }
        if ((node = entry.asNode()) != null) {
            this.estimateLocations(node.getChildA(), children);
            this.estimateLocations(node.getChildB(), children);
        }
    }

    @Override
    public void setLayout(SplitDockStation element, SplitDockStationLayout layout, PlaceholderStrategy placeholders) {
    }

    @Override
    public SplitDockStation layout(SplitDockStationLayout layout, PlaceholderStrategy placeholders) {
        SplitDockStation station = this.createStation(layout.hasFullscreenAction());
        this.setLayout(station, layout, placeholders);
        return station;
    }

    @Override
    public SplitDockStation layout(SplitDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        SplitDockStation station = this.createStation(layout.hasFullscreenAction());
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    @Override
    public void write(SplitDockStationLayout layout, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_1_0);
        SplitDockStationLayout.Entry root = layout.getRoot();
        if (root == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.writeEntry(root, out);
        }
        out.writeInt(layout.getFullscreen());
        out.writeBoolean(layout.hasFullscreenAction());
    }

    private void writeEntry(SplitDockStationLayout.Entry entry, DataOutputStream out) throws IOException {
        out.writeLong(entry.getNodeId());
        Path[] placeholders = entry.getPlaceholders();
        PlaceholderMap placeholderMap = entry.getPlaceholderMap();
        int flag = 0;
        if (entry.asNode() != null) {
            flag |= 1;
        }
        if (placeholders != null && placeholders.length > 0) {
            flag |= 2;
        }
        if (placeholderMap != null) {
            flag |= 4;
        }
        out.writeByte(flag);
        if (placeholders != null && placeholders.length > 0) {
            out.writeInt(placeholders.length);
            for (Path placeholder : placeholders) {
                out.writeUTF(placeholder.toString());
            }
        }
        if (placeholderMap != null) {
            placeholderMap.write(out);
        }
        if (entry.asLeaf() != null) {
            out.writeInt(entry.asLeaf().getId());
        } else {
            SplitDockStationLayout.Node node = entry.asNode();
            out.writeInt(node.getOrientation().ordinal());
            out.writeDouble(node.getDivider());
            this.writeEntry(node.getChildA(), out);
            this.writeEntry(node.getChildB(), out);
        }
    }

    @Override
    public SplitDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version8 = Version.VERSION_1_0_8.compareTo(version) <= 0;
        boolean version8a = Version.VERSION_1_0_8a.compareTo(version) <= 0;
        boolean version110 = Version.VERSION_1_1_0.compareTo(version) <= 0;
        SplitDockStationLayout.Entry root = null;
        if (in.readBoolean()) {
            root = this.readEntry(in, version8, version8a, placeholders);
        }
        int fullscreen = in.readInt();
        boolean fullscreenAction = true;
        if (version110) {
            fullscreenAction = in.readBoolean();
        }
        return this.createLayout(root, fullscreen, fullscreenAction);
    }

    private SplitDockStationLayout.Entry readEntry(DataInputStream in, boolean version8, boolean version8a, PlaceholderStrategy strategy) throws IOException {
        long id = -1L;
        if (version8) {
            id = in.readLong();
        }
        if (version8a) {
            byte flag = in.readByte();
            boolean node = (flag & 1) != 0;
            boolean hasPlaceholders = (flag & 2) != 0;
            boolean hasMap = (flag & 4) != 0;
            Path[] placeholders = null;
            if (hasPlaceholders) {
                placeholders = new Path[in.readInt()];
                for (int i = 0; i < placeholders.length; ++i) {
                    placeholders[i] = new Path(in.readUTF());
                }
            }
            PlaceholderMap placeholderMap = null;
            if (hasMap) {
                placeholderMap = new PlaceholderMap(in, strategy);
                placeholderMap.setPlaceholderStrategy(null);
            }
            if (node) {
                SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[in.readInt()];
                double divider = in.readDouble();
                SplitDockStationLayout.Entry childA = this.readEntry(in, version8, version8a, strategy);
                SplitDockStationLayout.Entry childB = this.readEntry(in, version8, version8a, strategy);
                return new SplitDockStationLayout.Node(orientation, divider, childA, childB, placeholders, placeholderMap, id);
            }
            return new SplitDockStationLayout.Leaf(in.readInt(), placeholders, placeholderMap, id);
        }
        byte kind = in.readByte();
        if (kind == 0) {
            return new SplitDockStationLayout.Leaf(in.readInt(), null, null, id);
        }
        if (kind == 1) {
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[in.readInt()];
            double divider = in.readDouble();
            SplitDockStationLayout.Entry childA = this.readEntry(in, version8, version8a, strategy);
            SplitDockStationLayout.Entry childB = this.readEntry(in, version8, version8a, strategy);
            return new SplitDockStationLayout.Node(orientation, divider, childA, childB, null, null, id);
        }
        if (kind == 2) {
            int childId = in.readInt();
            Path[] placeholders = this.readPlaceholders(in, strategy);
            return new SplitDockStationLayout.Leaf(childId, placeholders, null, id);
        }
        if (kind == 3) {
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[in.readInt()];
            double divider = in.readDouble();
            Path[] placeholders = this.readPlaceholders(in, strategy);
            SplitDockStationLayout.Entry childA = this.readEntry(in, version8, version8a, strategy);
            SplitDockStationLayout.Entry childB = this.readEntry(in, version8, version8a, strategy);
            return new SplitDockStationLayout.Node(orientation, divider, childA, childB, placeholders, null, id);
        }
        throw new IOException("unknown kind: " + kind);
    }

    private Path[] readPlaceholders(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        int length = in.readInt();
        ArrayList<Path> result = new ArrayList<Path>(length);
        for (int i = 0; i < length; ++i) {
            Path placeholder = new Path(in.readUTF());
            if (placeholders != null && !placeholders.isValidPlaceholder(placeholder)) continue;
            result.add(placeholder);
        }
        return result.toArray(new Path[result.size()]);
    }

    @Override
    public void write(SplitDockStationLayout layout, XElement element) {
        if (layout.getFullscreen() != -1) {
            element.addElement("fullscreen").addInt("id", layout.getFullscreen());
        }
        element.addElement("fullscreen-action").setBoolean(layout.hasFullscreenAction());
        if (layout.getRoot() != null) {
            this.writeEntry(layout.getRoot(), element);
        }
    }

    private void writeEntry(SplitDockStationLayout.Entry entry, XElement parent) {
        PlaceholderMap map;
        XElement xchild;
        if (entry.asLeaf() != null) {
            xchild = parent.addElement("leaf");
            xchild.addInt("id", entry.asLeaf().getId()).addLong("nodeId", entry.getNodeId());
        } else {
            xchild = parent.addElement("node");
            xchild.addLong("nodeId", entry.getNodeId());
            xchild.addString("orientation", entry.asNode().getOrientation().name());
            xchild.addDouble("divider", entry.asNode().getDivider());
            this.writeEntry(entry.asNode().getChildA(), xchild);
            this.writeEntry(entry.asNode().getChildB(), xchild);
        }
        Path[] placeholders = entry.getPlaceholders();
        if (placeholders != null && placeholders.length > 0) {
            XElement xplaceholders = xchild.addElement("placeholders");
            for (Path placeholder : placeholders) {
                xplaceholders.addElement("placeholder").setString(placeholder.toString());
            }
        }
        if ((map = entry.getPlaceholderMap()) != null) {
            XElement xmap = xchild.addElement("placeholder-map");
            map.write(xmap);
        }
    }

    @Override
    public SplitDockStationLayout read(XElement element, PlaceholderStrategy placeholders) {
        SplitDockStationLayout.Entry root = null;
        XElement xroot = element.getElement("node");
        if (xroot == null) {
            xroot = element.getElement("leaf");
        }
        if (xroot != null) {
            root = this.readEntry(xroot, placeholders);
        }
        int fullscreen = -1;
        XElement xfullscreen = element.getElement("fullscreen");
        if (xfullscreen != null) {
            fullscreen = xfullscreen.getInt("id");
        }
        XElement xfullscreenAction = element.getElement("fullscreen-action");
        boolean fullscreenAction = true;
        if (xfullscreenAction != null) {
            fullscreenAction = xfullscreenAction.getBoolean();
        }
        return this.createLayout(root, fullscreen, fullscreenAction);
    }

    private SplitDockStationLayout.Entry readEntry(XElement element, PlaceholderStrategy strategy) {
        XElement[] xchildren;
        long nodeId = -1L;
        if (element.attributeExists("nodeId")) {
            nodeId = element.getLong("nodeId");
        }
        Path[] placeholders = null;
        XElement xplaceholders = element.getElement("placeholders");
        if (xplaceholders != null && (xchildren = xplaceholders.getElements("placeholder")).length > 0) {
            ArrayList<Path> collection = new ArrayList<Path>(xchildren.length);
            for (int i = 0; i < xchildren.length; ++i) {
                Path placeholder = new Path(xchildren[i].getString());
                if (strategy != null && !strategy.isValidPlaceholder(placeholder)) continue;
                collection.add(placeholder);
            }
            placeholders = collection.toArray(new Path[collection.size()]);
        }
        PlaceholderMap map = null;
        XElement xmap = element.getElement("placeholder-map");
        if (xmap != null) {
            map = new PlaceholderMap(xmap, strategy);
            map.setPlaceholderStrategy(null);
        }
        if ("leaf".equals(element.getName())) {
            return new SplitDockStationLayout.Leaf(element.getInt("id"), placeholders, map, nodeId);
        }
        if ("node".equals(element.getName())) {
            XElement[] xchildren2 = element.getElements("leaf", "node");
            if (xchildren2.length != 2) {
                throw new XException("node element must have exactly least two children: " + element);
            }
            return new SplitDockStationLayout.Node(SplitDockStation.Orientation.valueOf(element.getString("orientation")), element.getDouble("divider"), this.readEntry(xchildren2[0], strategy), this.readEntry(xchildren2[1], strategy), placeholders, map, nodeId);
        }
        throw new XException("element neither leaf nor node: " + element);
    }

    protected SplitDockStation createStation(boolean hasFullscreenAction) {
        return new SplitDockStation(hasFullscreenAction);
    }
}

