/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.security.GlassedPane;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.SplitDividerStrategy;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DefaultSplitDividerStrategy
implements SplitDividerStrategy {
    private Map<SplitDockStation, Handler> handlers = new HashMap<SplitDockStation, Handler>();

    public void install(SplitDockStation station, Component container) {
        Handler handler = this.createHandlerFor(station);
        handler.install(container);
        this.handlers.put(station, handler);
    }

    public void uninstall(SplitDockStation station) {
        Handler handler = this.handlers.remove(station);
        if (handler != null) {
            handler.destroy();
        }
    }

    public void paint(SplitDockStation station, Graphics g) {
        Handler handler = this.handlers.get(station);
        if (handler != null) {
            handler.paint(g);
        }
    }

    protected Handler createHandlerFor(SplitDockStation station) {
        return new Handler(station);
    }

    public static class Handler
    extends MouseAdapter
    implements MouseListener,
    MouseMotionListener,
    AWTEventListener,
    DockHierarchyListener {
        private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

            @Override
            protected void valueChanged(Boolean oldValue, Boolean newValue) {
                Handler.this.updateEventListener();
            }
        };
        private DockController controller;
        private Divideable current;
        private double divider;
        private boolean pressed = false;
        private boolean withinBounds = false;
        private boolean awtListenerEnabled = false;
        private Rectangle bounds = new Rectangle();
        private int deltaX;
        private int deltaY;
        private SplitDockStation station;
        private Component container;

        public Handler(SplitDockStation station) {
            this.station = station;
        }

        public SplitDockStation getStation() {
            return this.station;
        }

        public void install(Component container) {
            if (this.container != null) {
                throw new IllegalStateException("already initialized");
            }
            this.container = container;
            container.addMouseListener(this);
            container.addMouseMotionListener(this);
            this.station.addDockHierarchyListener(this);
            this.setController(this.station.getController());
        }

        public void hierarchyChanged(DockHierarchyEvent event) {
        }

        public void controllerChanged(DockHierarchyEvent event) {
            this.setController(this.station.getController());
        }

        private void setController(DockController controller) {
            if (this.controller != controller) {
                this.controller = controller;
                this.restricted.setProperties(controller);
                this.updateEventListener();
            }
        }

        private void updateEventListener() {
            boolean expected;
            boolean bl = expected = this.controller != null && !this.controller.isRestrictedEnvironment();
            if (expected != this.awtListenerEnabled) {
                this.awtListenerEnabled = expected;
                if (expected) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
                } else {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                }
            }
        }

        public void eventDispatched(AWTEvent event) {
            MouseEvent mev;
            if ((event.getID() == 503 || event.getID() == 502) && (mev = (MouseEvent)event).getSource() != this.container && this.withinBounds) {
                if (mev.getSource() instanceof GlassedPane.GlassPane) {
                    this.checkMousePositionAsync();
                } else {
                    Point p = SwingUtilities.convertPoint(mev.getComponent(), mev.getPoint(), this.station);
                    if (this.station.getBounds().contains(p)) {
                        this.setCursor(null);
                        this.withinBounds = false;
                    }
                }
            }
        }

        public Component getContainer() {
            return this.container;
        }

        public void destroy() {
            if (this.container != null) {
                this.setCursor(null);
                this.current = null;
                this.container.removeMouseListener(this);
                this.container.removeMouseMotionListener(this);
                this.container = null;
                try {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.setController(null);
                this.station.removeDockHierarchyListener(this);
            }
        }

        protected void setCursor(Cursor cursor) {
            this.container.setCursor(cursor);
        }

        protected void repaint(int x, int y, int width, int height) {
            this.container.repaint(x, y, width, height);
        }

        protected Divideable getDividerNode(int x, int y) {
            return this.station.getRoot().getDividerNode(x, y);
        }

        protected void checkMousePositionAsync() {
            DockController controller = this.station.getController();
            if (controller != null && !this.awtListenerEnabled) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (Handler.this.container != null) {
                            PointerInfo p = MouseInfo.getPointerInfo();
                            Point e = p.getLocation();
                            SwingUtilities.convertPointFromScreen(e, Handler.this.container);
                            Handler.this.current = Handler.this.getDividerNode(e.x, e.y);
                            if (Handler.this.current == null) {
                                Handler.this.mouseExited(null);
                            } else if (((Handler)Handler.this).bounds.width > 2 && ((Handler)Handler.this).bounds.height > 2 && (e.x <= ((Handler)Handler.this).bounds.x || e.x >= ((Handler)Handler.this).bounds.x + ((Handler)Handler.this).bounds.width - 1 || e.y <= ((Handler)Handler.this).bounds.y || e.y >= ((Handler)Handler.this).bounds.y + ((Handler)Handler.this).bounds.height - 1)) {
                                Handler.this.mouseExited(null);
                            }
                        }
                    }
                });
            }
        }

        public void mousePressed(MouseEvent e) {
            if (this.station.isResizingEnabled() && !this.station.isDisabled() && !this.pressed) {
                this.pressed = true;
                this.mouseMoved(e);
                if (this.current != null) {
                    this.divider = this.current.getDividerAt(e.getX() + this.deltaX, e.getY() + this.deltaY);
                    this.divider = this.current.validateDivider(this.divider);
                    this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    this.bounds = this.current.getDividerBounds(this.divider, this.bounds);
                    this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.station.isResizingEnabled() && !this.station.isDisabled() && this.pressed && this.current != null) {
                this.divider = this.current.getDividerAt(e.getX() + this.deltaX, e.getY() + this.deltaY);
                this.divider = this.current.validateDivider(this.divider);
                this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.bounds = this.current.getDividerBounds(this.divider, this.bounds);
                this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                if (this.station.isContinousDisplay() && this.current != null) {
                    this.setDivider(this.current, this.divider);
                    this.station.updateBounds();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.pressed) {
                this.pressed = false;
                if (this.current != null) {
                    this.setDivider(this.current, this.divider);
                    this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    this.station.updateBounds();
                }
                this.setCursor(null);
                this.mouseMoved(e);
                if (this.controller != null && !this.controller.isRestrictedEnvironment() && this.awtListenerEnabled) {
                    this.eventDispatched(e);
                } else {
                    this.checkMousePositionAsync();
                }
            }
        }

        protected void setDivider(Divideable node, double dividier) {
            node.setDivider(dividier);
        }

        public void mouseMoved(MouseEvent e) {
            if (this.station.isResizingEnabled() && !this.station.isDisabled()) {
                this.current = this.getDividerNode(e.getX(), e.getY());
                if (this.current == null) {
                    this.setCursor(null);
                } else if (this.current.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                }
                if (this.current != null) {
                    this.bounds = this.current.getDividerBounds(this.current.getDivider(), this.bounds);
                    this.deltaX = this.bounds.width / 2 + this.bounds.x - e.getX();
                    this.deltaY = this.bounds.height / 2 + this.bounds.y - e.getY();
                    this.withinBounds = true;
                } else {
                    this.withinBounds = false;
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!this.pressed) {
                this.current = null;
                this.setCursor(null);
                this.withinBounds = false;
            }
        }

        public void paint(Graphics g) {
            if (this.station.isResizingEnabled() && !this.station.isDisabled() && this.current != null && this.pressed) {
                this.station.getPaint().drawDivider(g, this.bounds);
            }
        }
    }
}

