/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.disable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.util.HashSet;
import java.util.Set;

public abstract class TabDisablingStrategyObserver {
    private PropertyValue<DisablingStrategy> disablingStrategy = new PropertyValue<DisablingStrategy>(DisablingStrategy.STRATEGY){

        @Override
        protected void valueChanged(DisablingStrategy oldValue, DisablingStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeDisablingStrategyListener(TabDisablingStrategyObserver.this.disablingStrategyListener);
            }
            if (newValue != null) {
                newValue.addDisablingStrategyListener(TabDisablingStrategyObserver.this.disablingStrategyListener);
            }
            for (Dockable item : TabDisablingStrategyObserver.this.items) {
                TabDisablingStrategyObserver.this.setDisabled(item, TabDisablingStrategyObserver.this.isDisabled(item));
            }
        }
    };
    private DisablingStrategyListener disablingStrategyListener = new DisablingStrategyListener(){

        public void changed(DockElement item) {
            Dockable dockable = item.asDockable();
            if (dockable != null && TabDisablingStrategyObserver.this.items.contains(dockable)) {
                TabDisablingStrategyObserver.this.setDisabled(dockable, TabDisablingStrategyObserver.this.isDisabled(dockable));
            }
        }
    };
    private Set<Dockable> items = new HashSet<Dockable>();

    public void setController(DockController controller) {
        this.disablingStrategy.setProperties(controller);
    }

    public void add(Dockable dockable) {
        this.items.add(dockable);
        this.setDisabled(dockable, this.isDisabled(dockable));
    }

    public void remove(Dockable dockable) {
        this.items.remove(dockable);
        this.setDisabled(dockable, false);
    }

    public boolean isDisabled(Dockable dockable) {
        DisablingStrategy strategy = this.disablingStrategy.getValue();
        if (strategy == null) {
            return false;
        }
        return strategy.isTabDisabled(dockable);
    }

    public abstract void setDisabled(Dockable var1, boolean var2);
}

