/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.exbin.framework.editor.text.options.gui.TextEncodingPanel;
import org.exbin.framework.editor.text.options.impl.TextEncodingOptionsImpl;
import org.exbin.framework.editor.text.service.TextEncodingService;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class TextEncodingOptionsPanel
extends JPanel
implements OptionsComponent<TextEncodingOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextEncodingOptionsPanel.class);
    private TextEncodingService textEncodingService;
    private final TextEncodingPanel encodingPanel;
    private final DefaultEncodingComboBoxModel encodingComboBoxModel = new DefaultEncodingComboBoxModel();
    private JComboBox<String> defaultEncodingComboBox;
    private JLabel defaultEncodingLabel;
    private JPanel defaultEncodingPanel;
    private JPanel encodingsControlPanel;
    private JButton fillCurrentEncodingButton;
    private JButton fillCurrentEncodingsButton;

    public TextEncodingOptionsPanel() {
        this.encodingPanel = new TextEncodingPanel();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.encodingPanel.setEnabled(false);
        this.encodingPanel.setOptionsModifiedListener(() -> {
            this.setModified(true);
            this.updateEncodings();
        });
        super.add((Component)this.encodingPanel, "Center");
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setTextEncodingService(TextEncodingService textEncodingService) {
        this.textEncodingService = textEncodingService;
        this.fillCurrentEncodingButton.setEnabled(true);
        this.fillCurrentEncodingsButton.setEnabled(true);
    }

    public void saveToOptions(TextEncodingOptionsImpl options) {
        this.encodingPanel.saveToOptions(options);
        options.setSelectedEncoding((String)this.defaultEncodingComboBox.getSelectedItem());
    }

    public void loadFromOptions(TextEncodingOptionsImpl options) {
        this.encodingPanel.loadFromOptions(options);
        this.defaultEncodingComboBox.setSelectedItem(options.getSelectedEncoding());
        this.updateEncodings();
    }

    private void initComponents() {
        this.defaultEncodingPanel = new JPanel();
        this.defaultEncodingComboBox = new JComboBox();
        this.defaultEncodingLabel = new JLabel();
        this.fillCurrentEncodingButton = new JButton();
        this.encodingsControlPanel = new JPanel();
        this.fillCurrentEncodingsButton = new JButton();
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.defaultEncodingPanel.setName("defaultEncodingPanel");
        this.defaultEncodingComboBox.setModel(this.encodingComboBoxModel);
        this.defaultEncodingComboBox.setName("defaultEncodingComboBox");
        this.defaultEncodingComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextEncodingOptionsPanel.this.defaultEncodingComboBoxItemStateChanged(evt);
            }
        });
        this.defaultEncodingLabel.setText(this.resourceBundle.getString("defaultEncodingLabel.text"));
        this.defaultEncodingLabel.setName("defaultEncodingLabel");
        this.fillCurrentEncodingButton.setText(this.resourceBundle.getString("fillCurrentEncodingButton.text"));
        this.fillCurrentEncodingButton.setEnabled(false);
        this.fillCurrentEncodingButton.setName("fillCurrentEncodingButton");
        this.fillCurrentEncodingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEncodingOptionsPanel.this.fillCurrentEncodingButtonActionPerformed(evt);
            }
        });
        GroupLayout defaultEncodingPanelLayout = new GroupLayout(this.defaultEncodingPanel);
        this.defaultEncodingPanel.setLayout(defaultEncodingPanelLayout);
        defaultEncodingPanelLayout.setHorizontalGroup(defaultEncodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultEncodingPanelLayout.createSequentialGroup().addContainerGap().addGroup(defaultEncodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultEncodingLabel, -1, -1, Short.MAX_VALUE).addGroup(defaultEncodingPanelLayout.createSequentialGroup().addComponent(this.fillCurrentEncodingButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.defaultEncodingComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        defaultEncodingPanelLayout.setVerticalGroup(defaultEncodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultEncodingPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.defaultEncodingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultEncodingComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fillCurrentEncodingButton)));
        this.add((Component)this.defaultEncodingPanel, "North");
        this.encodingsControlPanel.setName("encodingsControlPanel");
        this.fillCurrentEncodingsButton.setText(this.resourceBundle.getString("fillCurrentEncodingsButton.text"));
        this.fillCurrentEncodingsButton.setEnabled(false);
        this.fillCurrentEncodingsButton.setName("fillCurrentEncodingsButton");
        this.fillCurrentEncodingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEncodingOptionsPanel.this.fillCurrentEncodingsButtonActionPerformed(evt);
            }
        });
        GroupLayout encodingsControlPanelLayout = new GroupLayout(this.encodingsControlPanel);
        this.encodingsControlPanel.setLayout(encodingsControlPanelLayout);
        encodingsControlPanelLayout.setHorizontalGroup(encodingsControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingsControlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fillCurrentEncodingsButton).addContainerGap(82, Short.MAX_VALUE)));
        encodingsControlPanelLayout.setVerticalGroup(encodingsControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingsControlPanelLayout.createSequentialGroup().addComponent(this.fillCurrentEncodingsButton).addGap(0, 11, Short.MAX_VALUE)));
        this.add((Component)this.encodingsControlPanel, "South");
    }

    private void fillCurrentEncodingsButtonActionPerformed(ActionEvent evt) {
        this.encodingPanel.setEncodingList(this.textEncodingService.getEncodings());
        this.encodingPanel.repaint();
        this.updateEncodings();
        this.setModified(true);
    }

    private void fillCurrentEncodingButtonActionPerformed(ActionEvent evt) {
        this.defaultEncodingComboBox.setSelectedItem(this.textEncodingService.getSelectedEncoding());
        this.defaultEncodingComboBox.repaint();
        this.setModified(true);
    }

    private void defaultEncodingComboBoxItemStateChanged(ItemEvent evt) {
        this.setModified(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextEncodingOptionsPanel());
    }

    private void setModified(boolean b) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener optionsModifiedListener) {
        this.optionsModifiedListener = optionsModifiedListener;
    }

    private void updateEncodings() {
        this.encodingComboBoxModel.setAvailableEncodings(this.encodingPanel.getEncodingList());
        this.defaultEncodingComboBox.repaint();
    }

    public void setAddEncodingsOperation(TextEncodingPanel.AddEncodingsOperation addEncodingsOperation) {
        this.encodingPanel.setAddEncodingsOperation(addEncodingsOperation);
    }

    @ParametersAreNonnullByDefault
    public class DefaultEncodingComboBoxModel
    implements ComboBoxModel<String> {
        private List<String> availableEncodings = new ArrayList<String>();
        private String selectedEncoding = null;
        private final List<ListDataListener> dataListeners = new ArrayList<ListDataListener>();

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedEncoding = (String)anItem;
        }

        @Override
        @Nullable
        public Object getSelectedItem() {
            return this.selectedEncoding;
        }

        @Override
        public int getSize() {
            return this.availableEncodings.size();
        }

        @Override
        @Nonnull
        public String getElementAt(int index) {
            return this.availableEncodings.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this.dataListeners.add(listener);
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this.dataListeners.remove(listener);
        }

        @Nonnull
        public List<String> getAvailableEncodings() {
            return this.availableEncodings;
        }

        public void setAvailableEncodings(List<String> encodings) {
            this.availableEncodings = new ArrayList<String>();
            if (encodings.isEmpty()) {
                this.availableEncodings.add("UTF-8");
            } else {
                this.availableEncodings.addAll(encodings);
            }
            int position = this.availableEncodings.indexOf(this.selectedEncoding);
            this.selectedEncoding = this.availableEncodings.get(position > 0 ? position : 0);
            for (int index = 0; index < this.dataListeners.size(); ++index) {
                ListDataListener listDataListener = this.dataListeners.get(index);
                listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, this.availableEncodings.size()));
            }
        }

        @Nonnull
        public String getSelectedEncoding() {
            return this.selectedEncoding;
        }

        public void setSelectedEncoding(String selectedEncoding) {
            this.selectedEncoding = selectedEncoding;
        }
    }
}

