/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

public class TextGoToPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextGoToPanel.class);
    private JLabel jumpLineLabel;
    private JSpinner jumpLineSpinner;
    private JLabel posLineLabel;
    private JSpinner posLineSpinner;

    public TextGoToPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        ((JSpinner.DefaultEditor)this.jumpLineSpinner.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof JTextComponent) {
                    JTextComponent textComponent = (JTextComponent)e.getSource();
                    SwingUtilities.invokeLater(textComponent::selectAll);
                }
            }
        });
    }

    private void initComponents() {
        this.jumpLineLabel = new JLabel();
        this.jumpLineSpinner = new JSpinner();
        this.posLineLabel = new JLabel();
        this.posLineSpinner = new JSpinner();
        this.jumpLineLabel.setText(this.resourceBundle.getString("jumpLineLabel.text"));
        this.jumpLineSpinner.setModel(new SpinnerNumberModel(1, 1, 1, 1));
        this.posLineLabel.setText(this.resourceBundle.getString("posLineLabel.text"));
        this.posLineSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jumpLineSpinner, -1, 169, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jumpLineLabel).addComponent(this.posLineLabel)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.posLineSpinner, -1, 169, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jumpLineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jumpLineSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.posLineLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.posLineSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextGoToPanel());
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setCharPos(int i) {
        ((SpinnerNumberModel)this.posLineSpinner.getModel()).setValue(i);
    }

    public int getLine() {
        return (Integer)this.jumpLineSpinner.getValue();
    }

    public int getCharPos() {
        return (Integer)this.posLineSpinner.getValue();
    }

    public void setMaxLine(int i) {
        ((SpinnerNumberModel)this.jumpLineSpinner.getModel()).setMaximum(Integer.valueOf(i));
    }

    public void setMaxCharPos(int i) {
        ((SpinnerNumberModel)this.posLineSpinner.getModel()).setMaximum(Integer.valueOf(i));
    }

    public void setSelected() {
        this.jumpLineSpinner.requestFocusInWindow();
    }

    public void initFocus() {
    }
}

