/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.text.gui.InputListPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class TextFontPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextFontPanel.class);
    private static String[] fontNames;
    private static String[] fontSizes;
    private JCheckBox boldCheckBox;
    private InputListPanel fontFamilyInputList;
    private JLabel fontFamilyLabel;
    private JPanel fontFamilyPanel;
    private JPanel fontPanel;
    private InputListPanel fontSizeInputList;
    private JLabel fontSizeLabel;
    private JPanel fontSizePanel;
    private JPanel fontStylePanel;
    private JCheckBox italicCheckBox;
    private JPanel previewPanel;
    private JTextField previewTextField;
    private JCheckBox strikethroughCheckBox;
    private JCheckBox subscriptCheckBox;
    private JCheckBox superscriptCheckBox;
    private JCheckBox underlineCheckBox;

    public TextFontPanel() {
        this.initComponents();
        ActionListener actionListener = e -> this.updatePreview();
        InputListPanel.ChangeListener changeListener = this::updatePreview;
        this.boldCheckBox.addActionListener(actionListener);
        this.italicCheckBox.addActionListener(actionListener);
        this.underlineCheckBox.addActionListener(actionListener);
        this.strikethroughCheckBox.addActionListener(actionListener);
        this.subscriptCheckBox.addActionListener(actionListener);
        this.superscriptCheckBox.addActionListener(actionListener);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        fontNames = ge.getAvailableFontFamilyNames();
        this.fontFamilyInputList.setItems(fontNames);
        this.fontFamilyInputList.setChangeListener(changeListener);
        fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        this.fontSizeInputList.setItems(fontSizes);
        this.fontSizeInputList.setChangeListener(changeListener);
    }

    private void updatePreview() {
        this.previewTextField.setFont(this.getStoredFont());
        this.previewTextField.repaint();
        this.subscriptCheckBox.setEnabled(!this.superscriptCheckBox.isSelected() || this.superscriptCheckBox.isSelected() && this.subscriptCheckBox.isSelected());
        this.superscriptCheckBox.setEnabled(!this.subscriptCheckBox.isSelected());
    }

    @Nullable
    public Font getStoredFont() {
        String fontName = this.fontFamilyInputList.getSelectedValue();
        String fontSize = this.fontSizeInputList.getSelectedValue();
        int size = -1;
        try {
            size = Integer.parseInt(fontSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (size <= 0) {
            return null;
        }
        HashMap<TextAttribute, Object> attribs = new HashMap<TextAttribute, Object>();
        attribs.put(TextAttribute.FAMILY, fontName);
        attribs.put(TextAttribute.SIZE, Float.valueOf(size));
        if (this.boldCheckBox.isSelected()) {
            attribs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.italicCheckBox.isSelected()) {
            attribs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this.underlineCheckBox.isSelected()) {
            attribs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        if (this.strikethroughCheckBox.isSelected()) {
            attribs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.subscriptCheckBox.isSelected()) {
            attribs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        if (this.superscriptCheckBox.isSelected()) {
            attribs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        return new Font(attribs);
    }

    public void setStoredFont(Font font) {
        Map<TextAttribute, ?> attribs = font.getAttributes();
        this.fontFamilyInputList.setSelectedValue((String)attribs.get(TextAttribute.FAMILY));
        Float fontSize = (Float)attribs.get(TextAttribute.SIZE);
        if (fontSize != null) {
            this.fontSizeInputList.setSelectedValue(String.valueOf((int)fontSize.floatValue()));
        } else {
            this.fontSizeInputList.setSelectedValue(String.valueOf(12));
        }
        this.underlineCheckBox.setSelected(TextAttribute.UNDERLINE_LOW_ONE_PIXEL.equals(attribs.get(TextAttribute.UNDERLINE)));
        this.strikethroughCheckBox.setSelected(TextAttribute.STRIKETHROUGH_ON.equals(attribs.get(TextAttribute.STRIKETHROUGH)));
        this.boldCheckBox.setSelected(TextAttribute.WEIGHT_BOLD.equals(attribs.get(TextAttribute.WEIGHT)));
        this.italicCheckBox.setSelected(TextAttribute.POSTURE_OBLIQUE.equals(attribs.get(TextAttribute.POSTURE)));
        this.subscriptCheckBox.setSelected(TextAttribute.SUPERSCRIPT_SUB.equals(attribs.get(TextAttribute.SUPERSCRIPT)));
        this.superscriptCheckBox.setSelected(TextAttribute.SUPERSCRIPT_SUPER.equals(attribs.get(TextAttribute.SUPERSCRIPT)));
        this.updatePreview();
    }

    public void initFont() {
        this.setStoredFont(this.previewTextField.getFont());
    }

    private void initComponents() {
        this.fontPanel = new JPanel();
        this.fontFamilyPanel = new JPanel();
        this.fontFamilyLabel = new JLabel();
        this.fontFamilyInputList = new InputListPanel();
        this.fontSizePanel = new JPanel();
        this.fontSizeLabel = new JLabel();
        this.fontSizeInputList = new InputListPanel();
        this.fontStylePanel = new JPanel();
        this.boldCheckBox = new JCheckBox();
        this.italicCheckBox = new JCheckBox();
        this.underlineCheckBox = new JCheckBox();
        this.strikethroughCheckBox = new JCheckBox();
        this.subscriptCheckBox = new JCheckBox();
        this.superscriptCheckBox = new JCheckBox();
        this.previewPanel = new JPanel();
        this.previewTextField = new JTextField();
        this.setName("Form");
        this.fontPanel.setName("fontPanel");
        this.fontPanel.setLayout(new BorderLayout());
        this.fontFamilyPanel.setName("fontFamilyPanel");
        this.fontFamilyLabel.setText(this.resourceBundle.getString("fontFamilyLabel.text"));
        this.fontFamilyLabel.setName("fontFamilyLabel");
        this.fontFamilyInputList.setName("fontFamilyInputList");
        GroupLayout fontFamilyPanelLayout = new GroupLayout(this.fontFamilyPanel);
        this.fontFamilyPanel.setLayout(fontFamilyPanelLayout);
        fontFamilyPanelLayout.setHorizontalGroup(fontFamilyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fontFamilyPanelLayout.createSequentialGroup().addContainerGap().addGroup(fontFamilyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontFamilyInputList, -1, -1, Short.MAX_VALUE).addComponent(this.fontFamilyLabel, -1, 279, Short.MAX_VALUE))));
        fontFamilyPanelLayout.setVerticalGroup(fontFamilyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fontFamilyPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fontFamilyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontFamilyInputList, -1, 177, Short.MAX_VALUE)));
        this.fontPanel.add((Component)this.fontFamilyPanel, "Center");
        this.fontSizePanel.setName("fontSizePanel");
        this.fontSizeLabel.setText(this.resourceBundle.getString("fontSizeLabel.text"));
        this.fontSizeLabel.setName("fontSizeLabel");
        this.fontSizeInputList.setName("fontSizeInputList");
        GroupLayout fontSizePanelLayout = new GroupLayout(this.fontSizePanel);
        this.fontSizePanel.setLayout(fontSizePanelLayout);
        fontSizePanelLayout.setHorizontalGroup(fontSizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fontSizePanelLayout.createSequentialGroup().addContainerGap().addGroup(fontSizePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fontSizeInputList, -2, 0, Short.MAX_VALUE).addComponent(this.fontSizeLabel, -1, 124, Short.MAX_VALUE)).addContainerGap()));
        fontSizePanelLayout.setVerticalGroup(fontSizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fontSizePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fontSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontSizeInputList, -1, 177, Short.MAX_VALUE)));
        this.fontPanel.add((Component)this.fontSizePanel, "East");
        this.fontStylePanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("fontStylePanel.border.title")));
        this.fontStylePanel.setName("fontStylePanel");
        this.fontStylePanel.setLayout(new GridLayout(2, 3));
        this.boldCheckBox.setMnemonic('b');
        this.boldCheckBox.setText(this.resourceBundle.getString("boldCheckBox.text"));
        this.boldCheckBox.setName("boldCheckBox");
        this.fontStylePanel.add(this.boldCheckBox);
        this.italicCheckBox.setMnemonic('i');
        this.italicCheckBox.setText(this.resourceBundle.getString("italicCheckBox.text"));
        this.italicCheckBox.setName("italicCheckBox");
        this.fontStylePanel.add(this.italicCheckBox);
        this.underlineCheckBox.setMnemonic('u');
        this.underlineCheckBox.setText(this.resourceBundle.getString("underlineCheckBox.text"));
        this.underlineCheckBox.setName("underlineCheckBox");
        this.fontStylePanel.add(this.underlineCheckBox);
        this.strikethroughCheckBox.setMnemonic('s');
        this.strikethroughCheckBox.setText(this.resourceBundle.getString("strikethroughCheckBox.text"));
        this.strikethroughCheckBox.setName("strikethroughCheckBox");
        this.fontStylePanel.add(this.strikethroughCheckBox);
        this.subscriptCheckBox.setMnemonic('t');
        this.subscriptCheckBox.setText(this.resourceBundle.getString("subscriptCheckBox.text"));
        this.subscriptCheckBox.setName("subscriptCheckBox");
        this.fontStylePanel.add(this.subscriptCheckBox);
        this.superscriptCheckBox.setMnemonic('p');
        this.superscriptCheckBox.setText(this.resourceBundle.getString("superscriptCheckBox.text"));
        this.superscriptCheckBox.setName("superscriptCheckBox");
        this.fontStylePanel.add(this.superscriptCheckBox);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("previewPanel.border.title")));
        this.previewPanel.setName("previewPanel");
        this.previewTextField.setHorizontalAlignment(0);
        this.previewTextField.setText(this.resourceBundle.getString("previewTextField.text"));
        this.previewTextField.setName("previewTextField");
        GroupLayout previewPanelLayout = new GroupLayout(this.previewPanel);
        this.previewPanel.setLayout(previewPanelLayout);
        previewPanelLayout.setHorizontalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewTextField));
        previewPanelLayout.setVerticalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewTextField, -1, 69, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addComponent(this.fontStylePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fontPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontStylePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -2, -1, -2).addContainerGap()));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextFontPanel());
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

