/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.exbin.framework.utils.WindowUtils;

public class InputListPanel
extends JPanel {
    private ActionListener actionListener;
    private ChangeListener changeListener;
    private String[] items;
    private boolean textUpdating = false;
    private JList<String> itemList;
    private JScrollPane scrollPane;
    private JTextField textField;

    public InputListPanel() {
        this.initComponents();
    }

    public void setItems(final String[] items) {
        this.items = items;
        this.itemList.setModel((ListModel<String>)new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return items.length;
            }

            @Override
            public String getElementAt(int index) {
                return items[index];
            }
        });
        this.itemList.addListSelectionListener(e -> {
            if (!this.textUpdating) {
                String selectedValue = this.itemList.getSelectedValue();
                this.textField.setText(selectedValue);
            }
        });
        this.textField.addActionListener(e -> this.valueChanged());
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                InputListPanel.this.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InputListPanel.this.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InputListPanel.this.valueChanged();
            }
        });
    }

    private void valueChanged() {
        String key = this.textField.getText().toLowerCase();
        if (!key.isEmpty()) {
            this.textUpdating = true;
            this.itemList.clearSelection();
            for (String item : this.items) {
                if (!item.toLowerCase().startsWith(key)) continue;
                this.itemList.setSelectedValue(item, true);
                break;
            }
            this.textUpdating = false;
        }
        if (this.changeListener != null) {
            this.changeListener.valueChanged();
        }
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public String getSelectedValue() {
        return this.textField.getText();
    }

    public void setSelectedValue(String item) {
        this.textField.setText(item);
    }

    private void initComponents() {
        this.textField = new JTextField();
        this.scrollPane = new JScrollPane();
        this.itemList = new JList();
        this.setName("Form");
        this.textField.setName("textField");
        this.scrollPane.setName("scrollPane");
        this.itemList.setSelectionMode(0);
        this.itemList.setName("itemList");
        this.itemList.setVisibleRowCount(4);
        this.scrollPane.setViewportView(this.itemList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textField).addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.textField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new InputListPanel());
    }

    public static interface ChangeListener {
        public void valueChanged();
    }
}

