/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.action.api.ToolBarGroup;
import org.exbin.framework.action.api.ToolBarPosition;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.api.XBModuleRepositoryUtils;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.EncodingsHandler;
import org.exbin.framework.editor.text.TextEditor;
import org.exbin.framework.editor.text.action.FindReplaceActions;
import org.exbin.framework.editor.text.action.GoToLineAction;
import org.exbin.framework.editor.text.action.PrintAction;
import org.exbin.framework.editor.text.action.PropertiesAction;
import org.exbin.framework.editor.text.action.TextColorAction;
import org.exbin.framework.editor.text.action.TextFontAction;
import org.exbin.framework.editor.text.action.WordWrappingAction;
import org.exbin.framework.editor.text.gui.AddEncodingPanel;
import org.exbin.framework.editor.text.gui.TextFontPanel;
import org.exbin.framework.editor.text.gui.TextPanel;
import org.exbin.framework.editor.text.gui.TextStatusPanel;
import org.exbin.framework.editor.text.options.gui.TextAppearanceOptionsPanel;
import org.exbin.framework.editor.text.options.gui.TextColorOptionsPanel;
import org.exbin.framework.editor.text.options.gui.TextEncodingOptionsPanel;
import org.exbin.framework.editor.text.options.gui.TextFontOptionsPanel;
import org.exbin.framework.editor.text.options.impl.TextAppearanceOptionsImpl;
import org.exbin.framework.editor.text.options.impl.TextColorOptionsImpl;
import org.exbin.framework.editor.text.options.impl.TextEncodingOptionsImpl;
import org.exbin.framework.editor.text.options.impl.TextFontOptionsImpl;
import org.exbin.framework.editor.text.preferences.TextAppearancePreferences;
import org.exbin.framework.editor.text.preferences.TextColorPreferences;
import org.exbin.framework.editor.text.preferences.TextEncodingPreferences;
import org.exbin.framework.editor.text.preferences.TextFontPreferences;
import org.exbin.framework.editor.text.service.TextAppearanceService;
import org.exbin.framework.editor.text.service.TextColorService;
import org.exbin.framework.editor.text.service.TextEncodingService;
import org.exbin.framework.editor.text.service.TextFontService;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.options.api.DefaultOptionsPage;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.options.api.OptionsPage;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class EditorTextModule
implements XBApplicationModule {
    public static final String MODULE_ID = XBModuleRepositoryUtils.getModuleIdByApi(EditorTextModule.class);
    private static final String EDIT_FIND_MENU_GROUP_ID = MODULE_ID + ".editFindMenuGroup";
    private static final String EDIT_FIND_TOOL_BAR_GROUP_ID = MODULE_ID + ".editFindToolBarGroup";
    public static final String XBT_FILE_TYPE = "XBTextEditor.XBTFileType";
    public static final String TXT_FILE_TYPE = "XBTextEditor.TXTFileType";
    public static final String TEXT_STATUS_BAR_ID = "textStatusBar";
    private XBApplication application;
    private EditorProvider editorProvider;
    private ResourceBundle resourceBundle;
    private TextStatusPanel textStatusPanel;
    private FindReplaceActions findReplaceActions;
    private TextFontAction textFontAction;
    private TextColorAction textColorAction;
    private EncodingsHandler encodingsHandler;
    private WordWrappingAction wordWrappingAction;
    private GoToLineAction goToLineAction;
    private PropertiesAction propertiesAction;
    private PrintAction printAction;

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void unregisterModule(String moduleId) {
    }

    private void ensureSetup() {
        if (this.editorProvider == null) {
            this.getEditorProvider();
        }
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nonnull
    public EditorProvider getEditorProvider() {
        if (this.editorProvider == null) {
            this.editorProvider = new TextEditor(this.application);
        }
        return this.editorProvider;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(EditorTextModule.class);
        }
        return this.resourceBundle;
    }

    public void registerFileTypes() {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.addFileType((FileType)new TXTFileType());
        fileModule.addFileType((FileType)new XBTFileType());
    }

    public void registerStatusBar() {
        this.textStatusPanel = new TextStatusPanel();
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        frameModule.registerStatusBar(MODULE_ID, TEXT_STATUS_BAR_ID, (JPanel)this.textStatusPanel);
        frameModule.switchStatusBar(TEXT_STATUS_BAR_ID);
        ((TextPanel)this.getEditorProvider().getEditorComponent()).registerTextStatus(this.textStatusPanel);
        if (this.encodingsHandler != null) {
            this.encodingsHandler.setTextEncodingStatus(this.textStatusPanel);
        }
    }

    public void registerOptionsMenuPanels() {
        this.getEncodingsHandler();
        this.encodingsHandler.rebuildEncodings();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, this.encodingsHandler.getToolsEncodingMenu(), new MenuPosition(PositionMode.TOP_LAST));
    }

    public void registerOptionsPanels() {
        OptionsModuleApi optionsModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        final TextColorService textColorService = new TextColorService(){

            @Override
            public Color[] getCurrentTextColors() {
                return ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).getCurrentColors();
            }

            @Override
            public Color[] getDefaultTextColors() {
                return ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).getDefaultColors();
            }

            @Override
            public void setCurrentTextColors(Color[] colors) {
                ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).setCurrentColors(colors);
            }
        };
        optionsModule.addOptionsPage((OptionsPage)new DefaultOptionsPage<TextColorOptionsImpl>(){
            private TextColorOptionsPanel panel;

            @Nonnull
            public OptionsComponent<TextColorOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new TextColorOptionsPanel();
                    this.panel.setTextColorService(textColorService);
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(TextColorOptionsPanel.class);
            }

            @Nonnull
            public TextColorOptionsImpl createOptions() {
                return new TextColorOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, TextColorOptionsImpl options) {
                options.loadFromPreferences(new TextColorPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, TextColorOptionsImpl options) {
                options.saveToPreferences(new TextColorPreferences(preferences));
            }

            public void applyPreferencesChanges(TextColorOptionsImpl options) {
                if (options.isUseDefaultColors()) {
                    textColorService.setCurrentTextColors(textColorService.getDefaultTextColors());
                } else {
                    Color[] colors = new Color[]{this.intToColor(options.getTextColor()), this.intToColor(options.getTextBackgroundColor()), this.intToColor(options.getSelectionTextColor()), this.intToColor(options.getSelectionBackgroundColor()), this.intToColor(options.getFoundBackgroundColor())};
                    textColorService.setCurrentTextColors(colors);
                }
            }

            @Nullable
            private Color intToColor(@Nullable Integer intValue) {
                return intValue == null ? null : new Color(intValue);
            }
        });
        final TextFontService textFontService = new TextFontService(){

            @Override
            public Font getCurrentFont() {
                return ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).getCurrentFont();
            }

            @Override
            public Font getDefaultFont() {
                return ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).getDefaultFont();
            }

            @Override
            public void setCurrentFont(Font font) {
                ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).setCurrentFont(font);
            }
        };
        optionsModule.addOptionsPage((OptionsPage)new DefaultOptionsPage<TextFontOptionsImpl>(){
            private TextFontOptionsPanel panel;

            public OptionsComponent<TextFontOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new TextFontOptionsPanel();
                    this.panel.setTextFontService(textFontService);
                    this.panel.setFontChangeAction(new TextFontOptionsPanel.FontChangeAction(){

                        @Override
                        public Font changeFont(Font currentFont) {
                            Result result = new Result();
                            FrameModuleApi frameModule = (FrameModuleApi)EditorTextModule.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                            TextFontPanel fontPanel = new TextFontPanel();
                            fontPanel.setStoredFont(currentFont);
                            DefaultControlPanel controlPanel = new DefaultControlPanel();
                            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)fontPanel, (JPanel)controlPanel);
                            WindowUtils.addHeaderPanel((Window)dialog.getWindow(), fontPanel.getClass(), (ResourceBundle)fontPanel.getResourceBundle());
                            frameModule.setDialogTitle(dialog, fontPanel.getResourceBundle());
                            controlPanel.setHandler(actionType -> {
                                if (actionType != DefaultControlHandler.ControlActionType.CANCEL) {
                                    if (actionType == DefaultControlHandler.ControlActionType.OK) {
                                        TextFontPreferences textFontParameters = new TextFontPreferences(EditorTextModule.this.application.getAppPreferences());
                                        textFontParameters.setUseDefaultFont(true);
                                        textFontParameters.setFont(fontPanel.getStoredFont());
                                    }
                                    result.font = fontPanel.getStoredFont();
                                }
                                dialog.close();
                                dialog.dispose();
                            });
                            dialog.showCentered((Component)frameModule.getFrame());
                            return result.font;
                        }

                        class Result {
                            Font font;

                            Result() {
                            }
                        }
                    });
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(TextFontOptionsPanel.class);
            }

            public TextFontOptionsImpl createOptions() {
                return new TextFontOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, TextFontOptionsImpl options) {
                options.loadFromPreferences(new TextFontPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, TextFontOptionsImpl options) {
                options.saveToPreferences(new TextFontPreferences(preferences));
            }

            public void applyPreferencesChanges(TextFontOptionsImpl options) {
                if (options.isUseDefaultFont()) {
                    textFontService.setCurrentFont(textFontService.getDefaultFont());
                } else {
                    textFontService.setCurrentFont(options.getFont(textFontService.getDefaultFont()));
                }
            }
        });
        final TextAppearanceService textAppearanceService = new TextAppearanceService(){

            @Override
            public boolean getWordWrapMode() {
                return ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).getWordWrapMode();
            }

            @Override
            public void setWordWrapMode(boolean mode) {
                ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).setWordWrapMode(mode);
            }
        };
        optionsModule.addOptionsPage((OptionsPage)new DefaultOptionsPage<TextEncodingOptionsImpl>(){
            private TextEncodingOptionsPanel panel;

            public TextEncodingOptionsPanel createPanel() {
                if (this.panel == null) {
                    this.panel = new TextEncodingOptionsPanel();
                    this.panel.setTextEncodingService(EditorTextModule.this.getEncodingsHandler().getTextEncodingService());
                    this.panel.setAddEncodingsOperation(usedEncodings -> {
                        ArrayList result = new ArrayList();
                        FrameModuleApi frameModule = (FrameModuleApi)EditorTextModule.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                        AddEncodingPanel addEncodingPanel = new AddEncodingPanel();
                        addEncodingPanel.setUsedEncodings(usedEncodings);
                        DefaultControlPanel controlPanel = new DefaultControlPanel(addEncodingPanel.getResourceBundle());
                        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)addEncodingPanel, (JPanel)controlPanel);
                        controlPanel.setHandler(actionType -> {
                            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                                result.addAll(addEncodingPanel.getEncodings());
                            }
                            dialog.close();
                            dialog.dispose();
                        });
                        frameModule.setDialogTitle(dialog, addEncodingPanel.getResourceBundle());
                        dialog.showCentered((Component)frameModule.getFrame());
                        return result;
                    });
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(TextEncodingOptionsPanel.class);
            }

            public TextEncodingOptionsImpl createOptions() {
                return new TextEncodingOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, TextEncodingOptionsImpl options) {
                options.loadFromPreferences(new TextEncodingPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, TextEncodingOptionsImpl options) {
                options.saveToPreferences(new TextEncodingPreferences(preferences));
            }

            public void applyPreferencesChanges(TextEncodingOptionsImpl options) {
                EditorTextModule.this.getEncodingsHandler();
                EditorTextModule.this.encodingsHandler.setSelectedEncoding(options.getSelectedEncoding());
                EditorTextModule.this.encodingsHandler.setEncodings(options.getEncodings());
            }
        });
        optionsModule.extendAppearanceOptionsPage((OptionsPage)new DefaultOptionsPage<TextAppearanceOptionsImpl>(){
            private TextAppearanceOptionsPanel panel;

            public OptionsComponent<TextAppearanceOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new TextAppearanceOptionsPanel();
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(TextAppearanceOptionsPanel.class);
            }

            public TextAppearanceOptionsImpl createOptions() {
                return new TextAppearanceOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, TextAppearanceOptionsImpl options) {
                options.loadFromPreferences(new TextAppearancePreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, TextAppearanceOptionsImpl options) {
                options.saveToPreferences(new TextAppearancePreferences(preferences));
            }

            public void applyPreferencesChanges(TextAppearanceOptionsImpl options) {
                textAppearanceService.setWordWrapMode(options.isWordWrapping());
            }
        });
    }

    public void registerWordWrapping() {
        this.getWordWrappingAction();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, (Action)this.getWordWrappingAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerGoToLine() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, (Action)this.getGoToLineAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public TextStatusPanel getTextStatusPanel() {
        return this.textStatusPanel;
    }

    @Nonnull
    private FindReplaceActions getFindReplaceActions() {
        if (this.findReplaceActions == null) {
            this.ensureSetup();
            this.findReplaceActions = new FindReplaceActions();
            this.findReplaceActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.findReplaceActions;
    }

    @Nonnull
    private TextFontAction getTextFontAction() {
        if (this.textFontAction == null) {
            this.ensureSetup();
            this.textFontAction = new TextFontAction();
            this.textFontAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.textFontAction;
    }

    @Nonnull
    private TextColorAction getTextColorAction() {
        if (this.textColorAction == null) {
            this.ensureSetup();
            this.textColorAction = new TextColorAction();
            this.textColorAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.textColorAction;
    }

    @Nonnull
    private EncodingsHandler getEncodingsHandler() {
        if (this.encodingsHandler == null) {
            this.encodingsHandler = new EncodingsHandler();
            this.encodingsHandler.setApplication(this.application);
            this.encodingsHandler.setEncodingChangeListener(new TextEncodingService.EncodingChangeListener(){

                @Override
                public void encodingListChanged() {
                    EditorTextModule.this.encodingsHandler.rebuildEncodings();
                }

                @Override
                public void selectedEncodingChanged() {
                    ((TextPanel)EditorTextModule.this.getEditorProvider().getEditorComponent()).setCharset(Charset.forName(EditorTextModule.this.encodingsHandler.getSelectedEncoding()));
                }
            });
            this.encodingsHandler.setParentComponent(this.getEditorProvider().getEditorComponent());
            if (this.textStatusPanel != null) {
                this.encodingsHandler.setTextEncodingStatus(this.textStatusPanel);
            }
            this.encodingsHandler.init();
        }
        return this.encodingsHandler;
    }

    @Nonnull
    private WordWrappingAction getWordWrappingAction() {
        if (this.wordWrappingAction == null) {
            this.ensureSetup();
            this.wordWrappingAction = new WordWrappingAction();
            this.wordWrappingAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.wordWrappingAction;
    }

    @Nonnull
    private GoToLineAction getGoToLineAction() {
        if (this.goToLineAction == null) {
            this.ensureSetup();
            this.goToLineAction = new GoToLineAction();
            this.goToLineAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.goToLineAction;
    }

    @Nonnull
    private PropertiesAction getPropertiesAction() {
        if (this.propertiesAction == null) {
            this.ensureSetup();
            this.propertiesAction = new PropertiesAction();
            this.propertiesAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.propertiesAction;
    }

    @Nonnull
    private PrintAction getPrintAction() {
        if (this.printAction == null) {
            this.ensureSetup();
            this.printAction = new PrintAction();
            this.printAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.printAction;
    }

    public void registerEditFindMenuActions() {
        this.getFindReplaceActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.EDIT_MENU_ID, new MenuGroup(EDIT_FIND_MENU_GROUP_ID, new MenuPosition(PositionMode.MIDDLE), SeparationMode.AROUND));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, this.findReplaceActions.getEditFindAction(), new MenuPosition(EDIT_FIND_MENU_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, this.findReplaceActions.getEditFindAgainAction(), new MenuPosition(EDIT_FIND_MENU_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, this.findReplaceActions.getEditReplaceAction(), new MenuPosition(EDIT_FIND_MENU_GROUP_ID));
    }

    public void registerEditFindToolBarActions() {
        this.getFindReplaceActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerToolBarGroup(FrameModuleApi.MAIN_TOOL_BAR_ID, new ToolBarGroup(EDIT_FIND_TOOL_BAR_GROUP_ID, new ToolBarPosition(PositionMode.MIDDLE), SeparationMode.AROUND));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.findReplaceActions.getEditFindAction(), new ToolBarPosition(EDIT_FIND_TOOL_BAR_GROUP_ID));
    }

    public void registerToolsOptionsMenuActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, (Action)this.getTextFontAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, (Action)this.getTextColorAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerPropertiesMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getPropertiesAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerPrintMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getPrintAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void loadFromPreferences(Preferences preferences) {
        this.encodingsHandler.loadFromPreferences(new TextEncodingPreferences(preferences));
    }

    @Nullable
    public static String getExtension(File file) {
        String ext = null;
        String str = file.getName();
        int i = str.lastIndexOf(46);
        if (i > 0 && i < str.length() - 1) {
            ext = str.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    @ParametersAreNonnullByDefault
    public class TXTFileType
    extends FileFilter
    implements FileType {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String extension = EditorTextModule.getExtension(file);
            if (extension != null) {
                return "txt".equals(extension);
            }
            return false;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "Text Files (*.txt)";
        }

        @Nonnull
        public String getFileTypeId() {
            return EditorTextModule.TXT_FILE_TYPE;
        }
    }

    @ParametersAreNonnullByDefault
    public class XBTFileType
    extends FileFilter
    implements FileType {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String extension = EditorTextModule.getExtension(file);
            if (extension != null) {
                if (extension.length() < 3) {
                    return false;
                }
                return "xbt".contains(extension.substring(0, 3));
            }
            return false;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "XBUP Text Files (*.xbt*)";
        }

        @Nonnull
        public String getFileTypeId() {
            return EditorTextModule.XBT_FILE_TYPE;
        }
    }
}

