/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRItem;
import org.exbin.xbup.client.catalog.remote.XBRXLanguage;
import org.exbin.xbup.client.catalog.remote.XBRXName;
import org.exbin.xbup.client.stub.XBPBaseProcedureType;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;

@ParametersAreNonnullByDefault
public class XBPXNameStub
extends XBPBaseStub<XBCXName> {
    public static long[] ITEM_NAME_PROCEDURE = new long[]{0L, 2L, 9L, 0L, 0L};
    public static long[] TEXT_NAME_PROCEDURE = new long[]{0L, 2L, 9L, 1L, 0L};
    public static long[] LANG_NAME_PROCEDURE = new long[]{0L, 2L, 9L, 2L, 0L};
    public static long[] ITEMNAME_NAME_PROCEDURE = new long[]{0L, 2L, 9L, 3L, 0L};
    public static long[] LANGNAME_NAME_PROCEDURE = new long[]{0L, 2L, 9L, 4L, 0L};
    public static long[] ITEMNAMES_NAME_PROCEDURE = new long[]{0L, 2L, 9L, 5L, 0L};
    public static long[] NAMESCOUNT_NAME_PROCEDURE = new long[]{0L, 2L, 9L, 6L, 0L};
    private final XBCatalogServiceClient client;

    public XBPXNameStub(XBCatalogServiceClient client) {
        super(client, XBRXName::new, new XBPBaseProcedureType(null, null, null, null, (XBBlockType)new XBDeclBlockType(NAMESCOUNT_NAME_PROCEDURE)));
        this.client = client;
    }

    public XBRItem getNameItem(long nameId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(ITEM_NAME_PROCEDURE), nameId);
        return index == null ? null : new XBRItem(this.client, index);
    }

    public String getText(long nameId) {
        return XBPStubUtils.longToStringMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(TEXT_NAME_PROCEDURE), nameId);
    }

    public XBRXLanguage getLang(long nameId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(LANG_NAME_PROCEDURE), nameId);
        return index == null ? null : new XBRXLanguage(this.client, index);
    }

    public XBRXName getDefaultItemName(XBCItem item) {
        if (item == null) {
            return null;
        }
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(ITEMNAME_NAME_PROCEDURE), item.getId());
        return index == null ? null : new XBRXName(this.client, index);
    }

    public XBRXName getItemName(XBCItem item, XBCXLanguage language) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(LANGNAME_NAME_PROCEDURE), item.getId(), language.getId());
        return index == null ? null : new XBRXName(this.client, index);
    }

    public List<XBCXName> getItemNames(XBCItem item) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(ITEMNAMES_NAME_PROCEDURE));
            serialInput.putAttribute(item.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCXName> result = new ArrayList<XBCXName>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRXName(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

