/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRXLanguage;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;

@ParametersAreNonnullByDefault
public class XBPXLangStub
extends XBPBaseStub<XBCXLanguage> {
    public static long[] CODE_LANG_PROCEDURE = new long[]{0L, 2L, 8L, 0L, 0L};
    public static long[] DEFAULT_LANG_PROCEDURE = new long[]{0L, 2L, 8L, 1L, 0L};
    public static long[] LANGS_LANG_PROCEDURE = new long[]{0L, 2L, 8L, 2L, 0L};
    public static long[] LANGSCOUNT_LANG_PROCEDURE = new long[]{0L, 2L, 8L, 3L, 0L};
    private final XBCatalogServiceClient client;

    public XBPXLangStub(XBCatalogServiceClient client) {
        super(client, XBRXLanguage::new, null);
        this.client = client;
    }

    public String getLangCode(long langId) {
        return XBPStubUtils.longToStringMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(CODE_LANG_PROCEDURE), langId);
    }

    public XBRXLanguage getDefaultLang() {
        Long index = XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(DEFAULT_LANG_PROCEDURE));
        return index == null ? null : new XBRXLanguage(this.client, index);
    }

    public List<XBCXLanguage> getLangs() {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(LANGS_LANG_PROCEDURE));
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCXLanguage> result = new ArrayList<XBCXLanguage>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRXLanguage(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

