/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog.remote.service;

import java.util.Scanner;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.catalog.remote.XBRXHDoc;
import org.exbin.xbup.client.catalog.remote.manager.XBRXHDocManager;
import org.exbin.xbup.client.catalog.remote.service.XBRDefaultService;
import org.exbin.xbup.core.catalog.base.XBCExtension;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.manager.XBCXHDocManager;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;

@ParametersAreNonnullByDefault
public class XBRXHDocService
extends XBRDefaultService<XBCXHDoc>
implements XBCXHDocService {
    public XBRXHDocService(XBRCatalog catalog) {
        super(catalog);
        this.itemManager = new XBRXHDocManager(catalog);
        catalog.addCatalogManager(XBCXHDocManager.class, (XBCXHDocManager)this.itemManager);
    }

    public XBRXHDoc findById(Long id) {
        return ((XBRXHDocManager)this.itemManager).findById(id);
    }

    public Long getAllHDocsCount() {
        return ((XBRXHDocManager)this.itemManager).getAllHDocsCount();
    }

    public XBRXHDoc getDocumentation(XBCItem item) {
        return ((XBRXHDocManager)this.itemManager).getDocumentation(item);
    }

    public String getExtensionName() {
        return ((XBCExtension)this.itemManager).getExtensionName();
    }

    public void initializeExtension() {
        ((XBCExtension)this.itemManager).initializeExtension();
    }

    public String getDocumentationText(XBCItem item) {
        XBRXHDoc hdoc = this.getDocumentation(item);
        if (hdoc == null) {
            return null;
        }
        XBCXFile file = hdoc.getDocFile();
        if (file == null) {
            return null;
        }
        XBCXFileService fileService = this.catalog.getCatalogService(XBCXFileService.class);
        return new Scanner(fileService.getFile(file)).useDelimiter("\\A").next();
    }

    public String getDocumentationBodyText(XBCItem item) {
        String text = this.getDocumentationText(item);
        if (text == null || text.isEmpty()) {
            return text;
        }
        int bodyPos = text.indexOf("<body");
        int startPos = text.indexOf(">", bodyPos + 5);
        int endPos = text.lastIndexOf("</body>");
        return text.substring(startPos + 1, endPos);
    }
}

