/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.preferences;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@ParametersAreNonnullByDefault
public class StreamPreferences
extends AbstractPreferences {
    public static final String PRECERENCES_DTD_URI = "http://java.sun.com/dtd/preferences.dtd";
    public static final String PREFERENCES_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for preferences --><!ELEMENT map (entry*) ><!ATTLIST map  MAP_XML_VERSION CDATA \"0.0\"  ><!ELEMENT entry EMPTY ><!ATTLIST entry          key CDATA #REQUIRED          value CDATA #REQUIRED >";
    private final InputStream stream;
    private final Map<String, String> spiValues = new TreeMap<String, String>();
    private Map<String, StreamPreferences> children = new TreeMap<String, StreamPreferences>();

    public StreamPreferences(InputStream stream) {
        super(null, "");
        this.stream = stream;
        this.init();
    }

    private void init() {
        try {
            this.sync();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(StreamPreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void putSpi(String key, String value) {
        this.spiValues.put(key, value);
        try {
            this.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(StreamPreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    @Nullable
    protected String getSpi(String key) {
        return this.spiValues.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.spiValues.remove(key);
        try {
            this.flush();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(StreamPreferences.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.removeNode();
        this.flush();
    }

    @Override
    @Nonnull
    protected String[] keysSpi() throws BackingStoreException {
        Set<String> keySet = this.spiValues.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    @Nonnull
    protected String[] childrenNamesSpi() throws BackingStoreException {
        Set<String> keySet = this.children.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    @Nonnull
    protected AbstractPreferences childSpi(String name) {
        throw StreamPreferences.throwCannotEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.isRemoved()) {
            this.clear();
            return;
        }
        InputStream inputStream = this.stream;
        synchronized (inputStream) {
            this.importFromStream(this.stream, this);
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromStream(InputStream fileStream, StreamPreferences p) {
        Object object = p.lock;
        synchronized (object) {
            try {
                Document doc = StreamPreferences.loadPrefsDoc(fileStream);
                StreamPreferences.importPrefs(p, doc.getDocumentElement());
            }
            catch (IOException | SAXException ex) {
                Logger.getLogger(StreamPreferences.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static void importPrefs(Preferences prefsNode, Element map) {
        NodeList entries = map.getChildNodes();
        int numEntries = entries.getLength();
        for (int i = 0; i < numEntries; ++i) {
            Element entry = (Element)entries.item(i);
            prefsNode.put(entry.getAttribute("key"), entry.getAttribute("value"));
        }
    }

    @Nonnull
    private static Document loadPrefsDoc(InputStream in) throws SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new Resolver());
            db.setErrorHandler(new RethrowErrorHandler());
            return db.parse(new InputSource(in));
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nonnull
    private static IllegalStateException throwCannotEdit() {
        return new IllegalStateException("Cannot edit stream preferences");
    }

    @ParametersAreNonnullByDefault
    private static class RethrowErrorHandler
    implements ErrorHandler {
        private RethrowErrorHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }

    @ParametersAreNonnullByDefault
    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        @Nonnull
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (systemId.equals(StreamPreferences.PRECERENCES_DTD_URI)) {
                InputSource is = new InputSource(new StringReader(StreamPreferences.PREFERENCES_DTD));
                is.setSystemId(StreamPreferences.PRECERENCES_DTD_URI);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + systemId);
        }
    }
}

