/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.preferences;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;

@ParametersAreNonnullByDefault
public class FrameworkPreferences {
    public static final String PREFERENCES_LOOK_AND_FEEL = "lookAndFeel";
    public static final String PREFERENCES_LOCALE_LANGUAGE = "locale.language";
    public static final String PREFERENCES_LOCALE_COUNTRY = "locale.country";
    public static final String PREFERENCES_LOCALE_VARIANT = "locale.variant";
    public static final String PREFERENCES_LOCALE_TAG = "locale.tag";
    public static final String PREFERENCES_RENDERING_MODE = "rendering.renderingMode";
    public static final String PREFERENCES_RENDERING_SCALING = "rendering.guiScaling";
    public static final String PREFERENCES_RENDERING_SCALING_RATE = "rendering.guiScalingRate";
    public static final String PREFERENCES_RENDERING_FONT_ANTIALIASING = "rendering.fontAntialising";
    public static final String PREFERENCES_RENDERING_USE_SCREEN_MENU_BAR = "rendering.useScreenMenuBar";
    public static final String PREFERENCES_RENDERING_MACOS_APPEARANCE = "rendering.macOsAppearance";
    private final Preferences preferences;

    public FrameworkPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public String getLocaleLanguage() {
        return this.preferences.get(PREFERENCES_LOCALE_LANGUAGE, "");
    }

    @Nonnull
    public String getLocaleCountry() {
        return this.preferences.get(PREFERENCES_LOCALE_COUNTRY, "");
    }

    @Nonnull
    public String getLocaleVariant() {
        return this.preferences.get(PREFERENCES_LOCALE_VARIANT, "");
    }

    @Nonnull
    public String getLocaleTag() {
        return this.preferences.get(PREFERENCES_LOCALE_TAG, "");
    }

    @Nonnull
    public Locale getLocale() {
        String localeTag = this.getLocaleTag();
        if (!localeTag.trim().isEmpty()) {
            try {
                return Locale.forLanguageTag(localeTag);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        String localeLanguage = this.getLocaleLanguage();
        String localeCountry = this.getLocaleCountry();
        String localeVariant = this.getLocaleVariant();
        try {
            return new Locale(localeLanguage, localeCountry, localeVariant);
        }
        catch (SecurityException securityException) {
            return Locale.ROOT;
        }
    }

    public void setLocaleLanguage(String language) {
        this.preferences.put(PREFERENCES_LOCALE_LANGUAGE, language);
    }

    public void setLocaleCountry(String country) {
        this.preferences.put(PREFERENCES_LOCALE_COUNTRY, country);
    }

    public void setLocaleVariant(String variant) {
        this.preferences.put(PREFERENCES_LOCALE_VARIANT, variant);
    }

    public void setLocaleTag(String variant) {
        this.preferences.put(PREFERENCES_LOCALE_TAG, variant);
    }

    public void setLocale(Locale locale) {
        this.setLocaleTag(locale.toLanguageTag());
        this.setLocaleLanguage(locale.getLanguage());
        this.setLocaleCountry(locale.getCountry());
        this.setLocaleVariant(locale.getVariant());
    }

    @Nonnull
    public String getLookAndFeel() {
        return this.preferences.get(PREFERENCES_LOOK_AND_FEEL, "");
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.preferences.put(PREFERENCES_LOOK_AND_FEEL, lookAndFeel);
    }

    @Nonnull
    public String getRenderingMode() {
        return this.preferences.get(PREFERENCES_RENDERING_MODE, "");
    }

    public void setRenderingMode(String renderingMode) {
        this.preferences.put(PREFERENCES_RENDERING_MODE, renderingMode);
    }

    @Nonnull
    public String getGuiScaling() {
        return this.preferences.get(PREFERENCES_RENDERING_SCALING, "");
    }

    public void setGuiScaling(String guiScaling) {
        this.preferences.put(PREFERENCES_RENDERING_SCALING, guiScaling);
    }

    public float getGuiScalingRate() {
        return this.preferences.getFloat(PREFERENCES_RENDERING_SCALING_RATE, 1.0f);
    }

    public void setGuiScalingRate(float guiScalingRate) {
        this.preferences.putFloat(PREFERENCES_RENDERING_SCALING_RATE, guiScalingRate);
    }

    @Nonnull
    public String getFontAntialiasing() {
        return this.preferences.get(PREFERENCES_RENDERING_FONT_ANTIALIASING, "");
    }

    public void setFontAntialiasing(String fontAntialiasing) {
        this.preferences.put(PREFERENCES_RENDERING_FONT_ANTIALIASING, fontAntialiasing);
    }

    public boolean isUseScreenMenuBar() {
        return this.preferences.getBoolean(PREFERENCES_RENDERING_USE_SCREEN_MENU_BAR, true);
    }

    public void setUseScreenMenuBar(boolean use) {
        this.preferences.putBoolean(PREFERENCES_RENDERING_USE_SCREEN_MENU_BAR, use);
    }

    @Nonnull
    public String getMacOsAppearance() {
        return this.preferences.get(PREFERENCES_RENDERING_MACOS_APPEARANCE, "");
    }

    public void setMacOsAppearance(String appearance) {
        this.preferences.put(PREFERENCES_RENDERING_MACOS_APPEARANCE, appearance);
    }
}

