/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.service.XBEXDescService;
import org.exbin.xbup.catalog.entity.service.XBEXFileService;
import org.exbin.xbup.catalog.entity.service.XBEXHDocService;
import org.exbin.xbup.catalog.entity.service.XBEXIconService;
import org.exbin.xbup.catalog.entity.service.XBEXLangService;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.catalog.entity.service.XBEXPlugService;
import org.exbin.xbup.catalog.entity.service.XBEXStriService;
import org.exbin.xbup.catalog.entity.service.XBEXUiService;
import org.exbin.xbup.catalog.update.XBCatalogServiceUpdateHandler;
import org.exbin.xbup.client.XBCatalogNetServiceClient;
import org.exbin.xbup.core.block.declaration.XBContext;
import org.exbin.xbup.core.block.declaration.XBDeclaration;
import org.exbin.xbup.core.block.declaration.XBGroupDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCFormatDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.service.XBCService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.catalog.base.service.XBCXLangService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXPlugService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.service.XBCatalogNetServiceServer;
import org.exbin.xbup.service.XBService;
import org.exbin.xbup.service.XBTCPServiceServer;

@ParametersAreNonnullByDefault
public class XBServiceInstance {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org/exbin/xbup/service/XBService");
    private boolean shallUpdate;
    private boolean verboseMode;
    private boolean rootCatalogMode;
    private boolean devMode;
    private boolean forceUpdate;
    private boolean derbyMode = false;
    private boolean debugMode = false;
    private String tcpipPort;
    private String tcpipInterface;
    private String derbyPath;
    private XBCatalogNetServiceServer serviceServer = null;
    private EntityManager entityManager = null;
    private XBAECatalog catalog = null;

    public void run() {
        int tcpipPortInt;
        Logger.getLogger(XBService.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, this.resourceBundle.getString("service_head"));
        Logger.getLogger(XBService.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "");
        try {
            tcpipPortInt = Integer.parseInt(this.tcpipPort);
        }
        catch (NumberFormatException e) {
            tcpipPortInt = 22594;
            Logger.getLogger(XBServiceInstance.class.getName()).log(Level.SEVERE, "{0}{1}: {2}", new Object[]{this.resourceBundle.getString("error_warning"), this.resourceBundle.getString("error_tcpip_port"), this.tcpipPort});
        }
        Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "{0} {1}:{2}...", new Object[]{this.resourceBundle.getString("init_service"), this.tcpipInterface, Integer.toString(tcpipPortInt)});
        this.serviceServer = new XBCatalogNetServiceServer();
        this.serviceServer.setCatalogProvider(new XBTCPServiceServer.CatalogProvider(){

            public XBACatalog createCatalog() {
                if (XBServiceInstance.this.catalog == null) {
                    XBServiceInstance.this.initCatalog();
                    XBServiceInstance.this.performUpdate();
                } else {
                    XBServiceInstance.this.createCatalog();
                }
                return XBServiceInstance.this.catalog;
            }
        });
        this.serviceServer.setDebugMode(this.debugMode);
        try {
            this.serviceServer.open(tcpipPortInt);
            this.serviceServer.run();
            Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "{0}.", this.resourceBundle.getString("stop_service_success"));
        }
        catch (IOException e) {
            Logger.getLogger(XBServiceInstance.class.getName()).log(Level.WARNING, "{0}: {1}", new Object[]{this.resourceBundle.getString("init_service_failed"), e});
        }
    }

    private void initCatalog() {
        Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "{0}...", this.resourceBundle.getString("init_catalog"));
        try {
            this.derbyMode = false;
            String derbyHome = System.getProperty("user.home") + "/.java/.userPrefs/" + this.derbyPath;
            if (this.devMode) {
                derbyHome = derbyHome + "-dev";
            }
            System.setProperty("derby.system.home", derbyHome);
            try {
                this.createCatalog();
            }
            catch (PersistenceException | DatabaseException e) {
                this.derbyMode = true;
                this.createCatalog();
            }
            if (this.catalog.isShallInit()) {
                this.catalog.initCatalog();
            }
        }
        catch (DatabaseException e) {
            System.err.println(this.resourceBundle.getString("init_catalog_failed") + ": " + (Object)((Object)e));
        }
    }

    private void createCatalog() {
        EntityManagerFactory emf;
        if (this.derbyMode) {
            String persistenceUnitName = "XBServiceDerbyPU";
            emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
            this.entityManager = emf.createEntityManager();
            this.catalog = this.createCatalog(this.entityManager);
        } else {
            String persistenceUnitName = this.rootCatalogMode ? (this.devMode ? "XBServiceMySQLDevPU" : "XBServiceMySQLPU") : "XBServicePU";
            emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
            this.entityManager = emf.createEntityManager();
            this.catalog = this.createCatalog(this.entityManager);
        }
        Long[] serviceFormatPath = new Long[]{0L, 2L, 0L};
        XBCFormatDecl serviceFormatDecl = (XBCFormatDecl)this.catalog.findFormatTypeByPath(serviceFormatPath, 0);
        XBContext serviceContext = new XBContext();
        serviceFormatDecl.getGroupDecls().forEach(groupDeclservice -> serviceContext.getGroups().add(XBDeclaration.convertCatalogGroup((XBGroupDecl)groupDeclservice, (XBCatalog)this.catalog)));
        this.catalog.setRootContext(serviceContext);
    }

    private void performUpdate() {
        this.shallUpdate = (this.serviceServer.shallUpdate((XBACatalog)this.catalog) || this.forceUpdate) && !this.rootCatalogMode;
        try {
            Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "");
            Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, this.resourceBundle.getString("init_service_success"));
            Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "");
            if (this.shallUpdate) {
                Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, this.resourceBundle.getString("init_update"));
                Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "");
                if (this.catalog.isShallInit()) {
                    this.catalog.initCatalog();
                }
                if (this.serviceServer.shallUpdate((XBACatalog)this.catalog)) {
                    EntityManagerFactory emfDrop = Persistence.createEntityManagerFactory((String)(this.derbyMode ? "XBServiceDerbyPU-drop" : "XBServicePU-drop"));
                    EntityManager emDrop = emfDrop.createEntityManager();
                    emDrop.setFlushMode(FlushModeType.AUTO);
                    this.catalog = this.createCatalog(emDrop);
                    this.catalog.initCatalog();
                    int defaultPort = this.devMode ? 22595 : 22594;
                    String mainCatalogHost = this.devMode ? "catalog-dev.exbin.org" : "catalog.exbin.org";
                    XBCatalogNetServiceClient mainClient = new XBCatalogNetServiceClient(mainCatalogHost, defaultPort);
                    XBCatalogServiceUpdateHandler updateHandler = new XBCatalogServiceUpdateHandler(this.catalog, mainClient);
                    updateHandler.init();
                    updateHandler.fireUsageEvent(false);
                    updateHandler.performUpdateMain();
                }
                Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "");
                Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, this.resourceBundle.getString("done_update"));
                Logger.getLogger(XBServiceInstance.class.getName()).log(XBCatalogNetServiceServer.XB_SERVICE_STATUS, "");
            }
        }
        catch (XBProcessingException ex) {
            Logger.getLogger(XBServiceInstance.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private XBAECatalog createCatalog(EntityManager em) {
        XBAECatalog createdCatalog = new XBAECatalog(em);
        createdCatalog.addCatalogService(XBCXLangService.class, (XBCService)new XBEXLangService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXStriService.class, (XBCService)new XBEXStriService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXNameService.class, (XBCService)new XBEXNameService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXDescService.class, (XBCService)new XBEXDescService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXFileService.class, (XBCService)new XBEXFileService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXIconService.class, (XBCService)new XBEXIconService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXPlugService.class, (XBCService)new XBEXPlugService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXUiService.class, (XBCService)new XBEXUiService((XBECatalog)createdCatalog));
        createdCatalog.addCatalogService(XBCXHDocService.class, (XBCService)new XBEXHDocService((XBECatalog)createdCatalog));
        return createdCatalog;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public boolean isShallUpdate() {
        return this.shallUpdate;
    }

    public void setShallUpdate(boolean shallUpdate) {
        this.shallUpdate = shallUpdate;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean verboseMode) {
        this.verboseMode = verboseMode;
    }

    public boolean isRootCatalogMode() {
        return this.rootCatalogMode;
    }

    public void setRootCatalogMode(boolean rootCatalogMode) {
        this.rootCatalogMode = rootCatalogMode;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public boolean isDerbyMode() {
        return this.derbyMode;
    }

    public void setDerbyMode(boolean derbyMode) {
        this.derbyMode = derbyMode;
    }

    public String getTcpipPort() {
        return this.tcpipPort;
    }

    public void setTcpipPort(String tcpipPort) {
        this.tcpipPort = tcpipPort;
    }

    public String getTcpipInterface() {
        return this.tcpipInterface;
    }

    public void setTcpipInterface(String tcpipInterface) {
        this.tcpipInterface = tcpipInterface;
    }

    public String getDerbyPath() {
        return this.derbyPath;
    }

    public void setDerbyPath(String derbyPath) {
        this.derbyPath = derbyPath;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

