/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.wave.options.gui.WaveColorPanel;
import org.exbin.framework.editor.wave.options.impl.WaveColorOptionsImpl;
import org.exbin.framework.editor.wave.service.WaveColorService;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class WaveColorOptionsPanel
extends JPanel
implements OptionsComponent<WaveColorOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(WaveColorOptionsPanel.class);
    private WaveColorService waveColorService;
    private final WaveColorPanel colorPanel;
    private JColorChooser colorChooser;
    private JPanel customColorsPanel;
    private JCheckBox defaultColorCheckBox;

    public WaveColorOptionsPanel() {
        this.initComponents();
        this.colorPanel = new WaveColorPanel();
        this.colorPanel.setEnabled(false);
        this.customColorsPanel.add((Component)this.colorPanel, "Center");
    }

    public void setWaveColorService(WaveColorService waveColorService) {
        this.waveColorService = waveColorService;
        this.colorPanel.setWaveColorService(waveColorService);
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(WaveColorOptionsImpl options) {
        boolean useDefaultColors = options.isUseDefaultColors();
        this.defaultColorCheckBox.setSelected(useDefaultColors);
        this.colorPanel.setEnabled(!useDefaultColors);
        this.colorPanel.loadFromOptions(options);
    }

    public void saveToOptions(WaveColorOptionsImpl options) {
        options.setUseDefaultColors(this.defaultColorCheckBox.isSelected());
        this.colorPanel.saveToOptions(options);
    }

    private void initComponents() {
        this.colorChooser = new JColorChooser();
        this.customColorsPanel = new JPanel();
        this.defaultColorCheckBox = new JCheckBox();
        this.colorChooser.setName("colorChooser");
        this.setName("Form");
        this.customColorsPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("customColorsPanel.border.title")));
        this.customColorsPanel.setName("customColorsPanel");
        this.customColorsPanel.setLayout(new BorderLayout());
        this.defaultColorCheckBox.setSelected(true);
        this.defaultColorCheckBox.setText(this.resourceBundle.getString("defaultColorCheckBox.text"));
        this.defaultColorCheckBox.setName("defaultColorCheckBox");
        this.defaultColorCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WaveColorOptionsPanel.this.defaultColorCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.customColorsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.defaultColorCheckBox, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.defaultColorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customColorsPanel, -1, 31, Short.MAX_VALUE).addContainerGap()));
    }

    private void defaultColorCheckBoxItemStateChanged(ItemEvent evt) {
        boolean checked = evt.getStateChange() != 1;
        this.colorPanel.setEnabled(checked);
        this.setModified();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new WaveColorOptionsPanel());
    }

    private void setModified() {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
        this.colorPanel.setOptionsModifiedListener(listener);
    }
}

