/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.filechooser.FileFilter;
import org.exbin.framework.file.api.FileType;

@ParametersAreNonnullByDefault
public class AudioFileType
extends FileFilter
implements FileType {
    private String ext;

    public AudioFileType(String ext) {
        this.ext = ext;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = AudioFileType.getExtension(file);
        if (extension != null) {
            return extension.toLowerCase().equals(this.getExt());
        }
        return false;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Audio files " + this.getExt().toUpperCase() + " (*." + this.getExt() + ")";
    }

    @Nullable
    public static String getExtension(File file) {
        String ext = null;
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    @Nullable
    public String getExt() {
        return this.ext;
    }

    public void setExt(@Nullable String ext) {
        this.ext = ext;
    }

    @Nonnull
    public String getFileTypeId() {
        return "XBWaveEditor.AudioFileFilter" + this.ext;
    }
}

