/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.framework.bined.gui.BaseSwitchableSpinnerPanel;
import org.exbin.framework.bined.gui.RelativePositionMode;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class GoToPositionPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(GoToPositionPanel.class);
    private long cursorPosition;
    private long maxPosition;
    private RelativePositionMode goToMode = RelativePositionMode.FROM_START;
    private JLabel currentPositionLabel;
    private JTextField currentPositionTextField;
    private JRadioButton fromCursorRadioButton;
    private JRadioButton fromEndRadioButton;
    private JRadioButton fromStartRadioButton;
    private JPanel goToPanel;
    private BaseSwitchableSpinnerPanel positionBaseSwitchableSpinnerPanel;
    private JLabel positionLabel;
    private ButtonGroup positionTypeButtonGroup;
    private JLabel targetPositionLabel;
    private JTextField targetPositionTextField;

    public GoToPositionPanel() {
        this.initComponents();
        this.positionBaseSwitchableSpinnerPanel.setMinimum(0L);
        this.positionBaseSwitchableSpinnerPanel.addChangeListener(evt -> this.updateTargetPosition());
    }

    private void initComponents() {
        this.positionTypeButtonGroup = new ButtonGroup();
        this.currentPositionLabel = new JLabel();
        this.currentPositionTextField = new JTextField();
        this.goToPanel = new JPanel();
        this.fromStartRadioButton = new JRadioButton();
        this.fromEndRadioButton = new JRadioButton();
        this.fromCursorRadioButton = new JRadioButton();
        this.positionLabel = new JLabel();
        this.positionBaseSwitchableSpinnerPanel = new BaseSwitchableSpinnerPanel();
        this.targetPositionLabel = new JLabel();
        this.targetPositionTextField = new JTextField();
        this.currentPositionLabel.setText(this.resourceBundle.getString("currentPositionLabel.text"));
        this.currentPositionTextField.setEditable(false);
        this.currentPositionTextField.setText("0");
        this.goToPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("goToPanel.border.title")));
        this.positionTypeButtonGroup.add(this.fromStartRadioButton);
        this.fromStartRadioButton.setSelected(true);
        this.fromStartRadioButton.setText(this.resourceBundle.getString("fromStartRadioButton.text"));
        this.fromStartRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GoToPositionPanel.this.fromStartRadioButtonItemStateChanged(evt);
            }
        });
        this.positionTypeButtonGroup.add(this.fromEndRadioButton);
        this.fromEndRadioButton.setText(this.resourceBundle.getString("fromEndRadioButton.text"));
        this.fromEndRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GoToPositionPanel.this.fromEndRadioButtonItemStateChanged(evt);
            }
        });
        this.positionTypeButtonGroup.add(this.fromCursorRadioButton);
        this.fromCursorRadioButton.setText(this.resourceBundle.getString("fromCursorRadioButton.text"));
        this.fromCursorRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GoToPositionPanel.this.fromCursorRadioButtonItemStateChanged(evt);
            }
        });
        this.positionLabel.setText(this.resourceBundle.getString("positionLabel.text"));
        GroupLayout goToPanelLayout = new GroupLayout(this.goToPanel);
        this.goToPanel.setLayout(goToPanelLayout);
        goToPanelLayout.setHorizontalGroup(goToPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, goToPanelLayout.createSequentialGroup().addContainerGap().addGroup(goToPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fromCursorRadioButton, -1, -1, Short.MAX_VALUE).addComponent(this.fromEndRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.fromStartRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.positionBaseSwitchableSpinnerPanel, GroupLayout.Alignment.LEADING, -1, 400, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, goToPanelLayout.createSequentialGroup().addComponent(this.positionLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        goToPanelLayout.setVerticalGroup(goToPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(goToPanelLayout.createSequentialGroup().addComponent(this.fromStartRadioButton, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromEndRadioButton, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromCursorRadioButton, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.positionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.positionBaseSwitchableSpinnerPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.targetPositionLabel.setText(this.resourceBundle.getString("targetPositionLabel.text"));
        this.targetPositionTextField.setEditable(false);
        this.targetPositionTextField.setText("0");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.currentPositionTextField).addComponent(this.goToPanel, -1, -1, Short.MAX_VALUE).addComponent(this.targetPositionTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.currentPositionLabel).addComponent(this.targetPositionLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.currentPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentPositionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.goToPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetPositionTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void fromStartRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.fromStartRadioButton.isSelected()) {
            this.switchGoToMode(RelativePositionMode.FROM_START);
        }
    }

    private void fromEndRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.fromEndRadioButton.isSelected()) {
            this.switchGoToMode(RelativePositionMode.FROM_END);
        }
    }

    private void fromCursorRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.fromCursorRadioButton.isSelected()) {
            this.switchGoToMode(RelativePositionMode.FROM_CURSOR);
        }
    }

    private void updateTargetPosition() {
        this.targetPositionTextField.setText(String.valueOf(this.getTargetPosition()));
    }

    public void initFocus() {
        this.positionBaseSwitchableSpinnerPanel.initFocus();
    }

    public long getTargetPosition() {
        long absolutePosition;
        long position = this.getPositionValue();
        switch (this.goToMode) {
            case FROM_START: {
                absolutePosition = position;
                break;
            }
            case FROM_END: {
                absolutePosition = this.maxPosition - position;
                break;
            }
            case FROM_CURSOR: {
                absolutePosition = this.cursorPosition + position;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.goToMode);
            }
        }
        if (absolutePosition < 0L) {
            absolutePosition = 0L;
        } else if (absolutePosition > this.maxPosition) {
            absolutePosition = this.maxPosition;
        }
        return absolutePosition;
    }

    public void setTargetPosition(long absolutePosition) {
        if (absolutePosition < 0L) {
            absolutePosition = 0L;
        } else if (absolutePosition > this.maxPosition) {
            absolutePosition = this.maxPosition;
        }
        switch (this.goToMode) {
            case FROM_START: {
                this.setPositionValue(absolutePosition);
                break;
            }
            case FROM_END: {
                this.setPositionValue(this.maxPosition - absolutePosition);
                break;
            }
            case FROM_CURSOR: {
                this.setPositionValue(absolutePosition - this.cursorPosition);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.goToMode);
            }
        }
        this.updateTargetPosition();
    }

    public long getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(long cursorPosition) {
        this.cursorPosition = cursorPosition;
        this.setPositionValue(cursorPosition);
        this.currentPositionTextField.setText(String.valueOf(cursorPosition));
    }

    public void setMaxPosition(long maxPosition) {
        this.maxPosition = maxPosition;
        this.positionBaseSwitchableSpinnerPanel.setMaximum(maxPosition);
        this.updateTargetPosition();
    }

    public void setSelected() {
        this.positionBaseSwitchableSpinnerPanel.requestFocusInWindow();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void switchGoToMode(RelativePositionMode goToMode) {
        if (this.goToMode == goToMode) {
            return;
        }
        long absolutePosition = this.getTargetPosition();
        this.goToMode = goToMode;
        switch (goToMode) {
            case FROM_START: 
            case FROM_END: {
                this.setPositionValue(0L);
                this.positionBaseSwitchableSpinnerPanel.setMinimum(0L);
                this.positionBaseSwitchableSpinnerPanel.setMaximum(this.maxPosition);
                this.positionBaseSwitchableSpinnerPanel.revalidateSpinner();
                break;
            }
            case FROM_CURSOR: {
                this.setPositionValue(0L);
                this.positionBaseSwitchableSpinnerPanel.setMinimum(-this.cursorPosition);
                this.positionBaseSwitchableSpinnerPanel.setMaximum(this.maxPosition - this.cursorPosition);
                this.positionBaseSwitchableSpinnerPanel.revalidateSpinner();
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)goToMode);
            }
        }
        this.setTargetPosition(absolutePosition);
    }

    private long getPositionValue() {
        return this.positionBaseSwitchableSpinnerPanel.getValue();
    }

    private void setPositionValue(long value) {
        this.positionBaseSwitchableSpinnerPanel.setValue(value);
        this.updateTargetPosition();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new GoToPositionPanel());
    }

    public void acceptInput() {
        this.positionBaseSwitchableSpinnerPanel.acceptInput();
    }
}

