/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.PositionCodeType;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BaseSwitchableSpinnerPanel
extends JPanel {
    private boolean adjusting;
    private final PositionSpinnerEditor spinnerEditor;
    private static final String SPINNER_PROPERTY = "value";
    private JButton baseSwitchButton;
    private JPopupMenu baseSwitchPopupMenu;
    private JMenuItem decimalMenuItem;
    private JMenuItem hexadecimalMenuItem;
    private JMenuItem octalMenuItem;
    private JSpinner spinner;

    public BaseSwitchableSpinnerPanel() {
        this.initComponents();
        this.spinnerEditor = new PositionSpinnerEditor(this.spinner);
        this.spinner.setEditor(this.spinnerEditor);
        this.init();
    }

    private void init() {
        this.spinnerEditor.getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof JTextComponent) {
                    JTextComponent textComponent = (JTextComponent)e.getSource();
                    SwingUtilities.invokeLater(textComponent::selectAll);
                }
            }
        });
        Dimension preferredSize = this.baseSwitchButton.getPreferredSize();
        this.setPreferredSize(new Dimension(preferredSize.width * 4, preferredSize.height));
    }

    private void initComponents() {
        this.baseSwitchPopupMenu = new JPopupMenu();
        this.octalMenuItem = new JMenuItem();
        this.decimalMenuItem = new JMenuItem();
        this.hexadecimalMenuItem = new JMenuItem();
        this.baseSwitchButton = new JButton();
        this.spinner = new JSpinner();
        this.octalMenuItem.setText("OCT - Octal");
        this.octalMenuItem.setToolTipText("Swith to octal numerical base");
        this.octalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseSwitchableSpinnerPanel.this.octalMenuItemActionPerformed(evt);
            }
        });
        this.baseSwitchPopupMenu.add(this.octalMenuItem);
        this.decimalMenuItem.setText("DEC - Decimal");
        this.decimalMenuItem.setToolTipText("Switch to decimal numerical base");
        this.decimalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseSwitchableSpinnerPanel.this.decimalMenuItemActionPerformed(evt);
            }
        });
        this.baseSwitchPopupMenu.add(this.decimalMenuItem);
        this.hexadecimalMenuItem.setText("HEX - Hexadecimal");
        this.hexadecimalMenuItem.setToolTipText("Switch to hexadecimal numerical base");
        this.hexadecimalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseSwitchableSpinnerPanel.this.hexadecimalMenuItemActionPerformed(evt);
            }
        });
        this.baseSwitchPopupMenu.add(this.hexadecimalMenuItem);
        this.setPreferredSize(new Dimension(400, 300));
        this.baseSwitchButton.setText("DEC");
        this.baseSwitchButton.setToolTipText("Decimal");
        this.baseSwitchButton.setComponentPopupMenu(this.baseSwitchPopupMenu);
        this.baseSwitchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseSwitchableSpinnerPanel.this.baseSwitchButtonActionPerformed(evt);
            }
        });
        this.spinner.setModel(new SpinnerNumberModel((Number)0L, null, null, (Number)1L));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.baseSwitchButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinner)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinner).addComponent(this.baseSwitchButton, -1, -1, Short.MAX_VALUE));
    }

    private void baseSwitchButtonActionPerformed(ActionEvent evt) {
        PositionCodeType positionCodeType = this.spinnerEditor.getPositionCodeType();
        switch (positionCodeType) {
            case OCTAL: {
                this.switchNumBase(PositionCodeType.DECIMAL);
                break;
            }
            case DECIMAL: {
                this.switchNumBase(PositionCodeType.HEXADECIMAL);
                break;
            }
            case HEXADECIMAL: {
                this.switchNumBase(PositionCodeType.OCTAL);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)positionCodeType);
            }
        }
    }

    private void octalMenuItemActionPerformed(ActionEvent evt) {
        this.switchNumBase(PositionCodeType.OCTAL);
    }

    private void decimalMenuItemActionPerformed(ActionEvent evt) {
        this.switchNumBase(PositionCodeType.DECIMAL);
    }

    private void hexadecimalMenuItemActionPerformed(ActionEvent evt) {
        this.switchNumBase(PositionCodeType.HEXADECIMAL);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BaseSwitchableSpinnerPanel());
    }

    private void switchNumBase(PositionCodeType codeType) {
        this.adjusting = true;
        long value = this.getValue();
        int position = codeType.ordinal();
        this.baseSwitchButton.setText(codeType.name().substring(0, 3));
        this.baseSwitchButton.setToolTipText(((JMenuItem)this.baseSwitchPopupMenu.getComponent(position)).getToolTipText());
        this.spinnerEditor.setPositionCodeType(codeType);
        this.setValue(value);
        this.adjusting = false;
    }

    public long getValue() {
        return (Long)this.spinner.getValue();
    }

    public void setValue(long value) {
        this.spinnerEditor.setPositionValue(value);
    }

    public void acceptInput() {
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void initFocus() {
        this.spinnerEditor.getTextField().requestFocusInWindow();
    }

    public void setMinimum(long minimum) {
        ((SpinnerNumberModel)this.spinner.getModel()).setMinimum(Long.valueOf(minimum));
    }

    public void setMaximum(long maximum) {
        ((SpinnerNumberModel)this.spinner.getModel()).setMaximum(Long.valueOf(maximum));
    }

    public void revalidateSpinner() {
        this.spinner.revalidate();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.spinner.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.spinner.removeChangeListener(changeListener);
    }

    @ParametersAreNonnullByDefault
    private class PositionSpinnerEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        private static final int LENGTH_LIMIT = 21;
        private PositionCodeType positionCodeType = PositionCodeType.DECIMAL;
        private final char[] cache = new char[21];
        private final JTextField textField;
        private final JSpinner spinner;

        public PositionSpinnerEditor(JSpinner spinner) {
            this.spinner = spinner;
            this.textField = new JTextField();
            this.init();
        }

        private void init() {
            this.textField.setName("Spinner.textField");
            this.textField.setText(this.getPositionAsString((Long)this.spinner.getValue()));
            this.textField.addPropertyChangeListener(this);
            this.textField.getDocument().addDocumentListener(new DocumentListener(){
                private final PropertyChangeEvent changeEvent;
                {
                    this.changeEvent = new PropertyChangeEvent(PositionSpinnerEditor.this.textField, BaseSwitchableSpinnerPanel.SPINNER_PROPERTY, null, null);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.notifyChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.notifyChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.notifyChanged();
                }

                public void notifyChanged() {
                    PositionSpinnerEditor.this.propertyChange(this.changeEvent);
                }
            });
            this.textField.setEditable(true);
            this.textField.setInheritsPopupMenu(true);
            String toolTipText = this.spinner.getToolTipText();
            if (toolTipText != null) {
                this.textField.setToolTipText(toolTipText);
            }
            this.add(this.textField);
            this.setLayout(this);
            this.spinner.addChangeListener(this);
        }

        @Nonnull
        private JTextField getTextField() {
            return this.textField;
        }

        @Nonnull
        private JSpinner getSpinner() {
            return this.spinner;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (BaseSwitchableSpinnerPanel.this.adjusting) {
                return;
            }
            JSpinner sourceSpinner = (JSpinner)e.getSource();
            SwingUtilities.invokeLater(() -> this.textField.setText(this.getPositionAsString((Long)sourceSpinner.getValue())));
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (BaseSwitchableSpinnerPanel.this.adjusting) {
                return;
            }
            JSpinner sourceSpinner = this.getSpinner();
            Object source = e.getSource();
            String name = e.getPropertyName();
            if (source instanceof JTextField && BaseSwitchableSpinnerPanel.SPINNER_PROPERTY.equals(name)) {
                Long lastValue = (Long)sourceSpinner.getValue();
                try {
                    sourceSpinner.setValue(this.valueOfPosition(this.getTextField().getText()));
                }
                catch (IllegalArgumentException iae) {
                    try {
                        sourceSpinner.setValue(lastValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }

        public void setPositionValue(long positionValue) {
            this.textField.setText(this.getPositionAsString(positionValue));
            this.spinner.setValue(positionValue);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Nonnull
        private Dimension insetSize(Container parent) {
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        @Override
        @Nonnull
        public Dimension preferredLayoutSize(Container parent) {
            Dimension preferredSize = this.insetSize(parent);
            if (parent.getComponentCount() > 0) {
                Dimension childSize = this.getComponent(0).getPreferredSize();
                preferredSize.width += childSize.width;
                preferredSize.height += childSize.height;
            }
            return preferredSize;
        }

        @Override
        @Nonnull
        public Dimension minimumLayoutSize(Container parent) {
            Dimension minimumSize = this.insetSize(parent);
            if (parent.getComponentCount() > 0) {
                Dimension childSize = this.getComponent(0).getMinimumSize();
                minimumSize.width += childSize.width;
                minimumSize.height += childSize.height;
            }
            return minimumSize;
        }

        @Override
        public void layoutContainer(Container parent) {
            if (parent.getComponentCount() > 0) {
                Insets insets = parent.getInsets();
                int width = parent.getWidth() - (insets.left + insets.right);
                int height = parent.getHeight() - (insets.top + insets.bottom);
                this.getComponent(0).setBounds(insets.left, insets.top, width, height);
            }
        }

        @Nonnull
        public PositionCodeType getPositionCodeType() {
            return this.positionCodeType;
        }

        public void setPositionCodeType(PositionCodeType positionCodeType) {
            this.positionCodeType = positionCodeType;
        }

        @Nonnull
        private String getPositionAsString(long position) {
            if (position < 0L) {
                return "-" + this.getNonNegativePositionAsString(-position);
            }
            return this.getNonNegativePositionAsString(position);
        }

        @Nonnull
        private String getNonNegativePositionAsString(long position) {
            Arrays.fill(this.cache, ' ');
            CodeAreaUtils.longToBaseCode((char[])this.cache, (int)0, (long)position, (int)this.positionCodeType.getBase(), (int)21, (boolean)false, (CodeCharactersCase)CodeCharactersCase.LOWER);
            return new String(this.cache).trim();
        }

        private long valueOfPosition(String position) {
            return Long.parseLong(position, this.positionCodeType.getBase());
        }
    }
}

