/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.capability.ViewModeCapable;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.action.CodeAreaAction;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class ViewModeHandlerActions
implements CodeAreaAction {
    public static final String DUAL_VIEW_MODE_ACTION_ID = "dualViewModeAction";
    public static final String CODE_MATRIX_VIEW_MODE_ACTION_ID = "codeMatrixViewModeAction";
    public static final String TEXT_PREVIEW_VIEW_MODE_ACTION_ID = "textPreviewViewModeAction";
    public static final String VIEW_MODE_RADIO_GROUP_ID = "viewModeRadioGroup";
    private CodeAreaCore codeArea;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action dualModeAction;
    private Action codeMatrixModeAction;
    private Action textPreviewModeAction;
    private CodeAreaViewMode viewMode = CodeAreaViewMode.DUAL;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void updateForActiveCodeArea(@Nullable CodeAreaCore codeArea) {
        CodeAreaViewMode viewMode;
        this.codeArea = codeArea;
        CodeAreaViewMode codeAreaViewMode = viewMode = codeArea != null ? ((ViewModeCapable)codeArea).getViewMode() : null;
        if (this.dualModeAction != null) {
            this.dualModeAction.setEnabled(codeArea != null);
            if (viewMode == CodeAreaViewMode.DUAL) {
                this.dualModeAction.putValue("SwingSelectedKey", true);
            }
        }
        if (this.codeMatrixModeAction != null) {
            this.codeMatrixModeAction.setEnabled(codeArea != null);
            if (viewMode == CodeAreaViewMode.CODE_MATRIX) {
                this.codeMatrixModeAction.putValue("SwingSelectedKey", true);
            }
        }
        if (this.textPreviewModeAction != null) {
            this.textPreviewModeAction.setEnabled(codeArea != null);
            if (viewMode == CodeAreaViewMode.TEXT_PREVIEW) {
                this.textPreviewModeAction.putValue("SwingSelectedKey", true);
            }
        }
    }

    public void setViewMode(CodeAreaViewMode viewMode) {
        this.viewMode = viewMode;
        ((ViewModeCapable)this.codeArea).setViewMode(viewMode);
    }

    @Nonnull
    public Action getDualModeAction() {
        if (this.dualModeAction == null) {
            this.dualModeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewModeHandlerActions.this.setViewMode(CodeAreaViewMode.DUAL);
                }
            };
            ActionUtils.setupAction((Action)this.dualModeAction, (ResourceBundle)this.resourceBundle, (String)DUAL_VIEW_MODE_ACTION_ID);
            this.dualModeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.dualModeAction.putValue("radioGroup", VIEW_MODE_RADIO_GROUP_ID);
            this.dualModeAction.putValue("SwingSelectedKey", this.viewMode == CodeAreaViewMode.DUAL);
        }
        return this.dualModeAction;
    }

    @Nonnull
    public Action getCodeMatrixModeAction() {
        if (this.codeMatrixModeAction == null) {
            this.codeMatrixModeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewModeHandlerActions.this.setViewMode(CodeAreaViewMode.CODE_MATRIX);
                }
            };
            ActionUtils.setupAction((Action)this.codeMatrixModeAction, (ResourceBundle)this.resourceBundle, (String)CODE_MATRIX_VIEW_MODE_ACTION_ID);
            this.codeMatrixModeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.codeMatrixModeAction.putValue("radioGroup", VIEW_MODE_RADIO_GROUP_ID);
            this.codeMatrixModeAction.putValue("SwingSelectedKey", this.viewMode == CodeAreaViewMode.CODE_MATRIX);
        }
        return this.codeMatrixModeAction;
    }

    @Nonnull
    public Action getTextPreviewModeAction() {
        if (this.textPreviewModeAction == null) {
            this.textPreviewModeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewModeHandlerActions.this.setViewMode(CodeAreaViewMode.TEXT_PREVIEW);
                }
            };
            ActionUtils.setupAction((Action)this.textPreviewModeAction, (ResourceBundle)this.resourceBundle, (String)TEXT_PREVIEW_VIEW_MODE_ACTION_ID);
            this.textPreviewModeAction.putValue("radioGroup", VIEW_MODE_RADIO_GROUP_ID);
            this.textPreviewModeAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.textPreviewModeAction.putValue("SwingSelectedKey", this.viewMode == CodeAreaViewMode.TEXT_PREVIEW);
        }
        return this.textPreviewModeAction;
    }
}

