/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaSelection;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightNonAsciiCodeAreaPainter;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class BinEdCodeAreaPainter
extends ExtendedHighlightNonAsciiCodeAreaPainter {
    private final List<PositionColorModifier> priorityColorModifiers = new ArrayList<PositionColorModifier>();
    private final List<PositionColorModifier> colorModifiers = new ArrayList<PositionColorModifier>();

    public BinEdCodeAreaPainter(CodeAreaCore codeArea) {
        super(codeArea);
    }

    public void addColorModifier(PositionColorModifier colorModifier) {
        this.colorModifiers.add(colorModifier);
    }

    public void removeColorModifier(PositionColorModifier colorModifier) {
        this.colorModifiers.remove(colorModifier);
    }

    public void addPriorityColorModifier(PositionColorModifier colorModifier) {
        this.priorityColorModifiers.add(colorModifier);
    }

    public void removePriorityColorModifier(PositionColorModifier colorModifier) {
        this.priorityColorModifiers.remove(colorModifier);
    }

    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        Color positionBackgroundColor;
        CodeAreaSelection selectionHandler = ((SelectionCapable)this.codeArea).getSelectionHandler();
        boolean inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
        for (PositionColorModifier colorModifier : this.priorityColorModifiers) {
            positionBackgroundColor = colorModifier.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
            if (positionBackgroundColor == null) continue;
            return positionBackgroundColor;
        }
        if (!inSelection) {
            for (PositionColorModifier colorModifier : this.colorModifiers) {
                positionBackgroundColor = colorModifier.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
                if (positionBackgroundColor == null) continue;
                return positionBackgroundColor;
            }
        }
        Color color = super.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
        return color;
    }

    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        Color positionTextColor;
        CodeAreaSelection selectionHandler = ((SelectionCapable)this.codeArea).getSelectionHandler();
        boolean inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
        for (PositionColorModifier colorModifier : this.priorityColorModifiers) {
            positionTextColor = colorModifier.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
            if (positionTextColor == null) continue;
            return positionTextColor;
        }
        if (!inSelection) {
            for (PositionColorModifier colorModifier : this.colorModifiers) {
                positionTextColor = colorModifier.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
                if (positionTextColor == null) continue;
                return positionTextColor;
            }
        }
        return super.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
    }

    public void resetColors() {
        super.resetColors();
        for (PositionColorModifier colorModifier : this.priorityColorModifiers) {
            colorModifier.resetColors();
        }
        for (PositionColorModifier colorModifier : this.colorModifiers) {
            colorModifier.resetColors();
        }
    }

    @ParametersAreNonnullByDefault
    public static interface PositionColorModifier {
        @Nullable
        public Color getPositionBackgroundColor(long var1, int var3, int var4, CodeAreaSection var5, boolean var6);

        @Nullable
        public Color getPositionTextColor(long var1, int var3, int var4, CodeAreaSection var5, boolean var6);

        public void resetColors();
    }
}

