/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.component.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.exbin.framework.action.ActionModule;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.operation.undo.OperationUndoModule;
import org.exbin.framework.operation.undo.api.UndoActions;
import org.exbin.framework.operation.undo.api.UndoActionsHandler;
import org.exbin.framework.operation.undo.api.UndoActionsHandlerEmpty;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsHandlerEmpty;
import org.exbin.framework.utils.ClipboardActionsUpdater;
import org.exbin.framework.utils.TestApplication;
import org.exbin.framework.utils.UtilsModule;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ToolBarEditorPanel
extends JPanel {
    private UndoActionsHandler undoHandler = null;
    private ClipboardActionsHandler clipboardHandler = null;
    private JToolBar toolBar = null;

    public ToolBarEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        TestApplication testApplication = UtilsModule.getDefaultAppEditor();
        OperationUndoModule guiUndoModule = new OperationUndoModule();
        testApplication.addModule(OperationUndoModule.MODULE_ID, (XBApplicationModule)guiUndoModule);
        ActionModule guiActionModule = new ActionModule();
        testApplication.addModule(ActionModule.MODULE_ID, (XBApplicationModule)guiActionModule);
        ToolBarEditorPanel toolBarEditorPanel = new ToolBarEditorPanel();
        UndoActionsHandlerEmpty undoActionsHandler = new UndoActionsHandlerEmpty();
        toolBarEditorPanel.setUndoHandler((UndoActionsHandler)undoActionsHandler, guiUndoModule.createUndoActions((UndoActionsHandler)undoActionsHandler));
        ClipboardActionsHandlerEmpty clipboardActionsHandler = new ClipboardActionsHandlerEmpty();
        toolBarEditorPanel.setClipboardHandler((ClipboardActionsHandler)clipboardActionsHandler, guiActionModule.createClipboardActions((ClipboardActionsHandler)clipboardActionsHandler));
        WindowUtils.invokeDialog((JComponent)toolBarEditorPanel);
    }

    public void setUndoHandler(UndoActionsHandler undoHandler, UndoActions undoActions) {
        this.undoHandler = undoHandler;
        this.initToolBar();
        this.toolBar.add(undoActions.getUndoAction());
        this.toolBar.add(undoActions.getRedoAction());
        undoActions.updateUndoActions();
    }

    public void setClipboardHandler(ClipboardActionsHandler clipboardHandler, ClipboardActionsUpdater clipboardActions) {
        this.clipboardHandler = clipboardHandler;
        this.initToolBar();
        if (this.undoHandler != null) {
            this.toolBar.addSeparator();
        }
        this.toolBar.add(clipboardActions.getCutAction());
        this.toolBar.add(clipboardActions.getCopyAction());
        this.toolBar.add(clipboardActions.getPasteAction());
        clipboardActions.updateClipboardActions();
    }

    private void initToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(false);
            this.add((Component)this.toolBar, "North");
        }
    }
}

