/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.component.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.component.ComponentModule;
import org.exbin.framework.component.api.toolbar.EditItemActions;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.SideToolBar;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;

@ParametersAreNonnullByDefault
public class DefaultEditItemActions
implements EditItemActions {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ComponentModule.class);
    private EditItemActionsHandler actionsHandler = null;
    public static final String ADD_ITEM_ACTION_ID = "addItemAction";
    public static final String EDIT_ITEM_ACTION_ID = "editItemAction";
    public static final String DELETE_ITEM_ACTION_ID = "deleteItemAction";
    private final Mode mode;
    private Action addItemAction = null;
    private Action editItemAction = null;
    private Action deleteItemAction = null;

    public DefaultEditItemActions() {
        this(Mode.NORMAL);
    }

    public DefaultEditItemActions(Mode mode) {
        this.mode = mode;
    }

    public void setEditItemActionsHandler(EditItemActionsHandler actionsHandler) {
        this.actionsHandler = actionsHandler;
    }

    @Nonnull
    public Action getAddItemAction() {
        if (this.addItemAction == null) {
            this.addItemAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultEditItemActions.this.actionsHandler.performAddItem();
                }
            };
            ActionUtils.setupAction((Action)this.addItemAction, (ResourceBundle)this.resourceBundle, (String)ADD_ITEM_ACTION_ID);
            if (this.mode == Mode.DIALOG) {
                this.addItemAction.putValue("dialogMode", true);
            }
            this.addItemAction.setEnabled(false);
        }
        return this.addItemAction;
    }

    @Nonnull
    public Action getEditItemAction() {
        if (this.editItemAction == null) {
            this.editItemAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultEditItemActions.this.actionsHandler.performEditItem();
                }
            };
            ActionUtils.setupAction((Action)this.editItemAction, (ResourceBundle)this.resourceBundle, (String)EDIT_ITEM_ACTION_ID);
            if (this.mode == Mode.DIALOG) {
                this.editItemAction.putValue("dialogMode", true);
            }
            this.editItemAction.setEnabled(false);
        }
        return this.editItemAction;
    }

    @Nonnull
    public Action getDeleteItemAction() {
        if (this.deleteItemAction == null) {
            this.deleteItemAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultEditItemActions.this.actionsHandler.performDeleteItem();
                }
            };
            ActionUtils.setupAction((Action)this.deleteItemAction, (ResourceBundle)this.resourceBundle, (String)DELETE_ITEM_ACTION_ID);
            this.deleteItemAction.setEnabled(false);
        }
        return this.deleteItemAction;
    }

    public void updateEditItemActions() {
        if (this.addItemAction != null) {
            this.addItemAction.setEnabled(this.actionsHandler.canAddItem());
        }
        if (this.editItemAction != null) {
            this.editItemAction.setEnabled(this.actionsHandler.canEditItem());
        }
        if (this.deleteItemAction != null) {
            this.deleteItemAction.setEnabled(this.actionsHandler.canDeleteItem());
        }
    }

    public void registerActions(SideToolBar sideToolBar) {
        sideToolBar.addAction(this.getAddItemAction());
        sideToolBar.addAction(this.getEditItemAction());
        sideToolBar.addAction(this.getDeleteItemAction());
        this.updateEditItemActions();
        this.actionsHandler.setUpdateListener(this::updateEditItemActions);
    }

    public static enum Mode {
        NORMAL,
        DIALOG;

    }
}

