/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.operation.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTDefaultBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.operation.Operation;
import org.exbin.xbup.operation.XBTDocOperation;
import org.exbin.xbup.operation.basic.XBBasicOperationType;
import org.exbin.xbup.operation.basic.XBTAddBlockOperation;

@ParametersAreNonnullByDefault
public class XBTDeleteBlockOperation
extends XBTDocOperation {
    public XBTDeleteBlockOperation(XBTEditableDocument document, XBTBlock block) {
        super(document);
        long position = XBTDefaultBlock.getBlockIndex((XBTBlock)block);
        OutputStream dataOutputStream = this.data.getDataOutputStream();
        XBPSerialWriter writer = new XBPSerialWriter(dataOutputStream);
        Serializator serializator = new Serializator(position);
        writer.write((XBSerializable)serializator);
    }

    @Override
    @Nonnull
    public XBBasicOperationType getBasicType() {
        return XBBasicOperationType.DELETE_BLOCK;
    }

    @Override
    public void execute() throws Exception {
        this.execute(false);
    }

    @Override
    @Nonnull
    public Optional<Operation> executeWithUndo() throws Exception {
        return this.execute(true);
    }

    @Nonnull
    private Optional<Operation> execute(boolean withUndo) {
        InputStream dataInputStream = this.getData().getDataInputStream();
        XBPSerialReader reader = new XBPSerialReader(dataInputStream);
        Serializator serial = new Serializator();
        try {
            reader.read((XBSerializable)serial);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBTDeleteBlockOperation.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalStateException("Unable to process data");
        }
        XBTAddBlockOperation undoOperation = null;
        if (withUndo) {
            XBTEditableBlock deletedNode;
            int childIndex = 0;
            Long parentPosition = null;
            if (serial.position < 1L) {
                deletedNode = (XBTEditableBlock)this.document.getRootBlock().get();
            } else {
                deletedNode = (XBTEditableBlock)this.document.findBlockByIndex(serial.position).get();
                XBTEditableBlock parentNode = (XBTEditableBlock)deletedNode.getParentBlock().get();
                parentPosition = XBTDefaultBlock.getBlockIndex((XBTBlock)parentNode);
                childIndex = Arrays.asList(parentNode.getChildren()).indexOf(deletedNode);
            }
            undoOperation = new XBTAddBlockOperation(this.document, parentPosition, childIndex, deletedNode);
        }
        if (serial.position < 1L) {
            this.document.clear();
        } else {
            XBTEditableBlock node = (XBTEditableBlock)this.document.findBlockByIndex(serial.position).get();
            XBTEditableBlock parentNode = (XBTEditableBlock)node.getParentBlock().get();
            int childIndex = Arrays.asList(parentNode.getChildren()).indexOf(node);
            parentNode.removeChild(childIndex);
        }
        return Optional.ofNullable(undoOperation);
    }

    @ParametersAreNonnullByDefault
    private class Serializator
    implements XBPSequenceSerializable {
        private long position;

        private Serializator() {
        }

        public Serializator(long position) {
            this.position = position;
        }

        public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
            serializationHandler.begin();
            serializationHandler.matchType();
            if (serializationHandler.getSerializationMode() == XBSerializationMode.PULL) {
                this.position = serializationHandler.pullLongAttribute();
            } else {
                serializationHandler.putAttribute(this.position);
            }
            serializationHandler.end();
        }
    }
}

