/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sound.sampled.AudioFileFormat;
import org.exbin.framework.editor.wave.AudioEditor;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileType;
import org.exbin.xbup.audio.wave.XBWave;
import org.exbin.xbup.core.block.declaration.XBDeclaration;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.local.XBLFormatDecl;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.XBPCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.convert.XBTTypeUndeclaringFilter;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTEventListenerToListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTListenerToEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTToXBEventConvertor;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBPullReader;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullTypeDeclaringFilter;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullConvertor;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;

@ParametersAreNonnullByDefault
public class AudioFileHandler
implements FileHandler {
    private AudioPanel audioPanel = new AudioPanel();
    private URI fileUri = null;
    private FileType fileType = null;
    private String title;
    private AudioFileFormat.Type audioFormatType = null;
    private String ext;

    public int getId() {
        return -1;
    }

    @Nonnull
    public AudioPanel getComponent() {
        return this.audioPanel;
    }

    public void loadFromFile(URI fileUri, @Nullable FileType fileType) {
        File file = new File(fileUri);
        if ("XBWaveEditor.XBSFileFilter".equals(fileType.getFileTypeId())) {
            try {
                XBPCatalog catalog = new XBPCatalog();
                catalog.addFormatDecl(this.getContextFormatDecl());
                XBLFormatDecl formatDecl = new XBLFormatDecl(XBWave.XBUP_FORMATREV_CATALOGPATH);
                XBWave wave = new XBWave();
                XBDeclaration declaration = new XBDeclaration((XBFormatDecl)formatDecl, (XBSerializable)wave);
                XBTPullTypeDeclaringFilter typeProcessing = new XBTPullTypeDeclaringFilter((XBCatalog)catalog);
                typeProcessing.attachXBTPullProvider((XBTPullProvider)new XBToXBTPullConvertor((XBPullProvider)new XBPullReader((InputStream)new FileInputStream(file))));
                XBPSerialReader reader = new XBPSerialReader((XBTPullProvider)typeProcessing);
                reader.read((XBSerializable)declaration);
                this.audioPanel.setWave(wave);
                this.fileUri = fileUri;
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(AudioFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            XBWave wave = new XBWave();
            wave.loadFromFile(file);
            this.audioPanel.setWave(wave);
            this.fileUri = fileUri;
        }
    }

    public void saveFile() {
        this.saveToFile(this.fileUri, this.fileType);
    }

    public void saveToFile(URI fileUri, @Nullable FileType fileType) {
        File file = new File(fileUri);
        if ("XBWaveEditor.XBSFileFilter".equals(fileType.getFileTypeId())) {
            try {
                FileOutputStream output = new FileOutputStream(file);
                XBPCatalog catalog = new XBPCatalog();
                catalog.addFormatDecl(this.getContextFormatDecl());
                XBLFormatDecl formatDecl = new XBLFormatDecl(XBWave.XBUP_FORMATREV_CATALOGPATH);
                XBDeclaration declaration = new XBDeclaration((XBFormatDecl)formatDecl, (XBSerializable)this.audioPanel.getWave());
                declaration.realignReservation((XBCatalog)catalog);
                XBTTypeUndeclaringFilter typeProcessing = new XBTTypeUndeclaringFilter((XBCatalog)catalog);
                typeProcessing.attachXBTListener((XBTListener)new XBTEventListenerToListener((XBTEventListener)new XBTToXBEventConvertor((XBEventListener)new XBEventWriter((OutputStream)output))));
                XBPSerialWriter writer = new XBPSerialWriter((XBTEventListener)new XBTListenerToEventListener((XBTListener)typeProcessing));
                writer.write((XBSerializable)declaration);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(AudioFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.getBuildInFileType() == null) {
            this.audioPanel.getWave().saveToFile(file);
        } else {
            this.audioPanel.getWave().saveToFile(file, this.getBuildInFileType());
        }
        this.audioPanel.notifyFileSaved();
    }

    public void clearFile() {
        this.audioPanel.newWave();
    }

    @Nonnull
    public Optional<URI> getFileUri() {
        return Optional.ofNullable(this.fileUri);
    }

    @Nonnull
    public String getTitle() {
        if (this.fileUri != null) {
            String path = this.fileUri.getPath();
            int lastSegment = path.lastIndexOf("/");
            String fileName = lastSegment < 0 ? path : path.substring(lastSegment + 1);
            return fileName == null ? "" : fileName;
        }
        return this.title == null ? "" : this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nonnull
    public Optional<FileType> getFileType() {
        return Optional.ofNullable(this.fileType);
    }

    @Nullable
    public AudioFileFormat.Type getBuildInFileType() {
        return this.audioFormatType;
    }

    public void setFileType(AudioFileFormat.Type fileType) {
        this.audioFormatType = fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public boolean isModified() {
        return this.audioPanel.isModified();
    }

    public XBLFormatDecl getContextFormatDecl() {
        XBPSerialReader reader = new XBPSerialReader(this.getClass().getResourceAsStream("/org/exbin/framework/editor/wave/resources/xbs_format_decl.xb"));
        XBLFormatDecl formatDecl = new XBLFormatDecl();
        try {
            reader.read((XBSerializable)formatDecl);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(AudioEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return formatDecl;
    }
}

