/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave;

import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JPopupMenu;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.AudioFileHandler;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.DefaultFileTypes;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileLoading;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.file.api.FileTypes;
import org.exbin.framework.file.api.UsedDirectoryApi;
import org.exbin.xbup.operation.undo.XBUndoHandler;

@ParametersAreNonnullByDefault
public class AudioEditor
implements EditorProvider {
    private final XBApplication application;
    private AudioFileHandler activeFile;
    private FileTypes fileTypes;
    private EditorProvider.EditorModificationListener editorModificationListener;
    private JPopupMenu popupMenu;
    private MouseMotionListener mouseMotionListener;
    private AudioPanel.StatusChangeListener statusChangeListener;
    private AudioPanel.WaveRepaintListener waveRepaintListener;
    private XBUndoHandler undoHandler;
    @Nullable
    private File lastUsedDirectory;

    public AudioEditor(XBApplication application) {
        this.application = application;
        this.init();
    }

    private void init() {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        this.fileTypes = new DefaultFileTypes(fileModule.getFileTypes());
        this.activeFile = new AudioFileHandler();
    }

    @Nonnull
    public AudioPanel getEditorComponent() {
        return this.activeFile.getComponent();
    }

    @Nonnull
    public Optional<FileHandler> getActiveFile() {
        return Optional.of(this.activeFile);
    }

    @Nonnull
    public String getWindowTitle(String parentTitle) {
        URI fileUri = this.activeFile.getFileUri().orElse(null);
        if (fileUri != null) {
            String path = fileUri.getPath();
            int lastIndexOf = path.lastIndexOf("/");
            if (lastIndexOf < 0) {
                return path + " - " + parentTitle;
            }
            return path.substring(lastIndexOf + 1) + " - " + parentTitle;
        }
        return parentTitle;
    }

    public void openFile(URI fileUri, FileType fileType) {
        this.activeFile.loadFromFile(fileUri, fileType);
    }

    public void setModificationListener(EditorProvider.EditorModificationListener editorModificationListener) {
        this.editorModificationListener = editorModificationListener;
    }

    public void newFile() {
        if (this.releaseAllFiles()) {
            this.activeFile.clearFile();
        }
    }

    public void openFile() {
        if (this.releaseAllFiles()) {
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            fileModule.getFileActions().openFile((FileLoading)this.activeFile, this.fileTypes, (UsedDirectoryApi)this);
        }
    }

    public void loadFromFile(String fileName) throws URISyntaxException {
        URI fileUri = new URI(fileName);
        this.activeFile.loadFromFile(fileUri, null);
    }

    public void loadFromFile(URI fileUri, FileType fileType) {
        this.activeFile.loadFromFile(fileUri, fileType);
    }

    public boolean canSave() {
        return true;
    }

    public void saveFile() {
        Optional<URI> fileUri = this.activeFile.getFileUri();
        if (fileUri.isPresent()) {
            this.activeFile.saveToFile(fileUri.get(), this.activeFile.getFileType().orElse(null));
        } else {
            this.saveAsFile();
        }
    }

    public void saveAsFile() {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.getFileActions().saveAsFile((FileHandler)this.activeFile, this.fileTypes, (UsedDirectoryApi)this);
    }

    public boolean releaseFile(FileHandler fileHandler) {
        if (fileHandler.isModified()) {
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            return fileModule.getFileActions().showAskForSaveDialog(fileHandler, this.fileTypes, (UsedDirectoryApi)this);
        }
        return true;
    }

    public boolean releaseAllFiles() {
        return this.releaseFile(this.activeFile);
    }

    @Nonnull
    public Optional<File> getLastUsedDirectory() {
        return Optional.ofNullable(this.lastUsedDirectory);
    }

    public void setLastUsedDirectory(@Nullable File directory) {
        this.lastUsedDirectory = directory;
    }

    public void updateRecentFilesList(URI fileUri, FileType fileType) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.updateRecentFilesList(fileUri, fileType);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        AudioPanel audioPanel = this.activeFile.getComponent();
        audioPanel.setPopupMenu(popupMenu);
    }

    public void setMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
        AudioPanel audioPanel = this.activeFile.getComponent();
        audioPanel.attachCaretListener(mouseMotionListener);
    }

    public void setStatusChangeListener(AudioPanel.StatusChangeListener statusChangeListener) {
        this.statusChangeListener = statusChangeListener;
        AudioPanel audioPanel = this.activeFile.getComponent();
        audioPanel.addStatusChangeListener(statusChangeListener);
    }

    public void setWaveRepaintListener(AudioPanel.WaveRepaintListener waveRepaintListener) {
        this.waveRepaintListener = waveRepaintListener;
        AudioPanel audioPanel = this.activeFile.getComponent();
        audioPanel.addWaveRepaintListener(waveRepaintListener);
    }

    public void setUndoHandler(XBUndoHandler undoHandler) {
        this.undoHandler = undoHandler;
        AudioPanel audioPanel = this.activeFile.getComponent();
        audioPanel.setUndoHandler(undoHandler);
    }
}

