/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.exbin.framework.bined.search.SearchCondition;

@ParametersAreNonnullByDefault
public class SearchHistoryModel
implements ComboBoxModel<SearchCondition> {
    public static final int HISTORY_LIMIT = 10;
    private final List<SearchCondition> searchHistory;
    private final List<ListDataListener> listDataListeners = new ArrayList<ListDataListener>();
    private SearchCondition selectedItem = null;

    public SearchHistoryModel(List<SearchCondition> searchHistory) {
        this.searchHistory = searchHistory;
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        this.selectedItem = (SearchCondition)selectedItem;
    }

    @Override
    @Nullable
    public SearchCondition getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.searchHistory.size();
    }

    @Override
    @Nullable
    public SearchCondition getElementAt(int index) {
        return this.searchHistory.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listDataListeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listDataListeners.remove(listDataListener);
    }

    public void addSearchCondition(SearchCondition condition) {
        if (condition.isEmpty()) {
            return;
        }
        boolean replaced = false;
        for (int i = 0; i < this.searchHistory.size(); ++i) {
            SearchCondition searchCondition = this.searchHistory.get(i);
            if (!searchCondition.equals(condition)) continue;
            if (i == 0) {
                return;
            }
            this.searchHistory.remove(i);
            for (ListDataListener listDataListener : this.listDataListeners) {
                listDataListener.intervalRemoved(new ListDataEvent(this, 1, i, i));
            }
            replaced = true;
        }
        if (this.searchHistory.size() == 10 && !replaced) {
            int removePosition = this.searchHistory.size() - 1;
            this.searchHistory.remove(removePosition);
            for (ListDataListener listDataListener : this.listDataListeners) {
                listDataListener.intervalRemoved(new ListDataEvent(this, 1, removePosition, removePosition));
            }
        }
        this.searchHistory.add(0, new SearchCondition(condition));
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.intervalAdded(new ListDataEvent(this, 1, 0, 0));
        }
    }
}

