/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JPanel;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.bined.search.ReplaceParameters;
import org.exbin.framework.bined.search.SearchCondition;
import org.exbin.framework.bined.search.SearchParameters;
import org.exbin.framework.bined.search.gui.BinaryMultilinePanel;
import org.exbin.framework.bined.search.gui.BinarySearchPanel;
import org.exbin.framework.bined.search.gui.FindBinaryPanel;
import org.exbin.framework.bined.search.service.BinarySearchService;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;

@ParametersAreNonnullByDefault
public class BinarySearch {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinarySearch.class);
    private static final int DEFAULT_DELAY = 500;
    private InvokeSearchThread invokeSearchThread;
    private SearchThread searchThread;
    private SearchOperation currentSearchOperation = SearchOperation.FIND;
    private SearchParameters.SearchDirection currentSearchDirection = SearchParameters.SearchDirection.FORWARD;
    private final SearchParameters currentSearchParameters = new SearchParameters();
    private final ReplaceParameters currentReplaceParameters = new ReplaceParameters();
    private BinarySearchService.FoundMatches foundMatches = new BinarySearchService.FoundMatches();
    private final List<SearchCondition> searchHistory = new ArrayList<SearchCondition>();
    private final List<SearchCondition> replaceHistory = new ArrayList<SearchCondition>();
    private CodeAreaPopupMenuHandler codeAreaPopupMenuHandler;
    private PanelClosingListener panelClosingListener = null;
    private BinarySearchService binarySearchService;
    private final BinarySearchService.SearchStatusListener searchStatusListener;
    private final BinarySearchPanel binarySearchPanel = new BinarySearchPanel();
    private XBApplication application;

    public BinarySearch() {
        this.searchStatusListener = new BinarySearchService.SearchStatusListener(){

            @Override
            public void setStatus(@Nonnull BinarySearchService.FoundMatches foundMatches, @Nonnull SearchParameters.MatchMode matchMode) {
                BinarySearch.this.foundMatches = foundMatches;
                switch (foundMatches.getMatchesCount()) {
                    case 0: {
                        BinarySearch.this.binarySearchPanel.setInfoLabel(BinarySearch.this.resourceBundle.getString("searchStatus.noMatch"));
                        break;
                    }
                    case 1: {
                        BinarySearch.this.binarySearchPanel.setInfoLabel(matchMode == SearchParameters.MatchMode.MULTIPLE ? BinarySearch.this.resourceBundle.getString("searchStatus.singleMatch") : BinarySearch.this.resourceBundle.getString("searchStatus.matchFound"));
                        break;
                    }
                    default: {
                        BinarySearch.this.binarySearchPanel.setInfoLabel(MessageFormat.format(BinarySearch.this.resourceBundle.getString("searchStatus.foundMatches"), foundMatches.getMatchPosition() + 1, foundMatches.getMatchesCount()));
                    }
                }
                this.updateMatchStatus();
            }

            @Override
            public void clearStatus() {
                BinarySearch.this.binarySearchPanel.setInfoLabel("");
                BinarySearch.this.foundMatches = new BinarySearchService.FoundMatches();
                this.updateMatchStatus();
            }

            private void updateMatchStatus() {
                int matchesCount = BinarySearch.this.foundMatches.getMatchesCount();
                int matchPosition = BinarySearch.this.foundMatches.getMatchPosition();
                BinarySearch.this.binarySearchPanel.updateMatchStatus(matchesCount > 0, matchesCount > 1 && matchPosition > 0, matchPosition < matchesCount - 1);
            }
        };
        this.binarySearchPanel.setControl(new BinarySearchPanel.Control(){

            @Override
            public void prevMatch() {
                BinarySearch.this.foundMatches.prev();
                BinarySearch.this.binarySearchService.setMatchPosition(BinarySearch.this.foundMatches.getMatchPosition());
                BinarySearch.this.searchStatusListener.setStatus(BinarySearch.this.foundMatches, BinarySearch.this.binarySearchService.getLastSearchParameters().getMatchMode());
            }

            @Override
            public void nextMatch() {
                BinarySearch.this.foundMatches.next();
                BinarySearch.this.binarySearchService.setMatchPosition(BinarySearch.this.foundMatches.getMatchPosition());
                BinarySearch.this.searchStatusListener.setStatus(BinarySearch.this.foundMatches, BinarySearch.this.binarySearchService.getLastSearchParameters().getMatchMode());
            }

            @Override
            public void performEscape() {
                BinarySearch.this.cancelSearch();
                this.close();
                BinarySearch.this.clearSearch();
            }

            @Override
            public void performFind() {
                BinarySearch.this.invokeSearch(SearchOperation.FIND);
                BinarySearch.this.binarySearchPanel.updateSearchHistory(BinarySearch.this.currentSearchParameters.getCondition());
            }

            @Override
            public void performReplace() {
                BinarySearch.this.invokeSearch(SearchOperation.REPLACE);
                BinarySearch.this.binarySearchPanel.updateSearchHistory(BinarySearch.this.currentSearchParameters.getCondition());
            }

            @Override
            public void performReplaceAll() {
                BinarySearch.this.invokeSearch(SearchOperation.REPLACE_ALL);
                BinarySearch.this.binarySearchPanel.updateSearchHistory(BinarySearch.this.currentSearchParameters.getCondition());
            }

            @Override
            public void notifySearchChanged() {
                if (BinarySearch.this.currentSearchOperation == SearchOperation.FIND) {
                    BinarySearch.this.invokeSearch(SearchOperation.FIND);
                }
            }

            @Override
            public void notifySearchChanging() {
                if (BinarySearch.this.currentSearchOperation != SearchOperation.FIND) {
                    return;
                }
                SearchCondition condition = BinarySearch.this.currentSearchParameters.getCondition();
                SearchCondition updatedSearchCondition = BinarySearch.this.binarySearchPanel.getSearchParameters().getCondition();
                switch (updatedSearchCondition.getSearchMode()) {
                    case TEXT: {
                        String searchText = updatedSearchCondition.getSearchText();
                        if (searchText.isEmpty()) {
                            condition.setSearchText(searchText);
                            BinarySearch.this.clearSearch();
                            return;
                        }
                        if (searchText.equals(condition.getSearchText())) {
                            return;
                        }
                        condition.setSearchText(searchText);
                        break;
                    }
                    case BINARY: {
                        EditableBinaryData searchData = (EditableBinaryData)updatedSearchCondition.getBinaryData();
                        if (searchData == null || searchData.isEmpty()) {
                            condition.setBinaryData(null);
                            BinarySearch.this.clearSearch();
                            return;
                        }
                        if (searchData.equals(condition.getBinaryData())) {
                            return;
                        }
                        ByteArrayEditableData data = new ByteArrayEditableData();
                        data.insert(0L, (BinaryData)searchData);
                        condition.setBinaryData((EditableBinaryData)data);
                        break;
                    }
                }
                BinarySearch.this.invokeSearch(SearchOperation.FIND, 500);
            }

            @Override
            public void searchOptions() {
                BinarySearch.this.cancelSearch();
                FrameModuleApi frameModule = (FrameModuleApi)BinarySearch.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                FindBinaryPanel findBinaryPanel = new FindBinaryPanel();
                findBinaryPanel.setSelected();
                findBinaryPanel.setSearchHistory(BinarySearch.this.searchHistory);
                findBinaryPanel.setSearchParameters(BinarySearch.this.currentSearchParameters);
                findBinaryPanel.setReplaceParameters(BinarySearch.this.currentReplaceParameters);
                findBinaryPanel.setCodeAreaPopupMenuHandler(BinarySearch.this.codeAreaPopupMenuHandler);
                DefaultControlPanel controlPanel = new DefaultControlPanel(findBinaryPanel.getResourceBundle());
                final WindowUtils.DialogWrapper dialog = frameModule.createDialog((JPanel)findBinaryPanel, (JPanel)controlPanel);
                frameModule.setDialogTitle(dialog, findBinaryPanel.getResourceBundle());
                WindowUtils.addHeaderPanel((Window)dialog.getWindow(), findBinaryPanel.getClass(), (ResourceBundle)findBinaryPanel.getResourceBundle());
                findBinaryPanel.setMultilineEditorListener(new FindBinaryPanel.MultilineEditorListener(){

                    @Override
                    public SearchCondition multilineEdit(SearchCondition condition) {
                        BinaryMultilinePanel multilinePanel = new BinaryMultilinePanel();
                        multilinePanel.setCodeAreaPopupMenuHandler(BinarySearch.this.codeAreaPopupMenuHandler);
                        multilinePanel.setCondition(condition);
                        DefaultControlPanel controlPanel = new DefaultControlPanel();
                        JPanel dialogPanel = WindowUtils.createDialogPanel((JPanel)multilinePanel, (JPanel)controlPanel);
                        FrameModuleApi frameModule = (FrameModuleApi)BinarySearch.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                        WindowUtils.DialogWrapper multilineDialog = frameModule.createDialog((Component)dialog.getWindow(), Dialog.ModalityType.APPLICATION_MODAL, dialogPanel);
                        WindowUtils.addHeaderPanel((Window)multilineDialog.getWindow(), multilinePanel.getClass(), (ResourceBundle)multilinePanel.getResourceBundle());
                        frameModule.setDialogTitle(multilineDialog, multilinePanel.getResourceBundle());
                        SearchConditionResult result = new SearchConditionResult();
                        controlPanel.setHandler(actionType -> {
                            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                                result.searchCondition = multilinePanel.getCondition();
                                BinarySearch.this.binarySearchPanel.updateFindStatus();
                            }
                            multilineDialog.close();
                            multilineDialog.dispose();
                        });
                        multilineDialog.showCentered((Component)dialog.getWindow());
                        multilinePanel.detachMenu();
                        return result.searchCondition;
                    }

                    class SearchConditionResult {
                        SearchCondition searchCondition = null;

                        SearchConditionResult() {
                        }
                    }
                });
                controlPanel.setHandler(actionType -> {
                    if (actionType == DefaultControlHandler.ControlActionType.OK) {
                        SearchParameters dialogSearchParameters = findBinaryPanel.getSearchParameters();
                        dialogSearchParameters.setFromParameters(dialogSearchParameters);
                        BinarySearch.this.currentSearchDirection = dialogSearchParameters.getSearchDirection();
                        ReplaceParameters dialogReplaceParameters = new ReplaceParameters();
                        dialogReplaceParameters.setFromParameters(findBinaryPanel.getReplaceParameters());
                        boolean performReplace = dialogReplaceParameters.isPerformReplace();
                        BinarySearch.this.binarySearchPanel.switchPanelMode(performReplace ? BinarySearchPanel.PanelMode.REPLACE : BinarySearchPanel.PanelMode.FIND);
                        BinarySearch.this.invokeSearch(performReplace ? SearchOperation.REPLACE : SearchOperation.FIND, dialogSearchParameters, dialogReplaceParameters);
                    }
                    findBinaryPanel.detachMenu();
                    dialog.close();
                    dialog.dispose();
                });
                dialog.showCentered((Component)WindowUtils.getWindow((Component)BinarySearch.this.binarySearchPanel));
            }

            @Override
            @Nonnull
            public SearchParameters.SearchDirection getSearchDirection() {
                return BinarySearch.this.currentSearchDirection;
            }

            @Override
            public void close() {
                if (BinarySearch.this.panelClosingListener != null) {
                    BinarySearch.this.clearSearch();
                    BinarySearch.this.panelClosingListener.closed();
                }
            }
        });
        this.binarySearchPanel.setSearchHistory(this.searchHistory);
        this.binarySearchPanel.setReplaceHistory(this.replaceHistory);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.binarySearchPanel.setApplication(application);
    }

    public void setBinarySearchService(BinarySearchService binarySearchService) {
        this.binarySearchService = binarySearchService;
    }

    public void setPanelClosingListener(PanelClosingListener panelClosingListener) {
        this.panelClosingListener = panelClosingListener;
    }

    public void setCodeAreaPopupMenuHandler(CodeAreaPopupMenuHandler codeAreaPopupMenuHandler) {
        this.codeAreaPopupMenuHandler = codeAreaPopupMenuHandler;
        this.binarySearchPanel.setCodeAreaPopupMenuHandler(codeAreaPopupMenuHandler);
    }

    @Nonnull
    public BinarySearchService.SearchStatusListener getSearchStatusListener() {
        return this.searchStatusListener;
    }

    private void invokeSearch(SearchOperation searchOperation) {
        this.invokeSearch(searchOperation, this.binarySearchPanel.getSearchParameters(), this.binarySearchPanel.getReplaceParameters(), 0);
    }

    private void invokeSearch(SearchOperation searchOperation, int delay) {
        this.invokeSearch(searchOperation, this.binarySearchPanel.getSearchParameters(), this.binarySearchPanel.getReplaceParameters(), delay);
    }

    private void invokeSearch(SearchOperation searchOperation, SearchParameters searchParameters, @Nullable ReplaceParameters replaceParameters) {
        this.invokeSearch(searchOperation, searchParameters, replaceParameters, 0);
    }

    private void invokeSearch(SearchOperation searchOperation, SearchParameters searchParameters, @Nullable ReplaceParameters replaceParameters, int delay) {
        if (this.invokeSearchThread != null) {
            this.invokeSearchThread.interrupt();
        }
        this.invokeSearchThread = new InvokeSearchThread();
        this.invokeSearchThread.delay = delay;
        this.currentSearchOperation = searchOperation;
        this.currentSearchParameters.setFromParameters(searchParameters);
        this.currentReplaceParameters.setFromParameters(replaceParameters);
        this.invokeSearchThread.start();
    }

    public void cancelSearch() {
        if (this.invokeSearchThread != null) {
            this.invokeSearchThread.interrupt();
        }
        if (this.searchThread != null) {
            this.searchThread.interrupt();
        }
    }

    public void clearSearch() {
        SearchCondition condition = this.currentSearchParameters.getCondition();
        condition.clear();
        this.binarySearchPanel.clearSearch();
        this.binarySearchService.clearMatches();
        this.searchStatusListener.clearStatus();
    }

    @Nonnull
    public BinarySearchPanel getPanel() {
        return this.binarySearchPanel;
    }

    public void dataChanged() {
        this.binarySearchService.clearMatches();
        this.invokeSearch(this.currentSearchOperation, 500);
    }

    private static enum SearchOperation {
        FIND,
        FIND_AGAIN,
        REPLACE,
        REPLACE_ALL;

    }

    public static interface PanelClosingListener {
        public void closed();
    }

    private class SearchThread
    extends Thread {
        public SearchThread() {
            super(() -> {
                switch (BinarySearch.this.currentSearchOperation) {
                    case FIND: {
                        BinarySearch.this.binarySearchService.performFind(BinarySearch.this.currentSearchParameters, BinarySearch.this.searchStatusListener);
                        break;
                    }
                    case FIND_AGAIN: {
                        BinarySearch.this.binarySearchService.performFindAgain(BinarySearch.this.searchStatusListener);
                        break;
                    }
                    case REPLACE: {
                        BinarySearch.this.binarySearchService.performReplace(BinarySearch.this.currentSearchParameters, BinarySearch.this.currentReplaceParameters);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
            });
        }
    }

    private class InvokeSearchThread
    extends Thread {
        private int delay = 500;

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                if (BinarySearch.this.searchThread != null) {
                    BinarySearch.this.searchThread.interrupt();
                }
                BinarySearch.this.searchThread = new SearchThread();
                BinarySearch.this.searchThread.start();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

