/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture.gui;

import java.net.URI;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.picture.ImageEditor;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class PropertiesPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(PropertiesPanel.class);
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;

    public PropertiesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.fileNameLabel.setText(this.resourceBundle.getString("fileNameLabel.text"));
        this.fileNameTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileNameLabel).addGap(0, 376, Short.MAX_VALUE)).addComponent(this.fileNameTextField)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fileNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileNameTextField, -2, -1, -2).addContainerGap(204, Short.MAX_VALUE)));
    }

    public void setDocument(ImageEditor imageEditor) {
        Optional<FileHandler> activeFile = imageEditor.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        Optional fileUri = activeFile.get().getFileUri();
        this.fileNameTextField.setText(fileUri.isPresent() ? ((URI)fileUri.get()).toString() : "");
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new PropertiesPanel());
    }
}

