/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.picture.ImageEditor;
import org.exbin.framework.editor.picture.gui.PropertiesPanel;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;

@ParametersAreNonnullByDefault
public class PropertiesAction
extends AbstractAction {
    public static final String ACTION_ID = "propertiesAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.editorProvider instanceof ImageEditor) {
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            PropertiesPanel propertiesPanel = new PropertiesPanel();
            propertiesPanel.setDocument((ImageEditor)this.editorProvider);
            CloseControlPanel controlPanel = new CloseControlPanel();
            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)propertiesPanel, (JPanel)controlPanel);
            WindowUtils.addHeaderPanel((Window)dialog.getWindow(), propertiesPanel.getClass(), (ResourceBundle)propertiesPanel.getResourceBundle());
            frameModule.setDialogTitle(dialog, propertiesPanel.getResourceBundle());
            controlPanel.setHandler(() -> ((WindowUtils.DialogWrapper)dialog).close());
            dialog.showCentered((Component)e.getSource());
            dialog.dispose();
        }
    }
}

