/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.themes.DefaultThemeMeta;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeMeta;
import bibliothek.gui.dock.themes.ThemeProperties;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemePropertyFactory<T extends DockTheme>
implements ThemeFactory {
    private Constructor<T> constructor;
    private ThemeProperties properties;

    public ThemePropertyFactory(Class<T> theme) {
        if (theme == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        this.properties = theme.getAnnotation(ThemeProperties.class);
        if (this.properties == null) {
            throw new IllegalArgumentException("Theme misses annotation ThemeProperties");
        }
        try {
            this.constructor = theme.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Missing default constructor", e);
        }
    }

    public T create(DockController controller) {
        try {
            return (T)((DockTheme)this.constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            System.err.println("Can't create theme due an unknown reason");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ThemeMeta createMeta(DockController controller) {
        return new DefaultThemeMeta(this, controller, this.properties.nameBundle(), this.properties.descriptionBundle(), this.getAuthors(), this.getWebpages());
    }

    public String[] getAuthors() {
        return this.properties.authors();
    }

    public URI[] getWebpages() {
        try {
            String[] urls = this.properties.webpages();
            URI[] result = new URI[urls.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new URI(urls[i]);
            }
            return result;
        }
        catch (URISyntaxException ex) {
            System.err.print("Can't create urls due an unknown reason");
            ex.printStackTrace();
            return null;
        }
    }
}

