/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.split.PerspectiveSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitPerspectivePlaceholderConverter;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockPerspective
implements PerspectiveDockable,
PerspectiveStation {
    private PerspectiveStation parent;
    private PerspectiveDockable fullscreen;
    private final Root root = new Root();
    private List<PerspectiveDockable> children = new ArrayList<PerspectiveDockable>();
    private List<EntryListener> listeners = new ArrayList<EntryListener>();
    private boolean hasFullscreenAction = true;

    public SplitDockPerspective() {
        this.addListener(new EntryListener(){

            public void added(Entry parent, Entry child) {
                this.add(child);
            }

            public void removed(Entry parent, Entry child) {
                this.remove(child);
            }

            public void modified(Leaf leaf, PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
                if (oldDockable != null) {
                    SplitDockPerspective.this.children.remove(oldDockable);
                    oldDockable.setParent(null);
                }
                if (newDockable != null) {
                    DockUtilities.ensureTreeValidity(SplitDockPerspective.this, newDockable);
                    SplitDockPerspective.this.children.add(newDockable);
                    newDockable.setParent(SplitDockPerspective.this);
                }
            }

            private void add(Entry child) {
                if (child != null) {
                    if (child.asLeaf() != null) {
                        PerspectiveDockable dockable = child.asLeaf().getDockable();
                        if (dockable != null) {
                            DockUtilities.ensureTreeValidity(SplitDockPerspective.this, dockable);
                            dockable.setParent(SplitDockPerspective.this);
                            SplitDockPerspective.this.children.add(dockable);
                        }
                    } else {
                        this.add(child.asNode().getChildA());
                        this.add(child.asNode().getChildB());
                    }
                }
            }

            private void remove(Entry child) {
                if (child != null) {
                    if (child.asLeaf() != null) {
                        PerspectiveDockable dockable = child.asLeaf().getDockable();
                        if (dockable != null) {
                            SplitDockPerspective.this.children.remove(dockable);
                            dockable.setParent(null);
                        }
                    } else {
                        this.remove(child.asNode().getChildA());
                        this.remove(child.asNode().getChildB());
                    }
                }
            }
        });
    }

    public void addListener(EntryListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(EntryListener listener) {
        this.listeners.remove(listener);
    }

    protected EntryListener[] listeners() {
        return this.listeners.toArray(new EntryListener[this.listeners.size()]);
    }

    protected void fireRemoved(Entry parent, Entry child) {
        for (EntryListener listener : this.listeners()) {
            listener.removed(parent, child);
        }
    }

    protected void fireAdded(Entry parent, Entry child) {
        for (EntryListener listener : this.listeners()) {
            listener.added(parent, child);
        }
    }

    public void read(PerspectiveSplitDockTree tree, PerspectiveDockable fullscreen) {
        this.root.setChild(this.convert(tree.getRoot()));
        if (fullscreen != null && !this.children.contains(fullscreen)) {
            throw new IllegalArgumentException("fullscreen is not a child of this station");
        }
        this.fullscreen = fullscreen;
    }

    public void setHasFullscreenAction(boolean hasFullscreenAction) {
        this.hasFullscreenAction = hasFullscreenAction;
    }

    public boolean hasFullscreenAction() {
        return this.hasFullscreenAction;
    }

    protected PerspectiveDockable combine(PerspectiveDockable[] dockables, PerspectiveDockable selection) {
        return new StackDockPerspective(dockables, selection);
    }

    private Entry convert(SplitDockTree.Key key) {
        if (key == null) {
            return null;
        }
        SplitDockTree tree = key.getTree();
        if (tree.isDockable(key)) {
            PerspectiveDockable[] dockables = (PerspectiveDockable[])tree.getDockables(key);
            PerspectiveDockable dockable = null;
            if (dockables != null && dockables.length != 0) {
                if (dockables.length == 1) {
                    dockable = dockables[0];
                } else if (dockables.length > 1) {
                    dockable = this.combine(dockables, (PerspectiveDockable)tree.getSelected(key));
                }
                if (dockable != null) {
                    DockUtilities.ensureTreeValidity(this, dockable);
                    dockable.setParent(this);
                }
            }
            return new Leaf(dockable, this.toSet(tree.getPlaceholders(key)), tree.getPlaceholderMap(key), key.getNodeId());
        }
        if (tree.isNode(key)) {
            Entry childA = this.convert(tree.getLeft(key));
            Entry childB = this.convert(tree.getRight(key));
            SplitDockStation.Orientation orientation = tree.isHorizontal(key) ? SplitDockStation.Orientation.HORIZONTAL : SplitDockStation.Orientation.VERTICAL;
            return new Node(orientation, tree.getDivider(key), childA, childB, this.toSet(tree.getPlaceholders(key)), tree.getPlaceholderMap(key), key.getNodeId());
        }
        throw new IllegalStateException("key does not represent any known kind of element");
    }

    private Set<Path> toSet(Path[] placeholders) {
        HashSet<Path> result = new HashSet<Path>();
        if (placeholders != null) {
            for (Path placeholder : placeholders) {
                result.add(placeholder);
            }
        }
        return result;
    }

    public PerspectiveDockable getFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(PerspectiveDockable fullscreen) {
        if (fullscreen.getParent() != this) {
            throw new IllegalArgumentException("not a child of this station");
        }
        this.fullscreen = fullscreen;
    }

    public Root getRoot() {
        return this.root;
    }

    @Override
    public PerspectiveStation getParent() {
        return this.parent;
    }

    @Override
    public Path getPlaceholder() {
        return null;
    }

    @Override
    public void setParent(PerspectiveStation parent) {
        this.parent = parent;
    }

    @Override
    public PerspectiveDockable asDockable() {
        return this;
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockStationFactory";
    }

    @Override
    public PerspectiveDockable getDockable(int index) {
        return this.children.get(index);
    }

    @Override
    public int getDockableCount() {
        return this.children.size();
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
        SplitPerspectivePlaceholderConverter converter = new SplitPerspectivePlaceholderConverter(this);
        converter.setPlaceholders(placeholders);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        SplitPerspectivePlaceholderConverter converter = new SplitPerspectivePlaceholderConverter(this);
        return converter.getPlaceholders();
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable child, PerspectiveDockable target) {
        Path placeholder = null;
        placeholder = target != null ? target.getPlaceholder() : child.getPlaceholder();
        SplitDockPathProperty backup = this.getDockablePathProperty(child);
        if (placeholder == null) {
            return backup;
        }
        return new SplitDockPlaceholderProperty(placeholder, backup);
    }

    public SplitDockPathProperty getDockablePathProperty(PerspectiveDockable child) {
        Leaf leaf = this.getLeaf(child);
        if (leaf == null) {
            return null;
        }
        SplitDockPathProperty path = new SplitDockPathProperty();
        path.setLeafId(leaf.getNodeId());
        Entry nodeChild = leaf;
        Node parent = leaf.getParent().asNode();
        while (parent != null) {
            SplitDockPathProperty.Location location;
            double size;
            if (parent.getChildA() == nodeChild) {
                size = parent.getDivider();
                location = parent.getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? SplitDockPathProperty.Location.LEFT : SplitDockPathProperty.Location.TOP;
            } else {
                size = 1.0 - parent.getDivider();
                location = parent.getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? SplitDockPathProperty.Location.RIGHT : SplitDockPathProperty.Location.BOTTOM;
            }
            path.insert(location, size, 0, parent.getNodeId());
            nodeChild = parent;
            parent = parent.getParent().asNode();
        }
        return path;
    }

    @Override
    public boolean remove(PerspectiveDockable dockable) {
        Leaf leaf = this.getLeaf(dockable);
        if (leaf != null) {
            leaf.remove();
            return true;
        }
        return false;
    }

    @Override
    public void replace(PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
        Leaf leaf = this.getLeaf(oldDockable);
        if (leaf == null) {
            throw new IllegalArgumentException("oldDockable not child of this station");
        }
        DockUtilities.ensureTreeValidity(this, newDockable);
        PlaceholderMap map = leaf.getPlaceholderMap();
        if (oldDockable.asStation() != null) {
            map = oldDockable.asStation().getPlaceholders();
        }
        Leaf copy = new Leaf(newDockable, leaf.getPlaceholders(), map, leaf.getNodeId());
        leaf.replace(copy);
        Path placeholder = oldDockable.getPlaceholder();
        if (placeholder != null) {
            this.addPlaceholder(copy, placeholder);
        }
    }

    public Leaf getLeaf(PerspectiveDockable child) {
        return this.find(this.getRoot().getChild(), child);
    }

    private Leaf find(Entry start, PerspectiveDockable child) {
        if (start == null) {
            return null;
        }
        if (start.asLeaf() != null) {
            if (start.asLeaf().getDockable() == child) {
                return start.asLeaf();
            }
            return null;
        }
        Leaf result = this.find(start.asNode().getChildA(), child);
        if (result == null) {
            result = this.find(start.asNode().getChildB(), child);
        }
        return result;
    }

    public void addPlaceholder(Entry destination, Path placeholder) {
        if (!destination.isAnchestor(this.getRoot())) {
            throw new IllegalArgumentException("destination is not child of this perspective");
        }
        this.clearPlaceholder(placeholder, destination);
        destination.getPlaceholders().add(placeholder);
    }

    private void clearPlaceholder(Path placeholder, Entry exception) {
        this.clearPlaceholder(this.getRoot().getChild(), placeholder, exception);
    }

    private void clearPlaceholder(Entry parent, Path placeholder, Entry exception) {
        if (parent != null && parent != exception) {
            if (parent.getPlaceholderMap() != null) {
                parent.getPlaceholderMap().removeAll(placeholder, true);
            }
            parent.getPlaceholders().remove(placeholder);
        }
        if (parent.asNode() != null) {
            this.clearPlaceholder(parent.asNode().getChildA(), placeholder, exception);
            this.clearPlaceholder(parent.asNode().getChildB(), placeholder, exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Leaf
    extends Entry {
        private PerspectiveDockable dockable;

        public Leaf(PerspectiveDockable dockable, Set<Path> placeholders, PlaceholderMap placeholderMap, long nodeId) {
            super(placeholders, placeholderMap, nodeId);
            this.dockable = dockable;
        }

        @Override
        public Leaf asLeaf() {
            return this;
        }

        public PerspectiveDockable getDockable() {
            return this.dockable;
        }

        public void setDockable(PerspectiveDockable dockable) {
            SplitDockPerspective perspective = this.getPerspective();
            if (perspective == null) {
                this.dockable = dockable;
            } else {
                PerspectiveDockable oldDockable = this.dockable;
                this.dockable = dockable;
                for (EntryListener listener : perspective.listeners()) {
                    listener.modified(this, oldDockable, dockable);
                }
            }
        }

        public void remove() {
            SplitDockPerspective perspective = this.getPerspective();
            if (perspective == null) {
                throw new IllegalStateException("this method can only be applied to leafs that have a root as anchestor");
            }
            if (this.dockable != null) {
                Path placeholder = this.dockable.getPlaceholder();
                if (placeholder != null) {
                    perspective.addPlaceholder(this, placeholder);
                }
                if (this.dockable.asStation() != null) {
                    this.setPlaceholderMap(this.dockable.asStation().getPlaceholders());
                }
                this.setDockable(null);
            }
            if (this.getPlaceholderMap() == null && this.getPlaceholders().isEmpty()) {
                this.delete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node
    extends Entry {
        private SplitDockStation.Orientation orientation;
        private double divider;
        private Entry childA;
        private Entry childB;

        public Node(SplitDockStation.Orientation orientation, double divider, Entry childA, Entry childB, Set<Path> placeholders, PlaceholderMap placeholderMap, long id) {
            super(placeholders, placeholderMap, id);
            this.orientation = orientation;
            this.divider = divider;
            this.setChildA(childA);
            this.setChildB(childB);
        }

        @Override
        public Node asNode() {
            return this;
        }

        public SplitDockStation.Orientation getOrientation() {
            return this.orientation;
        }

        public double getDivider() {
            return this.divider;
        }

        public Entry getChildA() {
            return this.childA;
        }

        public void setChildA(Entry childA) {
            if (childA != null && childA.asLeaf() == null && childA.asNode() == null) {
                throw new IllegalArgumentException("child must either be a leaf or a node");
            }
            if (childA != null && this.isAnchestor(childA)) {
                throw new IllegalArgumentException("cannot build a cycle");
            }
            SplitDockPerspective perspective = this.getPerspective();
            if (this.childA != null) {
                this.childA.setParent(null);
                if (perspective != null) {
                    perspective.fireRemoved(this, this.childA);
                }
            }
            this.childA = childA;
            if (this.childA != null) {
                this.childA.setParent(this);
                if (perspective != null) {
                    perspective.fireAdded(this, this.childA);
                }
            }
        }

        public Entry getChildB() {
            return this.childB;
        }

        public void setChildB(Entry childB) {
            if (childB != null && childB.asLeaf() == null && childB.asNode() == null) {
                throw new IllegalArgumentException("child must either be a leaf or a node");
            }
            if (childB != null && this.isAnchestor(childB)) {
                throw new IllegalArgumentException("cannot build a cycle");
            }
            SplitDockPerspective perspective = this.getPerspective();
            if (this.childB != null) {
                this.childB.setParent(null);
                if (perspective != null) {
                    perspective.fireRemoved(this, this.childB);
                }
            }
            this.childB = childB;
            if (this.childB != null) {
                this.childB.setParent(this);
                if (perspective != null) {
                    perspective.fireAdded(this, this.childB);
                }
            }
        }
    }

    public class Root
    extends Entry {
        private Entry child;

        public Root() {
            super(new HashSet<Path>(), null, -1L);
        }

        public SplitDockPerspective getPerspective() {
            return SplitDockPerspective.this;
        }

        protected void setParent(Entry parent) {
            throw new IllegalStateException("cannot set the parent of a root");
        }

        public Entry getChild() {
            return this.child;
        }

        public void setChild(Entry child) {
            if (child != null && child.asLeaf() == null && child.asNode() == null) {
                throw new IllegalArgumentException("child must either be a leaf or a node");
            }
            if (this.child != null) {
                this.child.setParent(null);
                SplitDockPerspective.this.fireRemoved(this, this.child);
            }
            this.child = child;
            if (this.child != null) {
                this.child.setParent(this);
                SplitDockPerspective.this.fireAdded(this, this.child);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry {
        private Entry parent;
        private long id;
        private Set<Path> placeholders;
        private PlaceholderMap placeholderMap;

        public Entry(Set<Path> placeholders, PlaceholderMap placeholderMap, long id) {
            this.placeholders = placeholders;
            this.placeholderMap = placeholderMap;
            this.id = id;
        }

        public boolean isAnchestor(Entry anchestor) {
            for (Entry current = this; current != null; current = current.getParent()) {
                if (current != anchestor) continue;
                return true;
            }
            return false;
        }

        public SplitDockPerspective getPerspective() {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getPerspective();
        }

        public void delete() {
            Entry parent = this.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof Root) {
                ((Root)parent).setChild(null);
            } else {
                Entry other;
                Node parentNode = (Node)parent;
                if (parentNode.getChildA() == this) {
                    other = parentNode.getChildB();
                    parentNode.setChildA(null);
                } else {
                    other = parentNode.getChildA();
                    parentNode.setChildB(null);
                }
                parent = parentNode.getParent();
                if (parent == null) {
                    return;
                }
                parentNode.setChildA(null);
                parentNode.setChildB(null);
                if (parent instanceof Root) {
                    ((Root)parent).setChild(other);
                } else {
                    Node nextParent = (Node)parent;
                    if (nextParent.getChildA() == parentNode) {
                        nextParent.setChildA(other);
                    } else {
                        nextParent.setChildB(other);
                    }
                }
            }
        }

        public void replace(Entry next) {
            Entry parent = this.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof Root) {
                ((Root)parent).setChild(next);
            } else {
                Node parentNode = (Node)parent;
                if (parentNode.getChildA() == this) {
                    parentNode.setChildA(next);
                } else {
                    parentNode.setChildB(next);
                }
            }
        }

        protected void setParent(Entry parent) {
            this.parent = parent;
        }

        public Entry getParent() {
            return this.parent;
        }

        public long getNodeId() {
            return this.id;
        }

        public Leaf asLeaf() {
            return null;
        }

        public Node asNode() {
            return null;
        }

        public Set<Path> getPlaceholders() {
            return this.placeholders;
        }

        public PlaceholderMap getPlaceholderMap() {
            return this.placeholderMap;
        }

        public void setPlaceholderMap(PlaceholderMap placeholderMap) {
            this.placeholderMap = placeholderMap;
        }
    }

    public static interface EntryListener {
        public void added(Entry var1, Entry var2);

        public void removed(Entry var1, Entry var2);

        public void modified(Leaf var1, PerspectiveDockable var2, PerspectiveDockable var3);
    }
}

