/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.window.AbstractScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.WindowConfiguration;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class InternalDockDialog
extends AbstractScreenDockWindow {
    private JDesktopPane desktop;
    private JPanel dialog;

    public InternalDockDialog(ScreenDockStation station, WindowConfiguration configuration, JDesktopPane desktop) {
        super(station, configuration);
        this.desktop = desktop;
        this.initDialog(configuration);
    }

    private void initDialog(WindowConfiguration configuration) {
        this.dialog = new JPanel();
        this.dialog.setVisible(false);
        this.desktop.add(this.dialog);
        this.desktop.setLayer(this.dialog, JDesktopPane.MODAL_LAYER);
        if (configuration.isTransparent()) {
            this.dialog.setOpaque(false);
        }
        this.init(this.dialog, this.dialog, configuration, true);
    }

    protected void convertPointToScreen(Point point, Component component) {
        Point result = SwingUtilities.convertPoint(component, point, this.desktop);
        point.x = result.x;
        point.y = result.y;
    }

    public void setWindowBounds(Rectangle bounds, boolean screenCoordinates) {
        if (screenCoordinates) {
            Point location = bounds.getLocation();
            SwingUtilities.convertPointFromScreen(location, this.desktop);
            bounds = new Rectangle(location, bounds.getSize());
        }
        super.setWindowBounds(bounds, false);
    }

    public void destroy() {
        this.dialog.setVisible(false);
        this.desktop.remove(this.dialog);
    }

    public void toFront() {
        this.desktop.moveToFront(this.dialog);
    }

    public void setPreventFocusStealing(boolean prevent) {
    }
}

