/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.flap.FlapDockPerspective;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationLayout;
import bibliothek.gui.dock.station.flap.RetroFlapDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlapDockStationFactory
implements DockFactory<FlapDockStation, FlapDockPerspective, FlapDockStationLayout> {
    public static final String ID = "flap dock";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public FlapDockStationLayout getLayout(FlapDockStation station, Map<Dockable, Integer> children) {
        PlaceholderMap map = station.getPlaceholders(children);
        return new FlapDockStationLayout(station.isAutoDirection(), station.getDirection(), map);
    }

    @Override
    public void setLayout(FlapDockStation station, FlapDockStationLayout layout, PlaceholderStrategy placeholders) {
        station.setDirection(layout.getDirection());
        station.setAutoDirection(layout.isAutoDirection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayout(FlapDockStation station, FlapDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        DockController controller = station.getController();
        try {
            if (controller != null) {
                controller.freezeLayout();
            }
            for (int i = station.getDockableCount() - 1; i >= 0; --i) {
                station.remove(i);
            }
            station.setDirection(layout.getDirection());
            station.setAutoDirection(layout.isAutoDirection());
            if (layout instanceof RetroFlapDockStationLayout) {
                RetroFlapDockStationLayout retroLayout = (RetroFlapDockStationLayout)layout;
                int[] ids = retroLayout.getChildren();
                boolean[] holding = retroLayout.getHolds();
                int[] sizes = retroLayout.getSizes();
                int n = ids.length;
                for (int i = 0; i < n; ++i) {
                    Dockable dockable = children.get(ids[i]);
                    if (dockable == null) continue;
                    station.add(dockable);
                    station.setHold(dockable, holding[i]);
                    station.setWindowSize(dockable, sizes[i]);
                }
            } else {
                station.setPlaceholders(layout.getPlaceholders().filter(placeholders), children);
            }
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    @Override
    public FlapDockPerspective layoutPerspective(FlapDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        FlapDockPerspective perspective = new FlapDockPerspective();
        this.layoutPerspective(perspective, layout, children);
        return perspective;
    }

    @Override
    public void layoutPerspective(FlapDockPerspective perspective, FlapDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        perspective.read(layout.getPlaceholders(), children);
    }

    @Override
    public FlapDockStationLayout getPerspectiveLayout(FlapDockPerspective element, Map<PerspectiveDockable, Integer> children) {
        boolean autoDirection = true;
        FlapDockStation.Direction direction = FlapDockStation.Direction.SOUTH;
        PlaceholderMap placeholders = element.toMap(children);
        return new FlapDockStationLayout(autoDirection, direction, placeholders);
    }

    @Override
    public void estimateLocations(FlapDockStationLayout layout, final LocationEstimationMap children) {
        if (layout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroLayout = (RetroFlapDockStationLayout)layout;
            int[] ids = retroLayout.getChildren();
            boolean[] holding = retroLayout.getHolds();
            int[] sizes = retroLayout.getSizes();
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                DockLayoutInfo info = children.getChild(ids[i]);
                if (info == null) continue;
                FlapDockProperty property = new FlapDockProperty(i, holding[i], sizes[i], info.getPlaceholder());
                info.setLocation(property);
            }
        } else {
            DockablePlaceholderList.simulatedRead(layout.getPlaceholders(), new PlaceholderListItemAdapter<Dockable, PlaceholderListItem<Dockable>>(){

                @Override
                public PlaceholderListItem<Dockable> convert(ConvertedPlaceholderListItem item) {
                    int id = item.getInt("id");
                    int index = item.getInt("index");
                    boolean hold = item.getBoolean("hold");
                    int size = item.getInt("size");
                    Path placeholder = null;
                    if (item.contains("placeholder")) {
                        placeholder = new Path(item.getString("placeholder"));
                    }
                    FlapDockProperty property = new FlapDockProperty(index, hold, size, placeholder);
                    children.getChild(id).setLocation(property);
                    int n = children.getSubChildCount(id);
                    for (int i = 0; i < n; ++i) {
                        DockLayoutInfo info = children.getSubChild(id, i);
                        info.setLocation(new FlapDockProperty(id, hold, size, info.getPlaceholder()));
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        FlapDockStation station = this.createStation();
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout layout, PlaceholderStrategy placeholders) {
        FlapDockStation station = this.createStation();
        this.setLayout(station, layout, placeholders);
        return station;
    }

    @Override
    public void write(FlapDockStationLayout layout, DataOutputStream out) throws IOException {
        if (layout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroLayout = (RetroFlapDockStationLayout)layout;
            Version.write(out, Version.VERSION_1_0_4);
            out.writeBoolean(layout.isAutoDirection());
            out.writeInt(layout.getDirection().ordinal());
            int count = retroLayout.getChildren().length;
            out.writeInt(count);
            for (int i = 0; i < count; ++i) {
                out.writeInt(retroLayout.getChildren()[i]);
                out.writeBoolean(retroLayout.getHolds()[i]);
                out.writeInt(retroLayout.getSizes()[i]);
            }
        } else {
            Version.write(out, Version.VERSION_1_0_8);
            out.writeBoolean(layout.isAutoDirection());
            out.writeInt(layout.getDirection().ordinal());
            layout.getPlaceholders().write(out);
        }
    }

    @Override
    public FlapDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version8 = Version.VERSION_1_0_8.compareTo(version) <= 0;
        boolean auto = in.readBoolean();
        FlapDockStation.Direction direction = FlapDockStation.Direction.values()[in.readInt()];
        if (version8) {
            PlaceholderMap map = new PlaceholderMap(in, placeholders);
            map.setPlaceholderStrategy(null);
            return new FlapDockStationLayout(auto, direction, map);
        }
        int count = in.readInt();
        int[] ids = new int[count];
        boolean[] holds = new boolean[count];
        int[] sizes = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = in.readInt();
            holds[i] = in.readBoolean();
            sizes[i] = in.readInt();
        }
        return new RetroFlapDockStationLayout(ids, holds, sizes, auto, direction);
    }

    @Override
    public void write(FlapDockStationLayout layout, XElement element) {
        if (layout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroLayout = (RetroFlapDockStationLayout)layout;
            XElement window = element.addElement("window");
            window.addBoolean("auto", layout.isAutoDirection());
            window.addString("direction", layout.getDirection().name());
            XElement children = element.addElement("children");
            int n = retroLayout.getChildren().length;
            for (int i = 0; i < n; ++i) {
                XElement child = children.addElement("child");
                child.addInt("id", retroLayout.getChildren()[i]);
                child.addBoolean("hold", retroLayout.getHolds()[i]);
                child.addInt("size", retroLayout.getSizes()[i]);
            }
        } else {
            XElement window = element.addElement("window");
            window.addBoolean("auto", layout.isAutoDirection());
            window.addString("direction", layout.getDirection().name());
            XElement children = element.addElement("placeholders");
            layout.getPlaceholders().write(children);
        }
    }

    @Override
    public FlapDockStationLayout read(XElement element, PlaceholderStrategy placeholders) {
        int i;
        int n;
        XElement window = element.getElement("window");
        XElement xplaceholders = element.getElement("placeholders");
        if (xplaceholders != null) {
            PlaceholderMap map = new PlaceholderMap(xplaceholders, placeholders);
            map.setPlaceholderStrategy(null);
            return new FlapDockStationLayout(window.getBoolean("auto"), FlapDockStation.Direction.valueOf(window.getString("direction")), map);
        }
        XElement children = element.getElement("children");
        XElement[] child = children.getElements("child");
        int[] ids = new int[child.length];
        boolean[] holds = new boolean[child.length];
        int[] sizes = new int[child.length];
        XAttribute sizeAttribute = window.getAttribute("size");
        if (sizeAttribute != null) {
            int size = sizeAttribute.getInt();
            for (int i2 = 0; i2 < sizes.length; ++i2) {
                sizes[i2] = size;
            }
        } else {
            n = child.length;
            for (i = 0; i < n; ++i) {
                sizes[i] = child[i].getInt("size");
            }
        }
        n = child.length;
        for (i = 0; i < n; ++i) {
            ids[i] = child[i].getInt("id");
            holds[i] = child[i].getBoolean("hold");
        }
        return new RetroFlapDockStationLayout(ids, holds, sizes, window.getBoolean("auto"), FlapDockStation.Direction.valueOf(window.getString("direction")));
    }

    protected FlapDockStation createStation() {
        return new FlapDockStation();
    }
}

