/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.DirectRemoteRelocator;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.control.relocator.AbstractDockRelocator;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.DefaultInserterSource;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.DropOperation;
import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.MergeOperation;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.MultiInserter;
import bibliothek.gui.dock.control.relocator.MultiMerger;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.control.relocator.StackMerger;
import bibliothek.gui.dock.control.relocator.TabMerger;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.OrderedLayerCollection;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import bibliothek.util.Workarounds;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDockRelocator
extends AbstractDockRelocator {
    public static final Path MERGE_EXTENSION = new Path("dock.merger");
    public static final Path INSERTER_EXTENSION = new Path("dock.inserter");
    public static final String EXTENSION_PARAM = "relocator";
    private boolean onMove = false;
    private boolean onPut = false;
    private RelocateOperation operation;
    private StationDragOperation dragOperation;
    private ImageWindow movingImageWindow;
    private Point pressPointScreen;
    private Point pressPointLocal;
    private Point lastPoint;
    private StationDropItem lastItem;

    public DefaultDockRelocator(DockController controller, ControllerSetupCollection setup) {
        super(controller);
        final MultiMerger merger = new MultiMerger();
        merger.add(new StackMerger());
        merger.add(new TabMerger());
        final MultiInserter inserter = new MultiInserter();
        setup.add(new ControllerSetupListener(){

            public void done(DockController controller) {
                controller.addRepresentativeListener(new Listener());
                List<Merger> mergers = controller.getExtensions().load(new ExtensionName<Merger>(MERGE_EXTENSION, Merger.class, DefaultDockRelocator.EXTENSION_PARAM, DefaultDockRelocator.this));
                for (Merger next : mergers) {
                    merger.add(next);
                }
                List<Inserter> inserters = controller.getExtensions().load(new ExtensionName<Inserter>(INSERTER_EXTENSION, Inserter.class, DefaultDockRelocator.EXTENSION_PARAM, DefaultDockRelocator.this));
                for (Inserter next : inserters) {
                    inserter.add(next);
                }
            }
        });
        this.setMerger(merger);
        this.setInserter(inserter);
    }

    @Override
    public boolean isOnMove() {
        return this.onMove;
    }

    @Override
    public boolean isOnPut() {
        return this.onPut;
    }

    @Override
    public boolean hasTarget() {
        return this.operation != null;
    }

    @Override
    public DirectRemoteRelocator createDirectRemote(Dockable dockable) {
        return this.createDirectRemote(dockable, false);
    }

    @Override
    public DirectRemoteRelocator createDirectRemote(Dockable dockable, boolean forceDrag) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        return new DefaultRemoteRelocator(dockable, forceDrag);
    }

    @Override
    public RemoteRelocator createRemote(Dockable dockable) {
        return this.createRemote(dockable, false);
    }

    @Override
    public RemoteRelocator createRemote(Dockable dockable, boolean forceDrag) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        return new DefaultRemoteRelocator(dockable, forceDrag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeOperation(Dockable dockable, RelocateOperation operation) {
        this.onPut = true;
        DockController controller = this.getController();
        controller.getRegister().setStalled(true);
        this.disableAllModes();
        try {
            boolean success = operation.execute(dockable, new VetoableDockRelocatorListener(){

                public void searched(DockRelocatorEvent event) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                public void grabbing(DockRelocatorEvent event) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                public void grabbed(DockRelocatorEvent event) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                public void dropping(DockRelocatorEvent event) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                public void dropped(DockRelocatorEvent event) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                public void dragging(DockRelocatorEvent event) {
                    DefaultDockRelocator.this.fireDragging(event);
                }

                public void dragged(DockRelocatorEvent event) {
                    DefaultDockRelocator.this.fireDragged(event);
                }

                public void canceled(DockRelocatorEvent event) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }
            });
            if (this.dragOperation != null) {
                if (success) {
                    this.dragOperation.succeeded();
                } else {
                    this.dragOperation.canceled();
                }
                this.dragOperation = null;
            }
            boolean bl = success;
            return bl;
        }
        finally {
            operation.destroy(null);
            operation = null;
            this.onPut = false;
            controller.getRegister().setStalled(false);
        }
    }

    private StationDropItem createStationDropItem(int mouseX, int mouseY, int titleX, int titleY, Dockable dockable) {
        this.lastItem = this.lastItem == null || this.lastItem.getDockable() != dockable ? new StationDropItem(mouseX, mouseY, titleX, titleY, dockable) : new StationDropItem(mouseX, mouseY, titleX, titleY, dockable, this.lastItem.getOriginalSize(), this.lastItem.getMinimumSize());
        return this.lastItem;
    }

    protected RelocateOperation preparePut(int mouseX, int mouseY, int titleX, int titleY, Dockable dockable) {
        List<DockStation> list = this.listStationsOrdered(mouseX, mouseY, dockable);
        Inserter inserter = this.getInserter();
        StationDropItem item = this.createStationDropItem(mouseX, mouseY, titleX, titleY, dockable);
        for (DockStation station : list) {
            StationDropOperation operation = null;
            DefaultInserterSource inserterSource = new DefaultInserterSource(station, item);
            if (inserter != null) {
                operation = inserter.before(inserterSource);
            }
            if (operation == null) {
                operation = station.prepareDrop(item);
                if (inserter != null) {
                    inserterSource.setOperation(operation);
                    operation = inserter.after(inserterSource);
                    if (operation == null) {
                        operation = inserterSource.getOperation();
                    }
                }
            }
            RelocateOperation result = null;
            boolean merge = this.canMerge(operation, station, dockable);
            if (operation != null) {
                result = merge ? new MergeOperation(this.getController(), this.getMerger(), station, operation, item) : new DropOperation(this.getController(), station, operation, item);
            }
            if (result == null) continue;
            DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, result.getImplicit(dockable), station, new Point(mouseX, mouseY));
            this.fireSearched(event);
            if (event.isForbidden()) {
                result = null;
            } else if (event.isCanceled()) {
                this.cancel();
                return null;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected boolean canMerge(StationDropOperation operation, DockStation parent, Dockable selection) {
        Merger merger = this.getMerger();
        if (merger == null) {
            return false;
        }
        DockStation child = selection.asDockStation();
        if (child == null) {
            return false;
        }
        if (DockUtilities.isAncestor(child, parent)) {
            return false;
        }
        if (selection.getDockParent() != null && !selection.getDockParent().canDrag(selection)) {
            return false;
        }
        MultiDockAcceptance acceptance = this.getController().getAcceptance();
        int n = child.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = child.getDockable(i);
            if (!child.canDrag(dockable)) {
                return false;
            }
            if (!parent.accept(dockable) || !dockable.accept(parent)) {
                return false;
            }
            if (acceptance.accept(parent, dockable)) continue;
            return false;
        }
        return merger.canMerge(operation, parent, child);
    }

    protected List<DockStation> listStationsOrdered(int x, int y, Dockable moved) {
        DockController controller = this.getController();
        DisablingStrategy disabling = controller.getProperties().get(DisablingStrategy.STRATEGY);
        OrderedLayerCollection collection = new OrderedLayerCollection();
        if (disabling == null || !disabling.isDisabled(moved)) {
            DockStation movedStation = moved.asDockStation();
            if (!this.isCancelLocation(x, y, moved)) {
                for (DockStation station : controller.getRegister().listDockStations()) {
                    if (disabling != null && disabling.isDisabled(station) || movedStation != null && (DockUtilities.isAncestor(movedStation, station) || movedStation == station) || !station.isStationShowing() || !this.isStationValid(station)) continue;
                    collection.add(station);
                }
            }
        }
        return collection.sort(x, y);
    }

    protected boolean isCancelLocation(int x, int y, Dockable moved) {
        if (this.isCancelLocation(x, y, (DockElementRepresentative)moved)) {
            return true;
        }
        DockController controller = moved.getController();
        for (DockElementRepresentative item : controller.getRepresentatives(moved)) {
            if (!this.isCancelLocation(x, y, item)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCancelLocation(int x, int y, DockElementRepresentative item) {
        return false;
    }

    protected boolean isStationValid(DockStation station) {
        return true;
    }

    protected void dragMousePressed(MouseEvent e, DockTitle title, Dockable dockable) {
        if (dockable == null) {
            dockable = title.getDockable();
        }
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, e.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMousePressed(point.x, point.y, e.getX(), e.getY(), e.getModifiersEx(), dockable, false);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            e.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMousePressed(int x, int y, int dx, int dy, int modifiers, Dockable dockable, boolean forceDrag) {
        if (!forceDrag && dockable.getDockParent() == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        this.lastPoint = new Point(x, y);
        int onmask = 1024;
        int offmask = 6144;
        if ((modifiers & (onmask | offmask)) == onmask) {
            this.titleDragCancel();
            this.onMove = false;
            this.pressPointScreen = new Point(x, y);
            this.pressPointLocal = new Point(dx, dy);
            this.checkModes(modifiers);
            return RemoteRelocator.Reaction.CONTINUE;
        }
        if (this.pressPointScreen != null) {
            this.titleDragCancel();
            this.disableAllModes();
            Dockable[] implicit = this.operation == null ? new Dockable[]{} : this.operation.getImplicit(dockable);
            DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, implicit, this.operation == null ? null : this.operation.getStation(), new Point(x, y));
            event.cancel();
            this.fireCanceled(event);
            return RemoteRelocator.Reaction.BREAK_CONSUMED;
        }
        return RemoteRelocator.Reaction.BREAK;
    }

    protected void dragMouseDragged(MouseEvent e, DockTitle title, Dockable dockable) {
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, e.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMouseDragged(point.x, point.y, e.getModifiersEx(), title, dockable, false, false);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            e.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMouseDragged(int x, int y, int modifiers, DockTitle title, Dockable dockable, boolean always, boolean forceDrag) {
        return this.dragMouseDragged(x, y, modifiers, title, dockable, always, forceDrag, true);
    }

    protected RemoteRelocator.Reaction dragMouseDragged(int x, int y, int modifiers, DockTitle title, Dockable dockable, boolean always, boolean forceDrag, boolean showMovingImage) {
        RemoteRelocator.Reaction result;
        if (this.pressPointScreen == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        this.checkModes(modifiers);
        if (dockable == null) {
            dockable = title.getDockable();
        }
        if (dockable == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        Point mouse = new Point(x, y);
        this.lastPoint = new Point(x, y);
        if (!this.onMove) {
            RemoteRelocator.Reaction result2;
            DockStation parent = dockable.getDockParent();
            if (!forceDrag && parent != null && !parent.canDrag(dockable)) {
                this.titleDragCancel();
                this.disableAllModes();
                return RemoteRelocator.Reaction.BREAK_CONSUMED;
            }
            int distance = Math.abs(x - this.pressPointScreen.x) + Math.abs(y - this.pressPointScreen.y);
            if ((always || distance >= this.getDragDistance()) && (result2 = this.initiateOperation(dockable, title, mouse, showMovingImage)) != null) {
                return result2;
            }
        }
        if (this.onMove && (result = this.selectNextTarget(dockable, title, mouse)) != null) {
            return result;
        }
        return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
    }

    private RemoteRelocator.Reaction initiateOperation(Dockable dockable, DockTitle title, Point mouse, boolean showMovingImage) {
        if (this.movingImageWindow != null) {
            this.movingImageWindow.close();
            this.movingImageWindow = null;
        }
        this.lastItem = null;
        Dockable[] implicit = new Dockable[]{};
        DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, implicit, null, mouse);
        this.fireGrabbing(event);
        if (event.isCanceled()) {
            event = new DefaultDockRelocatorEvent(this.getController(), dockable, implicit, null, mouse);
            event.cancel();
            this.fireCanceled(event);
            return RemoteRelocator.Reaction.BREAK_CONSUMED;
        }
        if (!event.isForbidden()) {
            if (showMovingImage) {
                this.movingImageWindow = this.getTitleWindow(dockable, title);
                if (this.movingImageWindow != null) {
                    this.updateTitleWindowPosition(mouse);
                    this.movingImageWindow.setVisible(true);
                }
            }
            this.onMove = true;
            DockStation parent = dockable.getDockParent();
            if (this.dragOperation != null) {
                this.dragOperation.canceled();
                this.dragOperation = null;
            }
            if (parent != null) {
                this.dragOperation = parent.prepareDrag(dockable);
            }
            event = new DefaultDockRelocatorEvent(this.getController(), dockable, implicit, null, mouse);
            this.fireGrabbed(event);
            if (event.isCanceled() || event.isForbidden()) {
                this.cancel(dockable);
                return RemoteRelocator.Reaction.BREAK_CONSUMED;
            }
        }
        return null;
    }

    private RemoteRelocator.Reaction selectNextTarget(Dockable dockable, DockTitle title, Point mouse) {
        if (this.movingImageWindow != null) {
            this.updateTitleWindowPosition(mouse);
        }
        RelocateOperation next = this.preparePut(mouse.x, mouse.y, mouse.x - this.pressPointLocal.x, mouse.y - this.pressPointLocal.y, dockable);
        boolean drop = false;
        Dockable[] implicit = next == null ? new Dockable[]{} : next.getImplicit(dockable);
        DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, implicit, next == null ? null : next.getStation(), mouse);
        this.fireDragged(event);
        if (event.isCanceled()) {
            this.cancel(dockable);
            return RemoteRelocator.Reaction.BREAK_CONSUMED;
        }
        if (event.isForbidden()) {
            next = null;
        }
        if (next != null) {
            boolean bl = drop = next != null && event.isDropping();
        }
        if (drop) {
            return this.dragMouseReleased(mouse.x, mouse.y, 0, dockable);
        }
        if (this.operation != null) {
            this.operation.destroy(next);
        }
        this.operation = next;
        if (next != null) {
            next.getOperation().draw();
        }
        return null;
    }

    private void updateTitleWindowPosition(Point mouse) {
        MovingImage image = this.movingImageWindow.getImage();
        Point offset = null;
        if (image != null) {
            offset = image.getOffset(new Point(this.pressPointLocal));
        }
        if (offset == null) {
            int width = Math.min(25, this.movingImageWindow.getWidth());
            int height = Math.min(25, this.movingImageWindow.getHeight());
            int delta = Math.min(width, height) + 1;
            int dx = Math.min(width, this.pressPointLocal.x);
            int dy = Math.min(height, this.pressPointLocal.y);
            this.movingImageWindow.setLocation(mouse.x - dx + delta, mouse.y - dy + delta);
        } else {
            this.movingImageWindow.setLocation(mouse.x + offset.x, mouse.y + offset.y);
        }
    }

    protected void dragMouseReleased(MouseEvent e, DockTitle title, Dockable dockable) {
        if (dockable == null) {
            dockable = title.getDockable();
        }
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, e.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMouseReleased(point.x, point.y, e.getModifiersEx(), dockable);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            e.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMouseReleased(int x, int y, int modifiers, Dockable dockable) {
        this.checkModes(modifiers);
        int offmask = 7168;
        boolean stop = !this.onMove || (modifiers & offmask) == 0;
        Point mouse = new Point(x, y);
        if (stop && this.onMove) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DefaultDockRelocator.this.onMove = false;
                }
            });
        }
        if (!this.onMove) {
            boolean wasDragging = this.pressPointScreen != null;
            this.titleDragCancel();
            this.disableAllModes();
            if (stop) {
                DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, new Dockable[0], null, mouse);
                event.cancel();
                this.fireCanceled(event);
                if (wasDragging) {
                    return RemoteRelocator.Reaction.BREAK_CONSUMED;
                }
                return RemoteRelocator.Reaction.BREAK;
            }
            return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
        }
        boolean consume = false;
        DefaultDockRelocatorEvent dropped = null;
        if (stop) {
            if (this.pressPointScreen != null) {
                Dockable[] implicit;
                RelocateOperation operation = this.operation;
                if (x != this.lastPoint.x || y != this.lastPoint.y) {
                    RelocateOperation next = this.preparePut(x, y, x - this.pressPointLocal.x, y - this.pressPointLocal.y, dockable);
                    if (next != null) {
                        Dockable[] implicit2 = next.getImplicit(dockable);
                        DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, implicit2, next.getStation(), mouse);
                        this.fireCanceled(event);
                        if (event.isCanceled() || event.isForbidden()) {
                            next = null;
                        }
                    }
                    if (operation != null && (next == null || operation.getStation() != next.getStation())) {
                        operation.destroy(next);
                    }
                    operation = next;
                }
                if (operation != null) {
                    implicit = operation.getImplicit(dockable);
                    DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, implicit, operation.getStation(), mouse);
                    event.drop();
                    this.fireDropping(event);
                    if (event.isCanceled() || event.isForbidden()) {
                        operation.destroy(null);
                        operation = null;
                    }
                }
                if (operation != null) {
                    consume = true;
                    implicit = operation.getImplicit(dockable);
                    boolean canceled = !this.executeOperation(dockable, operation);
                    operation.destroy(null);
                    this.operation = null;
                    dropped = new DefaultDockRelocatorEvent(this.getController(), dockable, implicit, operation.getStation(), mouse);
                    if (canceled) {
                        dropped.cancel();
                        this.fireCanceled(dropped);
                        dropped = null;
                    }
                } else {
                    DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, new Dockable[0], null, mouse);
                    event.cancel();
                    this.fireCanceled(event);
                }
            }
            if (this.movingImageWindow != null) {
                this.movingImageWindow.close();
            }
            this.lastItem = null;
            if (this.dragOperation != null) {
                this.dragOperation.canceled();
                this.dragOperation = null;
            }
            this.movingImageWindow = null;
            this.pressPointScreen = null;
            this.pressPointLocal = null;
        }
        if (dropped != null) {
            this.fireDropped(dropped);
        }
        if (stop) {
            this.disableAllModes();
            return consume ? RemoteRelocator.Reaction.BREAK_CONSUMED : RemoteRelocator.Reaction.BREAK;
        }
        return consume ? RemoteRelocator.Reaction.CONTINUE_CONSUMED : RemoteRelocator.Reaction.CONTINUE;
    }

    @Override
    public void cancel() {
        if (this.operation != null) {
            this.cancel(this.operation.getOperation().getItem());
        }
    }

    private void cancel(Dockable dockable) {
        this.titleDragCancel();
        DefaultDockRelocatorEvent event = new DefaultDockRelocatorEvent(this.getController(), dockable, new Dockable[0], null, null);
        event.cancel();
        this.fireCanceled(event);
    }

    private void titleDragCancel() {
        if (!this.isOnPut()) {
            if (this.operation != null) {
                this.operation.destroy(null);
                this.operation = null;
            }
            if (this.dragOperation != null) {
                this.dragOperation.canceled();
                this.dragOperation = null;
            }
            if (this.movingImageWindow != null) {
                this.movingImageWindow.close();
            }
            this.lastItem = null;
            this.movingImageWindow = null;
            this.pressPointScreen = null;
            this.pressPointLocal = null;
        }
    }

    private ImageWindow getTitleWindow(Dockable dockable, DockTitle title) {
        DockController controller = this.getController();
        DockableMovingImageFactory factory = controller.getProperties().get(DockTheme.DOCKABLE_MOVING_IMAGE_FACTORY);
        MovingImage image = title == null ? factory.create(controller, dockable) : factory.create(controller, title);
        if (image == null) {
            return null;
        }
        Window parent = title == null ? SwingUtilities.getWindowAncestor(dockable.getComponent()) : SwingUtilities.getWindowAncestor(title.getComponent());
        ImageWindow window = new ImageWindow(parent, image);
        window.pack();
        return window;
    }

    private class ImageWindow
    extends JWindow {
        private MovingImage image;

        public ImageWindow(Window parent, MovingImage image) {
            super(parent);
            this.addComponentListener(new ComponentListener(){

                public void componentHidden(ComponentEvent e) {
                }

                public void componentMoved(ComponentEvent e) {
                }

                public void componentResized(ComponentEvent e) {
                }

                public void componentShown(ComponentEvent e) {
                    if (ImageWindow.this != DefaultDockRelocator.this.movingImageWindow) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ImageWindow.this.close();
                            }
                        });
                    }
                }
            });
            Container content = this.getContentPane();
            content.setLayout(new GridLayout(1, 1));
            this.setFocusableWindowState(false);
            try {
                this.setAlwaysOnTop(true);
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            boolean transparency = Workarounds.getDefault().makeTransparent(this);
            image.bind(transparency);
            content.add(image.getComponent());
            this.image = image;
        }

        public MovingImage getImage() {
            return this.image;
        }

        public void close() {
            this.dispose();
            if (this.image != null) {
                this.image.unbind();
                this.image = null;
            }
            this.getContentPane().removeAll();
        }
    }

    private class MouseRepresentativeListener
    extends MouseInputAdapter {
        private DockTitle title;
        private Dockable dockable;
        private DockElementRepresentative representative;

        public MouseRepresentativeListener(DockElementRepresentative representative) {
            this.representative = representative;
            if (representative instanceof DockTitle) {
                this.title = (DockTitle)representative;
            }
            this.dockable = representative.getElement().asDockable();
        }

        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMousePressed(e, this.title, this.dockable);
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMouseReleased(e, this.title, this.dockable);
        }

        public void mouseDragged(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitel()) {
                return;
            }
            DefaultDockRelocator.this.dragMouseDragged(e, this.title, this.dockable);
        }
    }

    private class Listener
    implements DockControllerRepresentativeListener {
        private Map<DockElementRepresentative, MouseRepresentativeListener> listeners = new HashMap<DockElementRepresentative, MouseRepresentativeListener>();

        private Listener() {
        }

        public void representativeAdded(DockController controller, DockElementRepresentative representative) {
            if (representative.getElement().asDockable() != null) {
                MouseRepresentativeListener listener = new MouseRepresentativeListener(representative);
                this.listeners.put(representative, listener);
                representative.addMouseInputListener(listener);
            }
        }

        public void representativeRemoved(DockController controller, DockElementRepresentative representative) {
            MouseRepresentativeListener listener;
            if (representative.getElement().asDockable() != null && (listener = this.listeners.remove(representative)) != null) {
                representative.removeMouseInputListener(listener);
            }
        }
    }

    private class DefaultRemoteRelocator
    implements RemoteRelocator,
    DirectRemoteRelocator {
        private Dockable dockable;
        private DockTitle title;
        private boolean forceDrag;
        private boolean showMovingImage = true;

        public DefaultRemoteRelocator(Dockable dockable, boolean forceDrag) {
            this.dockable = dockable;
            this.forceDrag = forceDrag;
        }

        public void setTitle(DockTitle title) {
            this.title = title;
        }

        public void setShowImageWindow(boolean imageWindow) {
            this.showMovingImage = imageWindow;
        }

        public void cancel() {
            DefaultDockRelocator.this.titleDragCancel();
            DefaultDockRelocator.this.onMove = false;
        }

        public void drag(int x, int y, boolean always) {
            DefaultDockRelocator.this.dragMouseDragged(x, y, 1024, this.title, this.dockable, always, this.forceDrag, this.showMovingImage);
        }

        public RemoteRelocator.Reaction drag(int x, int y, int modifiers) {
            return DefaultDockRelocator.this.dragMouseDragged(x, y, modifiers, this.title, this.dockable, false, this.forceDrag, this.showMovingImage);
        }

        public void drop(int x, int y) {
            this.drop(x, y, 0);
        }

        public RemoteRelocator.Reaction drop(int x, int y, int modifiers) {
            return DefaultDockRelocator.this.dragMouseReleased(x, y, modifiers, this.dockable);
        }

        public void init(int x, int y, int dx, int dy) {
            this.init(x, y, dx, dy, 1024);
        }

        public RemoteRelocator.Reaction init(int x, int y, int dx, int dy, int modifiers) {
            return DefaultDockRelocator.this.dragMousePressed(x, y, dx, dy, modifiers, this.dockable, this.forceDrag);
        }
    }
}

