/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.AbstractFocusController;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.EnsuringFocusRequest;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.control.focus.FocusStrategyRequest;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class DefaultFocusController
extends AbstractFocusController {
    private Dockable focusedDockable = null;
    private boolean onFocusing = false;
    private List<Request> pendingRequests = new ArrayList<Request>();

    public DefaultFocusController(DockController controller) {
        super(controller);
    }

    public boolean isOnFocusing() {
        return this.onFocusing;
    }

    public Dockable getFocusedDockable() {
        return this.focusedDockable;
    }

    public FocusVetoListener.FocusVeto checkFocusedDockable(DockElementRepresentative source) {
        if (source == null) {
            return null;
        }
        Dockable dockable = source.getElement().asDockable();
        if (dockable == null) {
            return null;
        }
        FocusVetoListener.FocusVeto veto = source instanceof DockTitle ? this.fireVetoTitle((DockTitle)source) : this.fireVetoDockable(dockable);
        if (veto == null) {
            return FocusVetoListener.FocusVeto.NONE;
        }
        return veto;
    }

    public FocusVetoListener.FocusVeto setFocusedDockable(DockElementRepresentative source, Component component, boolean force, boolean ensureFocusSet, boolean ensureDockableFocused) {
        DefaultFocusRequest request = new DefaultFocusRequest(source, component, force, ensureFocusSet, ensureDockableFocused);
        this.enqueue(request);
        return request.getVeto();
    }

    public void ensureFocusSet(boolean dockableOnly) {
        Dockable dockable = this.focusedDockable;
        if (dockable != null) {
            this.enqueue(new EnsuringFocusRequest(dockable, dockableOnly));
        }
    }

    public void enqueue(FocusRequest request) {
        Request next = new Request(request, false);
        next.enqueue();
    }

    protected Component accept(final FocusRequest request, final Dockable dockable) {
        Component replacement;
        if (this.isFrozen()) {
            return null;
        }
        if (!request.validate(this)) {
            return null;
        }
        FocusVetoListener.FocusVeto veto = this.checkFocusedDockable(request.getSource());
        if (veto == null) {
            veto = FocusVetoListener.FocusVeto.NONE;
        }
        request.veto(veto);
        if (veto != FocusVetoListener.FocusVeto.NONE) {
            return null;
        }
        FocusStrategy strategy = this.getStrategy();
        Component component = request.getComponent();
        if (strategy != null && dockable != null && (replacement = strategy.getFocusComponent(new FocusStrategyRequest(){

            public Component getMouseClicked() {
                return request.getComponent();
            }

            public Dockable getDockable() {
                return dockable;
            }

            public boolean excluded(Component component) {
                return !request.acceptable(component);
            }
        })) != null) {
            component = replacement;
        }
        if (component == null && dockable != null) {
            component = dockable.getComponent();
        }
        if (!(component == null || this.pendingRequests.size() <= 1 || component.isVisible() && component.isShowing())) {
            component = null;
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(final FocusRequest request, Dockable dockable, final Component component) {
        List<Request> list = this.pendingRequests;
        synchronized (list) {
            for (Request pending : this.pendingRequests) {
                pending.cancel();
            }
            this.pendingRequests.clear();
        }
        boolean active = true;
        if (EventQueue.isDispatchThread()) {
            active = this.grant(request, component);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DefaultFocusController.this.grant(request, component);
                }
            });
        }
        if (active && dockable != this.focusedDockable) {
            Dockable oldFocused = this.focusedDockable;
            this.focusedDockable = dockable;
            this.fireDockableFocused(oldFocused, this.focusedDockable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean grant(FocusRequest request, Component component) {
        FocusRequest next;
        try {
            this.onFocusing = true;
            next = request.grant(component);
        }
        finally {
            this.onFocusing = false;
        }
        if (next != null) {
            boolean accepted = request.getSource() == next.getSource() && component == next.getComponent();
            Request nextRequest = new Request(next, accepted);
            return nextRequest.enqueue();
        }
        return true;
    }

    private class Request
    implements ActionListener {
        private boolean accepted = false;
        private FocusRequest request;
        private boolean canceled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request(FocusRequest request, boolean accepted) {
            this.request = request;
            this.accepted = accepted;
            List list = DefaultFocusController.this.pendingRequests;
            synchronized (list) {
                DefaultFocusController.this.pendingRequests.add(this);
            }
        }

        public boolean enqueue() {
            if (this.request.getDelay() <= 0) {
                this.run();
                return true;
            }
            Timer timer = new Timer(this.request.getDelay(), this);
            timer.setRepeats(false);
            timer.start();
            return false;
        }

        public void cancel() {
            this.canceled = true;
        }

        public Dockable getDockable() {
            DockElementRepresentative source = this.request.getSource();
            if (source == null) {
                return null;
            }
            return source.getElement().asDockable();
        }

        private Component accept() {
            if (this.accepted) {
                return this.request.getComponent();
            }
            return DefaultFocusController.this.accept(this.request, this.getDockable());
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            if (!this.canceled) {
                Component component = this.accept();
                if (component != null) {
                    DefaultFocusController.this.execute(this.request, this.getDockable(), component);
                } else if (this.request.getSource() == null && this.request.getComponent() == null && DefaultFocusController.this.pendingRequests.size() == 1) {
                    DefaultFocusController.this.execute(this.request, null, null);
                } else {
                    List list = DefaultFocusController.this.pendingRequests;
                    synchronized (list) {
                        DefaultFocusController.this.pendingRequests.remove(this);
                    }
                }
            }
        }
    }
}

