/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.disable.ActionDisablingStrategyObserver;
import bibliothek.gui.dock.event.StandardDockActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardDockAction
implements StandardDockAction {
    protected List<StandardDockActionListener> listeners = new ArrayList<StandardDockActionListener>();
    private Map<Dockable, Integer> bound = new HashMap<Dockable, Integer>();
    private ActionDisablingStrategyObserver disabling;

    public AbstractStandardDockAction(boolean monitorDisabling) {
        if (monitorDisabling) {
            this.disabling = new ActionDisablingStrategyObserver(this){

                @Override
                protected void setDisabled(Set<Dockable> dockable, boolean disabled) {
                    AbstractStandardDockAction.this.fireActionEnabledChanged(dockable);
                }

                @Override
                protected void setDisabled(Dockable dockable, boolean disabled) {
                    HashSet<Dockable> set = new HashSet<Dockable>(1);
                    set.add(dockable);
                    AbstractStandardDockAction.this.fireActionEnabledChanged(set);
                }
            };
        }
    }

    @Override
    public void addDockActionListener(StandardDockActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDockActionListener(StandardDockActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void bound(Dockable dockable) {
    }

    protected void unbound(Dockable dockable) {
    }

    public boolean isBound(Dockable dockable) {
        return this.bound.containsKey(dockable);
    }

    public Set<Dockable> getBoundDockables() {
        return Collections.unmodifiableSet(this.bound.keySet());
    }

    @Override
    public void bind(Dockable dockable) {
        Integer old;
        if (this.disabling != null) {
            this.disabling.bind(dockable);
        }
        if ((old = this.bound.get(dockable)) == null) {
            this.bound.put(dockable, 1);
            this.bound(dockable);
        } else {
            this.bound.put(dockable, old + 1);
        }
    }

    @Override
    public void unbind(Dockable dockable) {
        Integer old;
        if (this.disabling != null) {
            this.disabling.unbind(dockable);
        }
        if ((old = this.bound.get(dockable)) == null) {
            try {
                throw new NullPointerException("Unbind called too often, omit unbind and continue");
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        } else if (old == 1) {
            this.bound.remove(dockable);
            this.unbound(dockable);
        } else {
            this.bound.put(dockable, old - 1);
        }
    }

    @Override
    public boolean isEnabled(Dockable dockable) {
        if (this.disabling == null) {
            return true;
        }
        return !this.disabling.isDisabled(dockable);
    }

    protected void fireActionTextChanged(Set<Dockable> dockables) {
        for (StandardDockActionListener listener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            listener.actionTextChanged(this, dockables);
        }
    }

    protected void fireActionTooltipTextChanged(Set<Dockable> dockables) {
        for (StandardDockActionListener listener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            listener.actionTooltipTextChanged(this, dockables);
        }
    }

    protected void fireActionIconChanged(ActionContentModifier modifier, Set<Dockable> dockables) {
        for (StandardDockActionListener listener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            listener.actionIconChanged(this, modifier, dockables);
        }
    }

    protected void fireActionEnabledChanged(Set<Dockable> dockables) {
        for (StandardDockActionListener listener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            listener.actionEnabledChanged(this, dockables);
        }
    }

    protected void fireActionRepresentativeChanged(Set<Dockable> dockables) {
        for (StandardDockActionListener listener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            listener.actionRepresentativeChanged(this, dockables);
        }
    }
}

