/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.AbstractBubbleDockTitle;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Condition;
import bibliothek.util.Path;
import java.awt.Color;

public class BubbleDockTitle
extends AbstractBubbleDockTitle {
    public BubbleDockTitle(Dockable dockable, DockTitleVersion origin) {
        this(dockable, origin, true);
    }

    public BubbleDockTitle(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        this.init(dockable, origin, showMiniButtons);
    }

    protected BubbleDockTitle() {
    }

    protected void init(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        super.init(dockable, origin, showMiniButtons);
        this.initAnimation();
        this.updateAnimation();
    }

    private void initAnimation() {
        Path path = TitleColor.KIND_TITLE_COLOR;
        this.addColor("title.background.top.active.mouse", path, Color.RED);
        this.addColor("title.background.top.active", path, Color.LIGHT_GRAY);
        this.addColor("title.background.top.inactive.mouse", path, Color.BLUE);
        this.addColor("title.background.top.inactive", path, Color.DARK_GRAY);
        this.addColor("title.background.top.disabled", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.active.mouse", path, Color.LIGHT_GRAY);
        this.addColor("title.background.bottom.active", path, Color.WHITE);
        this.addColor("title.background.bottom.inactive.mouse", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.inactive", path, Color.BLACK);
        this.addColor("title.background.bottom.disabled", path, Color.BLACK);
        this.addColor("title.foreground.active.mouse", path, Color.BLACK);
        this.addColor("title.foreground.active", path, Color.BLACK);
        this.addColor("title.foreground.inactive.mouse", path, Color.WHITE);
        this.addColor("title.foreground.inactive", path, Color.WHITE);
        this.addConditionalFont("title.active", TitleFont.KIND_TITLE_FONT, new Condition(){

            public boolean getState() {
                return BubbleDockTitle.this.isActive();
            }
        }, null);
        this.addConditionalFont("title.inactive", TitleFont.KIND_TITLE_FONT, new Condition(){

            public boolean getState() {
                return !BubbleDockTitle.this.isActive();
            }
        }, null);
    }

    protected void updateAnimation() {
        this.updateFonts();
        String postfix = "";
        if (this.isDisabled()) {
            this.updateAnimation("text", "title.foreground.inactive");
            this.updateAnimation("top", "title.background.top.disabled");
            this.updateAnimation("bottom", "title.background.bottom.disabled");
        } else {
            postfix = this.isActive() ? (this.isMouseOver() ? "active.mouse" : "active") : (this.isMouseOver() ? "inactive.mouse" : "inactive");
            String top = "title.background.top." + postfix;
            String bottom = "title.background.bottom." + postfix;
            String text = "title.foreground." + postfix;
            this.updateAnimation("text", text);
            this.updateAnimation("top", top);
            this.updateAnimation("bottom", bottom);
        }
    }
}

