/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.gui.DockController;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPreferenceModel
implements PreferenceModel {
    private List<PreferenceModelListener> listeners = new ArrayList<PreferenceModelListener>();
    private DockController controller;

    public AbstractPreferenceModel(DockController controller) {
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    public void read() {
    }

    public void write() {
    }

    public boolean isEnabled(int index, PreferenceOperation operation) {
        return false;
    }

    public PreferenceOperation[] getOperations(int index) {
        return null;
    }

    public void doOperation(int index, PreferenceOperation operation) {
    }

    public void addPreferenceModelListener(PreferenceModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removePreferenceModelListener(PreferenceModelListener listener) {
        this.listeners.remove(listener);
    }

    protected PreferenceModelListener[] listeners() {
        return this.listeners.toArray(new PreferenceModelListener[this.listeners.size()]);
    }

    protected boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    protected void firePreferenceAdded(int beginIndex, int endIndex) {
        for (PreferenceModelListener listener : this.listeners) {
            listener.preferenceAdded(this, beginIndex, endIndex);
        }
    }

    protected void firePreferenceRemoved(int beginIndex, int endIndex) {
        for (PreferenceModelListener listener : this.listeners) {
            listener.preferenceRemoved(this, beginIndex, endIndex);
        }
    }

    protected void firePreferenceChanged(int beginIndex, int endIndex) {
        for (PreferenceModelListener listener : this.listeners) {
            listener.preferenceChanged(this, beginIndex, endIndex);
        }
    }

    public String getDescription(int index) {
        return null;
    }

    public boolean isNatural(int index) {
        return false;
    }

    public void setValueNatural(int index) {
    }
}

