/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.inspector;

import java.awt.Component;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JScrollPane;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.inspector.BasicValuesPositionColorModifier;
import org.exbin.framework.bined.inspector.gui.BasicValuesPanel;
import org.exbin.framework.bined.inspector.preferences.DataInspectorPreferences;
import org.exbin.framework.bined.preferences.BinaryEditorPreferences;

@ParametersAreNonnullByDefault
public class BinEdComponentInspector
implements BinEdComponentPanel.BinEdComponentExtension {
    private BinEdComponentPanel componentPanel;
    private BasicValuesPanel valuesPanel;
    private boolean parsingPanelVisible = false;
    private JScrollPane valuesPanelScrollPane;
    private BasicValuesPositionColorModifier basicValuesColorModifier;

    public void onCreate(BinEdComponentPanel componentPanel) {
        this.componentPanel = componentPanel;
        ExtCodeArea codeArea = componentPanel.getCodeArea();
        this.valuesPanel = new BasicValuesPanel();
        this.valuesPanel.setCodeArea(codeArea, null);
        if (this.basicValuesColorModifier != null) {
            this.valuesPanel.registerFocusPainter(this.basicValuesColorModifier);
        }
        this.valuesPanelScrollPane = new JScrollPane(this.valuesPanel);
        this.valuesPanelScrollPane.setBorder(null);
        this.setShowParsingPanel(true);
    }

    public void setApplication(XBApplication application) {
    }

    public void onDataChange() {
    }

    public void onUndoHandlerChange() {
        if (this.valuesPanel != null) {
            this.valuesPanel.setCodeArea(this.componentPanel.getCodeArea(), this.componentPanel.getUndoHandler().orElse(null));
        }
    }

    public void onInitFromPreferences(BinaryEditorPreferences preferences) {
        DataInspectorPreferences dataInspectorPreferences = new DataInspectorPreferences(preferences.getPreferences());
        this.setShowParsingPanel(dataInspectorPreferences.isShowParsingPanel());
    }

    public void onClose() {
    }

    public void setShowParsingPanel(boolean show) {
        if (this.parsingPanelVisible != show) {
            if (show) {
                this.componentPanel.add((Component)this.valuesPanelScrollPane, (Object)"East");
                this.componentPanel.revalidate();
                this.parsingPanelVisible = true;
                this.valuesPanel.enableUpdate();
            } else {
                this.valuesPanel.disableUpdate();
                this.componentPanel.remove((Component)this.valuesPanelScrollPane);
                this.componentPanel.revalidate();
                this.parsingPanelVisible = false;
            }
        }
    }

    public boolean isShowParsingPanel() {
        return this.parsingPanelVisible;
    }

    public void setBasicValuesColorModifier(BasicValuesPositionColorModifier basicValuesColorModifier) {
        this.basicValuesColorModifier = basicValuesColorModifier;
    }
}

